<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers:username,password,destination,content-type");
include("conn.php");
include("functions.php");
  
$response = array();
$response["status"] = false;
$response["message"] = "Un Authorized";
$headers = getallheaders();
$myUserName =isset($headers["Username"])?$headers["Username"]:$headers["username"];
$myPassword =isset($headers["Password"])?$headers["Password"]:$headers["password"];
$myUserName = mysqli_real_escape_string($conn,$myUserName);
$myPassword =   mysqli_real_escape_string($conn,$myPassword);

//echo $username.$password;
 if(login($myUserName,$myPassword)){//check credentials

$type = $_GET["type"];
$response["message"] = "Un Authorized $type";
if($type=="vehiclemake"){
	/*
	params.put("Description", vehicleMake);
                        params.put("Code",pl.getCode());
	*/
	$description = trim($_POST["Description"]);
	$code = trim($_POST["Code"]);
	if(is_numeric($code)){
		if(strlen($description)<1){
			$response["status"] = false;
			$response["message"] = "Please specify a valid value for the vehicle name";
		}else{
			//check if exists, update else create
			$check = "SELECT * FROM `vehiclemakes` where Code = '$code'";
			$res = mysqli_query($conn, $check);
			$sql ="";
			$values = array();
			$update = false;
			if(mysqli_num_rows($res )>0){ //exists, update
				$sql = "UPDATE `vehiclemakes` SET `Description`=? WHERE `Code` = ?";
				$values = array($description, $code);
				$update = true;
			}else{ //create
				$sql = "INSERT INTO `vehiclemakes`(`Description`) VALUES (?)";
				$values = array($description);
			}
			if( pdoExecute($sql, $values)){
				$response["status"] = true;
				$response["message"] = "The Vehicle make was successfully ";
				$response["message"].=$update?"updated":"added";
			}else{
				$response["status"] = false;
				$response["message"] = "The vehicle make could not be added. Please try again.";
			}
		}
	}else{
		$response["status"] = false;
		$response["message"] = "The vehicle make could not be added";
	}
	
}
else if($type=="vehiclemodel"){
	$code = trim($_POST["Code"]);
	$model = trim($_POST["Model"]);
	$make = trim($_POST["Make"]);
	$capacity = trim($_POST["Capacity"]);
	$dailyFee = trim($_POST["DailyFee"]);
	if($model==""&&$make==""&&$capacity=""&&$dailyFee==""){
		$response["status"] = false;
		$response["message"] = "The vehicle model could not be added. Please try again later";
	}else{
		//insert or update
		//check if exists else update
		$check = "SELECT * FROM `vehiclemodels` where Code = '$code'";
		$res = mysqli_query($conn, $check);
		$update = false;
		$sql = "";
		$values = array();
		if(mysqli_num_rows($res)>0){//update
			$update = true;
			$sql = "UPDATE `vehiclemodels` SET `Description`=?,`Make`=?,`Capacity`=?,`DailyFee`=? WHERE `Code` = ?";
			$values = array($model,$make,$capacity,$dailyFee,$code);
		}else{ //insert
			$sql = "INSERT INTO `vehiclemodels`(`Description`, `Make`, `Capacity`, `DailyFee`) VALUES (?,?,?,?)";
			$values = array($model,$make,$capacity,$dailyFee);
		}
		if( pdoExecute($sql, $values)){
			$response["status"] = true;
			$response["message"] = "The vehicle model was successfully ";
			$response["message"] .=	$update?"updated":"added";
		}else{
			$response["status"] = false;
			$response["message"] = "The vehicle model could not be added. Please try again later";
		}
	}
}
else if($type=="loanProduct"){
	$productCode = trim($_POST["productCode"]);
	$productName = trim($_POST["productName"]);
	$minimumAmount = trim($_POST["minimumAmount"]);
	$maximumAmount = trim($_POST["maximumAmount"]);
	$minimumInstallments = trim($_POST["minimumInstallments"]);
	$maximumInstallments = trim($_POST["maximumInstallments"]);
	$interestRate = trim($_POST["interestRate"]);
	$calculationMethod = trim($_POST["calculationMethod"]);
	$minimumGuarantors = trim($_POST["minimumGuarantors"]);
	$maximumGuarantors = trim($_POST["maximumGuarantors"]);
	$contributionMultiplier = trim($_POST["contributionMultiplier"]);
	$user ="1";
	
	//check that no other loan product has the code
	$myCode = mysqli_real_escape_string($conn, $productCode);
	$check = "select *  from loanssetup where Code = '$myCode'";
	$checkRes = mysqli_query($conn,$check);
	if(mysqli_num_rows($checkRes)>0){
		/*$response["status"] = false;
		$response["message"] = "There is another loan product with the same loan product code.\n Please use a different code";*/
		$sql = "update `loanssetup` set `LoanName` = ?, `MinimumAmount` = ?, `MaximumAmount`= ?, `MinimumInstallments`= ?, `MaximumInstallments` = ?, `InterestRate` = ?, `CalculationMethod` = ?,  `MinimumNumberOfGuarantors` = ?, `MaximumNumberOfGuarantors` = ?, `ShareMultiplicationFactor` = ? where `Code` = ?";
		$values = array($productName,$minimumAmount,$maximumAmount,$minimumInstallments,$maximumInstallments,$interestRate,$calculationMethod,$minimumGuarantors,$maximumGuarantors,$contributionMultiplier,$productCode);
		if( pdoExecute($sql, $values)){
			$response["status"] = true;
			$response["message"] = "The loan product was successfully updated ";
		}else{
			$response["status"] = false;
			$response["message"] = "The loan product could not be updated. Please try again. ";
		}
	}else{
		$sql = "INSERT INTO `loanssetup`(`Code`, `LoanName`, `MinimumAmount`, `MaximumAmount`, `MinimumInstallments`, `MaximumInstallments`, `InterestRate`, `CalculationMethod`,  `MinimumNumberOfGuarantors`, `MaximumNumberOfGuarantors`, `ShareMultiplicationFactor`, `AddedBy`, `AddedOn`) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,NOW())";
		$values = array($productCode,$productName,$minimumAmount,$maximumAmount,$minimumInstallments,$maximumInstallments,$interestRate,$calculationMethod,$minimumGuarantors,$maximumGuarantors,$contributionMultiplier,$user);
		if( pdoExecute($sql, $values)){
			$response["status"] = true;
			$response["message"] = "The loan product was successfully added ";
		}else{
			$response["status"] = false;
			$response["message"] = "The loan product could not be added. Please try again. ";
		}
					
	}
	
}
else if($type=="paymentmethods"){
	$code = trim($_POST["code"]);
	$description = trim($_POST["description"]);
	$requiresRef = trim($_POST["requiresRef"]);
	$check = "SELECT * FROM `paymentmethods` where Id = '$code'";
	$res  = mysqli_query($conn, $check);
	$sql = "";
	$values = array();
	$update = false;
	if(mysqli_num_rows($res )>0){ //update
	$update = true;
		$sql = "UPDATE `paymentmethods` SET `PaymentMethod`=?,`RequiresRef`=? WHERE Id = ?";
		$values = array($description,$requiresRef,$code);
	}else{//insert
		$sql = "INSERT INTO `paymentmethods`(`PaymentMethod`, `RequiresRef`) VALUES (?,?)";
		$values = array($description,$requiresRef );
	}
	if( pdoExecute($sql, $values)){
		$response["status"] = true;
		$response["message"] = "The payment method was successfully ";
		$response["message"] .= $update?"updated":"added";
	}else{
		$response["status"] = false;
		$response["message"] = "The payment method could not be added";
	}
}
else if($type=="customerreceipt"){
	$receiptNo = trim($_POST["receiptNo"]);
	$customerNo = trim($_POST["customerNo"]);
	$bankCode = trim($_POST["bankCode"]);
	$paymentMethod = trim($_POST["paymentMethod"]);
	$paymentRef = trim($_POST["paymentRef"]);
	$paymentDate = trim($_POST["paymentDate"]);
	$paymentType = trim($_POST["paymentType"]);
	$withholding_income = trim($_POST["withholdingVAT"]);
	$withholding_vat = trim($_POST["withholdingIncome"]);

	//$receivedFrom = trim($_POST["receivedFrom"]);
	//$paymentDescription = trim($_POST["paymentDescription"]);
	$amount = trim($_POST["amount"]);
	if(!is_numeric($amount)){//reject
		$response["status"] = false;
		$response["message"] = "Please enter a valid value for amount";
	}else{
		//check exists
		$tReceiptNo = mysqli_real_escape_string($conn,$receiptNo);
		$checkSql = "SELECT * FROM `customerreceipts` where receiptNo = '$tReceiptNo'";
		$checkRes = mysqli_query($conn, $checkSql);
		if(mysqli_num_rows($checkRes)>0){//update
		
		//check if it has been posted
		while($checkResult = mysqli_fetch_assoc($checkRes)){
			if($checkResult["posted"]){
					$response["status"] = false;
				$response["message"] = "The customer receipt has already been posted. No changes can be made.";
			}else{
				$sql = "UPDATE `customerreceipts` SET `customer`=?,`bank`=?,`paymentmethod`=?,`externalRef`=?,`paymentDate`=?,`amount`=?, `payment_type`=?, `withholding_income`=?, `withholding_vat`=? WHERE `receiptNo` = ? and `posted` = 0";
				$values = array($customerNo,$bankCode,$paymentMethod,$paymentRef,$paymentDate,$amount,$paymentType,$withholding_income,$withholding_vat,$receiptNo);
				if(pdoExecute($sql, $values)){
					$response["status"] = true;
					$response["message"] = "The customer receipt was successfully updated.";
					$lines = json_decode($_POST["lines"],true);
					$linesSql ="";
					$lineValues = array();
					foreach($lines as $line){
						$lineAmount = $line["amountToApply"];
						if($lineAmount<>0){
							$invoiceNo = $line["invoiceNo"];
							$description = $invoiceNo;
							$invoiceNo= $invoiceNo=="Advance Payment"?"":$invoiceNo;
							$linesSql.=strlen($linesSql)>0?",":"";
							$linesSql.="(?,?,?,?,NOW(),?)";
							$lineValues = array_merge($lineValues,array($receiptNo,$invoiceNo,$description,$lineAmount,$myUserName));
						}
					}
					pdoExecute("delete from customer_receipt_lines where receipt_no=?",array($receiptNo));
					$linesSql = "INSERT INTO `customer_receipt_lines`(`receipt_no`, `invoice_no`, `description`, `total_amount`, `added_on`, `added_by`) VALUES $linesSql";
					pdoExecute($linesSql,$lineValues);			
				}else{
					$response["status"] = false;
					$response["message"] = "The customer receipt could not be updated. Please try again";
				}
			}
		}
		}else{ //insert
			$sql = "INSERT INTO `customerreceipts`(`receiptNo`, `customer`, `bank`, `paymentmethod`, `externalRef`, `paymentDate`,`amount`, `payment_type`, `withholding_income`, `withholding_vat`,`createdBy`, `createdOn`, `posted`) VALUES (?,?,?,?,?,?,?,?, ?,?,?,NOW(), 0)";
			$values = array($receiptNo,$customerNo,$bankCode,$paymentMethod,$paymentRef,$paymentDate, $amount,$paymentType,$withholding_income,$withholding_vat,$myUserName);
			if(pdoExecute($sql, $values)){
				$lines = json_decode($_POST["lines"],true);
				$linesSql ="";
				$lineValues = array();
				foreach($lines as $line){
					$lineAmount = $line["amountToApply"];
					if($lineAmount<>0){
						$invoiceNo = $line["invoiceNo"];
						$description = $invoiceNo;
						$invoiceNo= $invoiceNo=="Advance Payment"?"":$invoiceNo;
						$linesSql.=strlen($linesSql)>0?",":"";
						$linesSql.="(?,?,?,?,NOW(),?)";
						$lineValues = array_merge($lineValues,array($receiptNo,$invoiceNo,$description,$lineAmount,$myUserName));
					}
				}
				$linesSql = "INSERT INTO `customer_receipt_lines`(`receipt_no`, `invoice_no`, `description`, `total_amount`, `added_on`, `added_by`) VALUES $linesSql";
				pdoExecute($linesSql,$lineValues);
				$response["status"] = true;
				$response["message"] = "The customer receipt was successfully created.";
				$response["overLoad1"] = $receiptNo;
				$response["overLoad2"] = "";
				$sql = "SELECT * FROM `customerreceipts` where receiptNo = '$tReceiptNo'";
				$res = mysqli_query($conn, $checkSql);
				//getCreatedOn
				while($result = mysqli_fetch_assoc($res)){
					$createdOn =$result["createdOn"];
					$dateDetails = explode(" ", $createdOn);
					$response["overLoad2"] = $dateDetails[0];
				}
				//[{"id":0,"":"EOD0127","grossAmount":0.0,"withHoldingTax":0.0,"withHoldingVAT":0.0,"totalAmount":0.0,"invoiceDate":"2023-11-23","invoiceAmount":518273.5,"paidAmount":0.0,"balance":0.0,"amountToApply":94397.5,"manualApplication":false}
				//clear lines //add line

				
			}else{
				$response["status"] = false;
				$response["message"] = "The customer receipt could not be created. Please try again";
			}
		}
	}
}
else if($type=="pettycashvoucherlines"){
	
	$chargeItem = trim($_POST["chargeItem"]);
	$pcvNo = trim($_POST["pcvNo"]);
	$amount = trim($_POST["amount"]);
	$description = trim($_POST["description"]);
	$regionCode =isset($_POST["regionCode"])? intval($_POST["regionCode"]):0;
	$salesRep =isset($_POST["salesRep"])? trim($_POST["salesRep"]):"";
	$vehicle =isset($_POST["vehicle"])? trim($_POST["vehicle"]):"";
	$kiloMetres =isset($_POST["kiloMetres"])? doubleval($_POST["kiloMetres"]):0;
	//check amount is numeric
	if(is_numeric($amount)){
	
	//check pcv is not posted and exists
	$tpcvNo = mysqli_real_escape_string($conn, $pcvNo);
	$tChargeItem = mysqli_real_escape_string($conn, $chargeItem);
	$check = "SELECT * FROM `pettycashvouchers` WHERE pcvNo = '$tpcvNo' and posted = 0";
	$checkRes = mysqli_query($conn,$check);
	if(mysqli_num_rows($checkRes)>0){
	//check no other charge item has the same code
	$checkNoRepeat = "SELECT * FROM `pettycashvoucherlines` WHERE `chargeitem`='$tChargeItem' and `pcvNo` = '$tpcvNo'";
	$noRepeatRes = mysqli_query($conn, $checkNoRepeat);
	/*if(mysqli_num_rows($noRepeatRes)>0){
			$response["status"] = false;
			$response["message"] = "You have already added the item to the payment voucher. \n Please select another item or adjust the amount.";
	}else{*/
		//insert
		$sql = "INSERT INTO `pettycashvoucherlines`( `chargeitem`,`description`, `pcvNo`, `amount`,`region_code`, `sales_rep`, `vehicle`, `kilo_metres`, `addedOn`) VALUES (?,?,?,?,?,?,?,?,NOW())";
		$values = array($chargeItem,$description, $pcvNo,$amount,$regionCode,$salesRep,$vehicle,$kiloMetres);
		if(pdoExecute($sql, $values)){
			$response["status"] = true;
			$response["message"] = "The item was successfully added";
		}else{
			$response["status"] = false;
			$response["message"] = "The item could not be added. Please try again later";
		}
	//}
	
	}else{
		$response["status"] = false;
		$response["message"] = "A petty cash voucher with the given number does not exist or has already been posted";
	}
	}else{
		$response["status"] = false;
		$response["message"] = "Please use a valid value for amount";
	}
	
	
}
else if($type=="vendor"){
	$vendorNumber = trim($_POST["vendorNumber"]);
	$name = trim($_POST["name"]);
	$idNo = trim($_POST["idNo"]);
	$phoneNo = trim($_POST["phoneNo"]);
	$email = trim($_POST["email"]);
	$pin = trim($_POST["pin"]);
	$dob = trim($_POST["dob"]);
	$bankName = trim($_POST["bankName"]);
	$bankBranch = trim($_POST["bankBranch"]);
	$branchCode = trim($_POST["branchCode"]);
	$bankAccountNo = trim($_POST["bankAccountNo"]);
	$photo = trim($_POST["photo"]);
	$postingGroup = trim($_POST["postingGroup"]);
	$vendorType = trim($_POST["vendorType"]);
	$region = trim($_POST["region"]);
	$contactPerson = trim($_POST["contactPerson"]);
	$contactPhone = trim($_POST["contactPhone"]);
	$contactPosition = trim($_POST["contactPosition"]);
	$contactEmailAddress = trim($_POST["contactEmailAddress"]);
	$remarks = trim($_POST["remarks"]);

	//check vendor exists
	$tVendorNo = mysqli_real_escape_string($conn, $vendorNumber);
	$sql = "SELECT * FROM `vendors` where vendorNumber = '$tVendorNo'";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)>0){ //update
		$response["status"] = false;
		$response["message"] = "A vendor with the entered vendor number already exists.";
		
	}else{ //insert
		$sql = "INSERT INTO `vendors`(`vendorNumber`, `name`,`idNo`, `kraPin`, `dateofbirth`, `phoneNumber`, `email`,  `vendorImage`, `vendorpostinggroup`, `bankName`, `bankBranch`, `branchCode`,`bankAccountNo`,`vendortype`,`regionCode`,`contactName`, `jobPosition`, `contactPhone`, `contactEmail`, `remarks`,`createdOn`,`createdBy`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),?)";
		$values = array($vendorNumber,$name,$idNo,$pin, $dob, $phoneNo,$email,$photo,$postingGroup,$bankName,$bankBranch,$branchCode,$bankAccountNo,$vendorType,$region,$contactPerson,$contactPosition,$contactPhone,$contactEmailAddress,$remarks,$myUserName);
		if(pdoExecute($sql, $values)){
			$response["status"] = true;
			$response["message"] = "The vendor was successfully created";
		}else{
			$response["status"] = false;
			$response["message"] = "The vendor could not be created";
		}
	}
	
}
else if($type=="paymentvoucher"){
	$voucherNo = trim($_POST["voucherNo"]);
	$vendorNo = trim($_POST["vendorNo"]);
	$bankCode = trim($_POST["bankCode"]);
	$paymentMethod = trim($_POST["paymentMethod"]);
	$paymentRef = trim($_POST["paymentRef"]);
	$paymentDate = trim($_POST["paymentDate"]);
	$amount = trim($_POST["amount"]);
	$paymentType = trim($_POST["paymentType"]);
	$regionCode = trim($_POST["regionCode"]);
	
	$withholdingVAT = trim($_POST["withholdingVAT"]);
	$withholdingIncome = trim($_POST["withholdingIncome"]);
	if(!is_numeric($amount)){//reject
		$response["status"] = false;
		$response["message"] = "Please enter a valid value for amount";
	}else{
		//check exists
		$tVoucherNo = mysqli_real_escape_string($conn,$voucherNo);
		$checkSql = "SELECT * FROM `paymentvouchers` where pvNo = '$tVoucherNo'";
		$checkRes = mysqli_query($conn, $checkSql);
		if(mysqli_num_rows($checkRes)>0){//update
		
		//check if it has been posted
		while($checkResult = mysqli_fetch_assoc($checkRes)){
			if($checkResult["posted"]){
				$response["status"] = false;
				$response["message"] = "The payment voucher has already been posted. No changes can be made.";
			}else{
			        $sql = "update `paymentvouchers` set `vendor`=?, `region_code`=?,`bank`=?, `paymentmethod`=?, `externalRef`=?, `paymentDate`=?,  `amount`=?,`payment_type`=?, `withholding_vat`=?, `withholding_income`=? where `pvNo`=? and `posted`=?";
			        $values = array($vendorNo,$regionCode,$bankCode,$paymentMethod,$paymentRef,$paymentDate,$amount,$paymentType,$withholdingVAT,$withholdingIncome,$voucherNo,0);
			        if(pdoExecute($sql, $values)){
			            pdoExecute("delete from payment_voucher_lines where voucher_no=?",array($voucherNo));
			        	$response["status"] = true;
			        	$response["message"] = "The payment voucher was successfully updated.";
			        	$response["overLoad1"] = $voucherNo;
			        	$response["overLoad2"] = "";
			        	$lines = json_decode($_POST["lines"],true);
			        	$linesSql ="";
			        	$lineValues = array();
			        	foreach($lines as $line){
			        		$lineAmount = $line["amountToApply"];
			        		if($lineAmount<>0){
			        			$invoiceNo = $line["invoiceNo"];
			        			$description = $invoiceNo;
			        			$invoiceNo= $invoiceNo=="Advance Payment"?"":$invoiceNo;
			        			$linesSql.=strlen($linesSql)>0?",":"";
			        			$linesSql.="(?,?,?,?,NOW(),?)";
			        			$lineValues = array_merge($lineValues,array($voucherNo,$invoiceNo,$description,$lineAmount,$myUserName));
			        		}
			        	}
			        	$linesSql = "INSERT INTO `payment_voucher_lines`(`voucher_no`, `invoice_no`, `description`, `total_amount`, `added_on`, `added_by`) VALUES $linesSql";
			        	pdoExecute($linesSql,$lineValues);
			        }
			}
		}
			        	
		}else{ //insert
			$sql = "INSERT INTO `paymentvouchers`(`pvNo`, `vendor`,`region_code`, `bank`, `paymentmethod`, `externalRef`, `paymentDate`,  `amount`,`payment_type`, `withholding_vat`, `withholding_income`, `createdBy`, `createdOn`, `posted`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?, NOW(), ?)";
			$values = array($voucherNo,$regionCode,$vendorNo,$bankCode,$paymentMethod,$paymentRef,$paymentDate,$amount,$paymentType,$withholdingVAT,$withholdingIncome,$myUserName,0);
			if(pdoExecute($sql, $values)){
				$response["status"] = true;
				$response["message"] = "The payment voucher was successfully created.";
				$response["overLoad1"] = $voucherNo;
				$response["overLoad2"] = "";
				$lines = json_decode($_POST["lines"],true);
				$linesSql ="";
				$lineValues = array();
				foreach($lines as $line){
					$lineAmount = $line["amountToApply"];
					if($lineAmount<>0){
						$invoiceNo = $line["invoiceNo"];
						$description = $invoiceNo;
						$invoiceNo= $invoiceNo=="Advance Payment"?"":$invoiceNo;
						$linesSql.=strlen($linesSql)>0?",":"";
						$linesSql.="(?,?,?,?,NOW(),?)";
						$lineValues = array_merge($lineValues,array($voucherNo,$invoiceNo,$description,$lineAmount,$myUserName));
					}
				}
				$linesSql = "INSERT INTO `payment_voucher_lines`(`voucher_no`, `invoice_no`, `description`, `total_amount`, `added_on`, `added_by`) VALUES $linesSql";
				pdoExecute($linesSql,$lineValues);
				
				
			}else{
				$response["status"] = false;
				$response["message"] = "The payment voucher could not be created. Please try again";
			}
		}
		}
}
else if($type=="mobitillvoucher"){
	$voucherNo = trim($_POST["voucherNo"]);
	$user = "1";
	$sql = "INSERT INTO `mobitillvouchers`(`voucherNo`, `createdOn`, `createdBy`, `posted`) VALUES (?,NOW(), ?, 0)";
	$values = array($voucherNo,$user);
	if(pdoExecute($sql, $values)){
		$response["status"] = true;
		$response["message"] = "The voucher was successfully created";
		$voucherNo = mysqli_real_escape_string($conn, $voucherNo);
		$sql = "select * from mobitillvouchers where voucherNo = '$voucherNo'";
		$res = mysqli_query($conn, $sql);
		while($result = mysqli_fetch_assoc($res)){
			$response["overLoad1"] = $result["voucherNo"];
			$date = explode(" ", $result["createdOn"]);
			$response["overLoad2"] =$date[0] ;
		}
	}else{
		$response["status"] = false;
		$response["message"] = "The voucher could not be created. Please try again";
	}
	
}
else if($type=="mobitillline"){
	$deviceName = trim($_POST["deviceName"]);
	$memberName = trim($_POST["memberName"]);
	$memberNumber = trim($_POST["memberNumber"]);
	$mode = trim($_POST["mode"]);
	$productName = strtolower(trim($_POST["productName"]));
	$quantity = trim($_POST["quantity"]);
	$ticketNo = trim($_POST["ticketNo"]);
	$date = trim($_POST["timestamp"]);
	$date = str_ireplace("/","-",$date);
	$dates = explode(" ",$date);
	$myDate = $dates[0];
	$myTime = $dates[1];
	$dateParts = explode("-", $myDate);
	$day = $dateParts[0];
	$month = $dateParts[1];
	$year = $dateParts[2];
	if(strlen($year)==2){
		$year = "20".$year;
	}
	$myTimes = explode(":",$myTime);
	$hour = $myTimes[0];
	$minute = $myTimes[1];
	$timestamp = $year."-".$month."-".$day." ".$hour.":".$minute.":00";
	//echo $timestamp;
	$total = trim($_POST["total"]);
	$vehicleNo = strtoupper(trim($_POST["vehicleNo"]));
	$vehicleNo = str_ireplace(" ","", $vehicleNo);
	$voucherNo = trim($_POST["voucherNo"]);
	$error = false;
	$memberNo = "";
	$loanNo = "";
	$message = "";
	$tVehicleNo = mysqli_real_escape_string($conn, $vehicleNo);
	
	//validate
	//total is numeric
	if(!is_numeric($total)){
		$error = true;
		$message = "Total amount should be a numeric figure";
	}	
	//vehicle exists
	
	//vehicle must have an owner
	$sql = "SELECT * FROM `vehicles` WHERE `RegNo` = '$tVehicleNo'";
	$res = mysqli_query($conn, $sql);
	$dontCheck = false;
	$excempt = array("limuru","khoja","naivasha","accra");
	if(in_array($productName,$excempt)){
		$dontCheck = true;
	}
	if(mysqli_num_rows($res)>0){
		while($result = mysqli_fetch_assoc($res)){
			//
			$owner = mysqli_real_escape_string($conn, trim($result["Owner"]));
			$memberNo = $owner;
			$checkTransfer = "SELECT * FROM `vehicletransfer` WHERE vehicle= '$tVehicleNo' and posted = 1 and transferDate>'$timestamp' ORDER by transferDate DESC";
			$transferRes = mysqli_query($conn,$checkTransfer);
			$lineStamp = strtotime($timestamp);
			while($transferResult = mysqli_fetch_assoc($transferRes)){
				$transferDateStamp = strtotime($transferResult["transferDate"]);
				if($lineStamp<$transferDateStamp){
					$owner = mysqli_real_escape_string($conn, trim($transferResult["previousOwner"]));
					$memberNo = $owner;
				}
			}
		$types = array("sacco","share capital","limuru","line money","service fee arrears","sacco arrears","service fee","khoja","naivasha","savings","loan","accra","fine","kce198r","project");
		if(!in_array($productName,$types)){
			$error = true;
			$message .=strlen($message)>0?"\n":"";
			$message .= "The given transaction type does not exist";
		}else{
			if($productName=="Loan"){
				$loans = "SELECT A.*,B.*,C.*,D.*,(select sum(Debit)-sum(Credit) from loanledgerentries where LoanNumber = A.LoanNo)as loanBalance,E.id as disbursementId,E.mode,(SELECT COUNT(*) FROM loansregister where loansregister.Issued=true and LoanProductCode=D.Code) as loansIssued FROM `loansregister` as A left join members as B on A.MemberNo = B.MemberNo left join banks as C on A.Payingbank = C.Id left join loanssetup as D on A.LoanProductCode = D.Code LEFT join loandisbursementmodes E on A.LoanDisbursementMode = E.id  where A.Issued = 1 and A.MemberNo ='$owner'";
				$loansRes = mysqli_query($conn, $loans);
				$hasLoan = false;
				while($loanResult = mysqli_fetch_assoc($loansRes)){
					$loanBalance = $loanResult["loanBalance"];
					if($loanBalance>=$total){
						$hasLoan = true;
						$loanNo  = $loanResult["LoanNo"];
						break;
					}
				}
				if(!$hasLoan){
					$error = true;
					$message .=strlen($message)>0?"\n":"";
					$message .= "The selected member does not have an outstanding loan";
				}
				
			}
		}
		
		}
	}else{
		if(!$dontCheck){
		$error = true;
		$message .=strlen($message)>0?"\n":"";
		$message .= "A vehicle with the given registration does not exist";
		}
	}
	//if loan, member must have a loan
	
	
//check if line exists productname, ticketNo, total, vehicleNo
		/*$tProductName  = mysqli_real_escape_string($conn, $productName);
		$tTicketNo  = mysqli_real_escape_string($conn, $ticketNo);
		$tTotal  = mysqli_real_escape_string($conn, $total);
		$tVehicleNo  = mysqli_real_escape_string($conn, $vehicleNo);
		$sqlCheck = "select * from mobitillvoucherlines where productname = '$tProductName' and ticketNo = '$tTicketNo' and total = '$tTotal' and vehicleNo = '$tVehicleNo'";
		$sqlRes = mysqli_query($conn,$sqlCheck);
		if(mysqli_num_rows($sqlRes)>0){
			$error = true;
			$message .="A similar transaction already exists";
		}*/
		$error= $error?1:0;
	$sql = "INSERT INTO `mobitillvoucherlines`(`devicename`, `mode`, `productname`, `quantity`, `ticketNo`, `timeStamp`, `total`, `vehicleNo`,`memberNo`, `loanNo`, `error`, `hasError`, `voucherNo`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
	$values = array($deviceName,$mode,$productName,$quantity,$ticketNo,$timestamp,$total, $vehicleNo,$memberNo,$loanNo,$message, $error, $voucherNo);
	if(pdoExecute($sql, $values)){
		$response["status"] = true;
		$response["message"] = "The line was successfully added";
	}else{
		$response["status"] = false;
		$response["message"] = "The line could not be added";
	}
}
else if($type=="adduser"){
	$userName = trim($_POST["userName"]);
	$fullName = trim($_POST["fullName"]);
	$emailAddress = trim($_POST["emailAddress"]);
	$phoneNumber = trim($_POST["phoneNumber"]);
	$password = trim($_POST["password"]);
	$employeeCode = trim($_POST["employeeCode"]);
	$roleId = trim($_POST["roleId"]);
	$warehouse = trim($_POST["warehouse"]);
	$customerAccount = trim($_POST["customerAccount"]);
	$pricingGroup = trim($_POST["pricingGroup"]);
	$bank = trim($_POST["bank"]);
	
	
	
	//username is required
	//username atleast 4 characters
	//full name is required
	//password is required
	//password minimum 4 characters
	$error = false;
	$message = "";
	if($userName==""){
		$message = "Username is required";
		$error = true;
	}
	if(strlen($userName)<4){
		$message.= strlen($message)>0?"\n":"";
		$message .= "Username must be atleast 4 characters";
		$error = true;
	}
	if($fullName==""){
		$message.= strlen($message)>0?"\n":"";
		$message .= "Fullname is required";
		$error = true;
	}
	if($password==""){
		$message = "Password is required";
		$error = true;
	}
	if(strlen($password)<4){
		$message.= strlen($message)>0?"\n":"";
		$message .= "Password must be atleast 4 characters";
		$error = true;
	}
	if($error){
		$response["status"] = false;
		$response["message"] =$message;
	}else{
		//insert
		//check that no one else has the same userName
		$tUserName = mysqli_real_escape_string($conn, $userName);
		$check = "select * from users where username = '$tUserName'";
		$checkRes = mysqli_query($conn,$check);
		if(mysqli_num_rows($checkRes)>0){
			$response["status"] = false;
			$response["message"] = "There is another User with the same username. Please choose a different username";
		}else{
			$password = hash("sha256", $password);
			$sql = "INSERT INTO `users`(`username`, `fullname`, `email`, `phone`,`Password`,`employee_code`, `roleId`,`store_location`,`receivables_acccount`,`pricing_group`,`default_bank`,`Status`, `AddedOn`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,NOW())";
			$values = array($userName,$fullName,$emailAddress,$phoneNumber,$password,$employeeCode,$roleId,$warehouse,$customerAccount,$pricingGroup,$bank,1);
			if(pdoExecute($sql, $values)){			
				$response["status"] = true;
				$response["message"] = "The User was successfully Added";
			}else{			
				$response["status"] = false;
				$response["message"] = "The User could not be added";
			}
		}
	}
}
else if($type=="guarantor"){
	$loanNo = trim($_POST["loanNo"]);
	$guarantor = trim($_POST["guarantor"]);
	$amountToGuarantee = trim($_POST["amountToGuarantee"]);
	$tLoanNo = mysqli_real_escape_string($conn,$loanNo);
	$tGuarantor = mysqli_real_escape_string($conn,$guarantor);
	//check loan exists, not issued
	//check if guarantor already added
	$sql = "select * FROM `loansregister` where LoanNo = '$tLoanNo'";
	$checkRes = mysqli_query($conn, $sql);
	if(mysqli_num_rows($checkRes)==1){
		while($checkResult = mysqli_fetch_assoc($checkRes)){
			if($checkResult["Issued"]){
				$response["status"] = false;
				$response["message"] = "The loan has already been issued. No changes can be made";
			}else{
				$checkGuarantor = "SELECT * FROM `loanguarantors` WHERE loan = '$tLoanNo' and member = '$tGuarantor'";
				$guarantorRes = mysqli_query($conn,$checkGuarantor);
				if(mysqli_num_rows($guarantorRes)>0){
					$sql = "update `loanguarantors`  SET amount_to_guarantee = ? WHERE loan = ? and member = ?";
					$values = array($amountToGuarantee,$loanNo,$guarantor);
					if(pdoExecute($sql, $values)){
						$response["status"] = true;
						$response["message"] = "The loan guarantor was successfully updated";
					}else{
						$response["status"] = false;
						$response["message"] = "The loan guarantor could not be updated";
					}
				}else{
					$sql = "INSERT INTO `loanguarantors`(`loan`, `member`, `amount_to_guarantee`, `percentage_to_guarantee`) VALUES (?,?,?,0)";
					$values = array($loanNo, $guarantor, $amountToGuarantee);
					if(pdoExecute($sql, $values)){
						$response["status"] = true;
						$response["message"] = "The loan guarantor was successfully added";
					}else{
						$response["status"] = false;
						$response["message"] = "The loan guarantor could not be added";
					}
				}
			}
		}
	}else{
		$response["status"] = false;
		$response["message"] = "A loan with the given number does not exist";
	}
	}
else if($type=="collateral"){
	$loanNo = trim($_POST["loanNo"]);
	$regNo = trim($_POST["regNo"]);
	$vehicleValue = trim($_POST["vehicleValue"]);
	$logbookreceived = trim($_POST["logbookreceived"]);
	$tLoanNo = mysqli_real_escape_string($conn,$loanNo);
	$tRegNo = mysqli_real_escape_string($conn,$regNo);
	$sql = "select * FROM `loansregister` where LoanNo = '$tLoanNo'";
	$checkRes = mysqli_query($conn, $sql);
	if(mysqli_num_rows($checkRes)==1){
		while($checkResult = mysqli_fetch_assoc($checkRes)){
			if($checkResult["Issued"]){
				$response["status"] = false;
				$response["message"] = "The loan has already been issued. No changes can be made";
			}else{
				$checkGuarantor = "SELECT * FROM `loan_collateral` WHERE loan = '$tLoanNo' and vehicle_no = '$tRegNo'";
				$guarantorRes = mysqli_query($conn,$checkGuarantor);
				if(mysqli_num_rows($guarantorRes)>0){
					$sql = "update `loan_collateral`  SET `vehicle_value` = ?, `log_book_received`= ? WHERE loan = ? and vehicle_no = ?";
					$values = array($vehicleValue, $logbookreceived, $loanNo, $regNo);
					if(pdoExecute($sql, $values)){
						$response["status"] = true;
						$response["message"] = "The loan collateral was successfully updated";
					}else{
						$response["status"] = false;
						$response["message"] = "The loan collateral could not be updated";
					}
				}else{
					$sql = "INSERT INTO `loan_collateral`( `loan`, `vehicle_no`, `vehicle_value`, `log_book_received`, `added_on`, `added_by`) VALUES (?,?,?,?,NOW(), 1)";
					$values = array($loanNo, $regNo, $vehicleValue, $logbookreceived);
					if(pdoExecute($sql, $values)){
						$response["status"] = true;
						$response["message"] = "The loan collateral was successfully added";
					}else{
						$response["status"] = false;
						$response["message"] = "The loan collateral could not be added";
					}
				}
			}
		}
	}else{
		$response["status"] = false;
		$response["message"] = "A loan with the given number does not exist";
	}
	}
else if($type=="interestvoucher"){
	$voucherNo = trim($_POST["voucherNo"]);
	$month = trim($_POST["month"]);
	$year = trim($_POST["year"]);
	$tMonth = mysqli_real_escape_string($conn, $month);
	$tYear = mysqli_real_escape_string($conn, $year);
	$tVoucherNo = mysqli_real_escape_string($conn,$voucherNo);
	$sql = "SELECT * FROM `interestvoucher` WHERE `voucherNo` = '$tVoucherNo'";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)>0){ //exists
		while($result = mysqli_fetch_assoc($res)){
			if($result["posted"]){
				$response["status"] = false;
				$response["message"] = "The interest voucher has already been posted";
			}else{
				$checkMonth = "select * from interestvoucher where month = '$tMonth' and year = '$tYear' and not `voucherNo` = '$tVoucherNo'";
				$monthRes = mysqli_query($conn, $checkMonth);
				if(mysqli_num_rows($monthRes)>0){
					$response["status"] = false;
					$response["message"] = "There is another interest voucher with the same month and year. Please select a different month or year.";
				}else{
					$sql = "update `interestvoucher` set `month` = ?, `year` = ? where voucherNo = ?";
					$values = array($month,$year,$voucherNo);
					if(pdoExecute($sql, $values)){
						calculateInterest($voucherNo);
						$response["status"] = true;
						$response["message"] = "The interest voucher was successfully updated";
								
					}else{
						$response["status"] = false;
						$response["message"] = "The interest voucher could not be updated";
					}
				}
			}
		}
		
	}else{ //create a new voucher
		$checkMonth = "select * from interestvoucher where month = '$tMonth' and year = '$tYear'";
		$monthRes = mysqli_query($conn, $checkMonth);
		if(mysqli_num_rows($monthRes)>0){
			$response["status"] = false;
			$response["message"] = "There is another interest voucher with the same month and year. Please select a different month or year.";
		}else{
		$sql = "INSERT INTO `interestvoucher`(`voucherNo`, `month`, `year`, `createdBy`, `createdOn`, `posted`) VALUES (?, ?,?,?,NOW(),0)";
			$values = array($voucherNo,$month,$year, "1");
			if(pdoExecute($sql, $values)){
			$sql = "SELECT * FROM `interestvoucher` WHERE `voucherNo` = '$tVoucherNo'";
						$res = mysqli_query($conn, $sql);
						if(mysqli_num_rows($res)>0){
							while($result= mysqli_fetch_assoc($res)){
								calculateInterest($voucherNo);
								$response["status"] = true;
								$response["message"] = "The interest voucher was successfully created";
								$dates = explode(" ", $result["createdOn"]);
								$response["overLoad1"] =$dates[0];
							}
						}else{
								$response["status"] = false;
								$response["message"] = "The interest voucher could not be created";
					
						}}else{
				$response["status"] = false;
				$response["message"] = "The interest voucher could not be created";
			}
		}
	}
	
}	
else if($type=="addinvestment"){
    $investmentNo = trim($_POST["investmentNo"]);
    $investmentName = trim($_POST["investmentName"]);
    $investmentDescription = trim($_POST["investmentDescription"]);
    $startDate = trim($_POST["startDate"]);
    $glAccount = trim($_POST["glAccount"]);
    $tIvestmentNo = mysqli_real_escape_string($conn, $investmentNo);    
    $check = "SELECT * FROM `investments` where `investmentNo` = '$tIvestmentNo'";    
    $res = mysqli_query($conn, $check);	
    if (mysqli_num_rows($res)<1){
        $sql = "INSERT INTO investments(`investmentNo`, `investmentName`, `description`,`glAccount`, `startDate`, `createdBy`, `createdOn`) VALUES (?, ?,?,?,?,?,NOW())";
        $values = array ($investmentNo,$investmentName,$investmentDescription,$glAccount,$startDate, "");
    
    if(pdoExecute($sql, $values)){
	    $response["status"] = true;
	    $response["message"] = "Investment was successfully added";
    }else{
	    $response["status"] = false;
	    $response["message"] = "Investment could not be added";
    }
	
      }

    else{
        $sql = "update  investments set `investmentName` = ?, `description` = ?,`glAccount`=?, `startDate` = ? where `investmentNo` = ?";
        $values = array ($investmentName,$investmentDescription,$glAccount, $startDate, $investmentNo);
    
		if(pdoExecute($sql, $values)){
			$response["status"] = true;
			$response["message"] = "Investment was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "Investment could not be updated";
		}
    }
    
}
else if($type=="savingswithdrawalvoucher"){
	$voucherNo = trim($_POST["voucherNo"]);
	$tVoucherNo = mysqli_real_escape_string($conn,$voucherNo);
	$withdrawalDate = trim($_POST["withdrawalDate"]);
	$bankCode = trim($_POST["bankCode"]);
	$memberNo = trim($_POST["memberNo"]);
	$amount = trim($_POST["amount"]);
	$withdrawalFee = trim($_POST["withdrawalFee"]);
	$withdrawalPurpose = trim($_POST["withdrawalPurpose"]);
	$withdrawalDescription = trim($_POST["withdrawalDescription"]);
	$chequeNo = trim($_POST["chequeNo"]);
	
	$sql="SELECT * FROM `savingswithdrawal` WHERE `voucherNo` ='$tVoucherNo'";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)>0){
		while($result = mysqli_fetch_assoc($res)){
			if($result["posted"]){
				$response["status"] = false;
				$response["message"] = "The withdrawal voucher has already \n been posted";
			}else{
				$sql = "UPDATE `savingswithdrawal` SET `withdrawalDate`=?,`bank`=?,`member`=?,`amount`=?, `withdrawalFee` = ?, `withdrawalPurpose` = ?, `withdrawalDescription` = ?, `chequeNo` = ? WHERE `voucherNo`=?";
				$values = array($withdrawalDate, $bankCode,$memberNo,$amount,$withdrawalFee, $withdrawalPurpose,$withdrawalDescription,$chequeNo, $voucherNo);
				if(pdoExecute($sql, $values)){
						$response["status"] = true;
						$response["message"] = "The voucher was successfully updated";
					}else{
						$response["status"] = false;
						$response["message"] = "The withdrawal voucher could not be updated";
				}
			}
		}
	}else{
		//insert
		$sql = "INSERT INTO `savingswithdrawal`(`voucherNo`, `withdrawalDate`, `bank`, `member`, `amount`,`withdrawalFee`, `withdrawalPurpose`, `withdrawalDescription`, `chequeNo`,`createdBy`, `createdOn`, `posted`) VALUES (?,?,?,?,?,?,?,?,?,?,NOW(), 0)";
		$values = array($voucherNo,$withdrawalDate, $bankCode,$memberNo,$amount,$withdrawalFee, $withdrawalPurpose,$withdrawalDescription,$chequeNo, "1"  );
		if(pdoExecute($sql, $values)){
				$response["status"] = true;
				$response["message"] = "The voucher was successfully created";
			}else{
				$response["status"] = false;
				$response["message"] = "The withdrawal voucher could not be created";
		}
		
	}
}
else if($type=="importReceipt"){
	$receiptNo = trim($_POST["receiptNo"]);
	$loanNo = trim($_POST["loanNo"]);
	$date = trim($_POST["date"]);
	$amount = trim($_POST["amount"]);
	$insert = "INSERT INTO `receiptheader`(`ReceiptNo`, `Member`, `Bank`, `PaymentMethod`, `ExternalRefNo`, `PaymentDate`, `ReceivedFrom`, `CreatedBy`, `Posted`, `CreatedOn`) VALUES
	(?,(SELECT `MemberNo` FROM `loansregister` where LoanNo = ?),'5','3','',?,(SELECT FirstName FROM `members` WHERE MemberNo = (SELECT `MemberNo` FROM `loansregister` where LoanNo = ?)),'1',0,NOW())";
	$values = array($receiptNo,$loanNo,$date,$loanNo);
	pdoExecute($insert, $values);
	$insertLine = "INSERT INTO `receiptline`(`ReceiptNo`, `TransactionType`, `LoanNo`, `Amount`, `vehicle`, `addedOn`, `addedBy`) VALUES 
	(?,'311',?,?,'', NOW(), '1')";
	$lineValues = array($receiptNo,$loanNo,$amount  );
	pdoExecute($insertLine, $lineValues);

}
else if($type=="penaltyvoucher"){
	$voucherNo = trim($_POST["voucherNo"]);
	$month = trim($_POST["month"]);
	$year = trim($_POST["year"]);
	$tMonth = mysqli_real_escape_string($conn, $month);
	$tYear = mysqli_real_escape_string($conn, $year);
	$tVoucherNo = mysqli_real_escape_string($conn,$voucherNo);
	$sql = "SELECT * FROM `penaltyvoucher` WHERE `voucherNo` = '$tVoucherNo'";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)>0){ //exists
		while($result = mysqli_fetch_assoc($res)){
			if($result["posted"]){
				$response["status"] = false;
				$response["message"] = "The penalty voucher has already been posted";
			}else{
				if(isset($_POST["entries"])){
					$entries = json_decode($_POST["entries"], true);
					$error = false;
					foreach($entries as $entry){
						$lineNo = $entry["lineNo"];
						$loanNo = $entry["loan"]["loanNumber"];
						$exempt = $entry["exempt"];
						//print_r($entry);
						//echo $exempt;
						//break;
						if(!$exempt){
							$exempt = 0;
						}
						$updateLine = "update `penaltylines` set `exempt` = ? where headerNo = ? and loanNo = ? and line =?";
						$lineValues = array($exempt,$voucherNo,$loanNo,$lineNo   );
						if (!pdoExecute($updateLine, $lineValues)){
							$error = true;
							break;
						}
					}
					if($error){
						$response["status"] = false;
						$response["message"] = "The penalty voucher could not be updated";
					}else{
						$response["status"] = true;
						$response["message"] = "The penalty voucher was successfully updated";
					}
					//print_r($entries);
					//
				}
				/*$checkMonth = "select * from penaltyvoucher where month = '$tMonth' and year = '$tYear' and not `voucherNo` = '$tVoucherNo'";
				$monthRes = mysqli_query($conn, $checkMonth);
				if(mysqli_num_rows($monthRes)>0){
					$response["status"] = false;
					$response["message"] = "There is another penalty voucher with the same month and year. Please select a different month or year.";
				}else{
					$sql = "update `penaltyvoucher` set `month` = ?, `year` = ? where voucherNo = ?";
					$values = array($month,$year,$voucherNo);
					if(pdoExecute($sql, $values)){
						calculatePenalty($voucherNo);
						$response["status"] = true;
						$response["message"] = "The penalty voucher was successfully updated";
								
					}else{
						$response["status"] = false;
						$response["message"] = "The penalty voucher could not be updated";
					}
				}*/
			}
		}
		
	}else{ //create a new voucher
		$checkMonth = "select * from penaltyvoucher where month = '$tMonth' and year = '$tYear'";
		$monthRes = mysqli_query($conn, $checkMonth);
		if(mysqli_num_rows($monthRes)>0){
			$response["status"] = false;
			$response["message"] = "There is another penalty voucher with the same month and year. Please select a different month or year.";
		}else{
		$sql = "INSERT INTO `penaltyvoucher`(`voucherNo`, `month`, `year`, `createdBy`, `createdOn`, `posted`) VALUES (?, ?,?,?,NOW(),0)";
			$values = array($voucherNo,$month,$year, "1");
			if(pdoExecute($sql, $values)){
			$sql = "SELECT * FROM `penaltyvoucher` WHERE `voucherNo` = '$tVoucherNo'";
						$res = mysqli_query($conn, $sql);
						if(mysqli_num_rows($res)>0){
							while($result= mysqli_fetch_assoc($res)){
								calculatePenalty($voucherNo);
								$response["status"] = true;
								$response["message"] = "The penalty voucher was successfully created";
								$dates = explode(" ", $result["createdOn"]);
								$response["overLoad1"] =$dates[0];
							}
						}else{
								$response["status"] = false;
								$response["message"] = "The penalty voucher could not be created";
					
						}}else{
				$response["status"] = false;
				$response["message"] = "The penalty voucher could not be created";
			}
		}
	}
	
}	
else if($type=="revalidatemobitillvoucher"){
$voucherNo = trim($_POST["voucherNo"]);
$tVoucherNo = mysqli_real_escape_string($conn, $voucherNo);
$sql = "SELECT * FROM `mobitillvouchers` WHERE voucherNo = '$tVoucherNo' and posted = 0";
$res = mysqli_query($conn, $sql);
if(mysqli_num_rows($res)>0){
	$linesRes = mysqli_query($conn, "SELECT * FROM `mobitillvoucherlines` WHERE voucherNo = '$tVoucherNo' and hasError = 1");
	while($result = mysqli_fetch_assoc($linesRes)){
			$deviceName = trim($result["devicename"]);
			$mode = trim($result["mode"]);
			$productName = strtolower(trim($result["productname"]));
			$quantity = trim($result["quantity"]);
			$ticketNo = trim($result["ticketNo"]);
			$timestamp = trim($result["timeStamp"]);
			$total = trim($result["total"]);
			$vehicleNo = strtoupper(trim($result["vehicleNo"]));
			$vehicleNo = str_ireplace(" ","", $vehicleNo);
			$voucherNo = trim($result["voucherNo"]);
			$lineId = trim($result["id"]);
			$error = false;
			$memberNo = "";
			$loanNo = "";
			$message = "";
			$tVehicleNo = mysqli_real_escape_string($conn, $vehicleNo);
			
			//validate
			//total is numeric
			if(!is_numeric($total)){
				$error = true;
				$message = "Total amount should be a numeric figure";
			}	
			//vehicle exists
			
			//vehicle must have an owner
			$sql = "SELECT * FROM `vehicles` WHERE `RegNo` = '$tVehicleNo'";
			$res = mysqli_query($conn, $sql);
			$dontCheck = false;
			$excempt = array("LIMURU","KHOJA","Naivasha","ACCRA");
			if(in_array($productName,$excempt)){
				$dontCheck = true;
			}
			if(mysqli_num_rows($res)>0){
				while($result = mysqli_fetch_assoc($res)){
					//
					$owner = mysqli_real_escape_string($conn, trim($result["Owner"]));
					$memberNo = $result["Owner"];
				$types = array("sacco","share capital","limuru","line money","service fee arrears","sacco arrears","service fee","khoja","naivasha","savings","loan","accra","fine","kce198r","project");
				if(!in_array($productName,$types)){
					$error = true;
					$message .=strlen($message)>0?"\n":"";
					$message .= "The given transaction type does not exist";
				}else{
					if($productName=="loan"){
						$loans = "SELECT A.*,B.*,C.*,D.*,(select sum(Debit)-sum(Credit) from loanledgerentries where LoanNumber = A.LoanNo)as loanBalance,E.id as disbursementId,E.mode,(SELECT COUNT(*) FROM loansregister where loansregister.Issued=true and LoanProductCode=D.Code) as loansIssued FROM `loansregister` as A left join members as B on A.MemberNo = B.MemberNo left join banks as C on A.Payingbank = C.Id left join loanssetup as D on A.LoanProductCode = D.Code LEFT join loandisbursementmodes E on A.LoanDisbursementMode = E.id  where A.Issued = 1 and A.MemberNo ='$owner'";
						$loansRes = mysqli_query($conn, $loans);
						$hasLoan = false;
						while($loanResult = mysqli_fetch_assoc($loansRes)){
							$loanBalance = $loanResult["loanBalance"];
							if($loanBalance>=$total){
								$hasLoan = true;
								$loanNo  = $loanResult["LoanNo"];
								break;
							}
						}
						if(!$hasLoan){
							$error = true;
							$message .=strlen($message)>0?"\n":"";
							$message .= "The selected member does not have an outstanding loan";
						}
						
					}
				}
				
				}
			}else{
				if(!$dontCheck){
				$error = true;
				$message .=strlen($message)>0?"\n":"";
				$message .= "A vehicle with the given registration does not exist";
				}
			}
			//if loan, member must have a loan
			
			$error = $error?1:0;
			
			$sql = "Update `mobitillvoucherlines` set `devicename`= ?, `mode`=?, `productname`=?, `quantity`=?, `ticketNo`=?, `timeStamp`=?, `total`=?, `vehicleNo`=?,`memberNo`=?, `loanNo`=?, `error`=?, `hasError`=?  where `voucherNo`= ? and id = ?";
			$values = array($deviceName,$mode,$productName,$quantity,$ticketNo,$timestamp,$total, $vehicleNo,$memberNo,$loanNo,$message, $error, $voucherNo,$lineId);
			if(pdoExecute($sql, $values)){
				$response["status"] = true;
				$response["message"] = "The line was successfully added";
			}else{
				$response["status"] = false;
				$response["message"] = "The line could not be added";
			}
	}
	$response["status"] = true;
	$response["message"] = "Validation successfully";
}else{
	$response["status"] = false;
	$response["message"] = "The mobitill voucher does not exist or it has already been posted";
}
}
else if($type=="transferfunds"){
	$transferNo = trim($_POST["transferNo"]);
	$transferDate = trim($_POST["transferDate"]);
	$transferFrom = trim($_POST["transferFrom"]);
	$fromAccount = trim($_POST["fromAccount"]);
	$transferTo = trim($_POST["transferTo"]);
	$toAccount = trim($_POST["toAccount"]);
	$amount = trim($_POST["amount"]);
	
	$tTransferNo = mysqli_real_escape_string($conn,$transferNo);
	$check = "SELECT * FROM `transferfunds` WHERE `transferNo` = '$tTransferNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The transfer funds voucher has already been posted";
		}else{
			$sql = "update `transferfunds` set  `transferDate` = ?, `transferFrom` = ?, `fromAccount`=?, `transferTo`=?, `toAccount`=?, `transferAmount`=?  where `transferNo` = ? and  `posted` = ?";
			$values = array($transferDate, $transferFrom, $fromAccount,$transferTo,$toAccount, $amount,$transferNo, 0);
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The transfer funds voucher was successfully updated";
			}else{
				$response["status"] = false;
				$response["message"] = "The transfer funds voucher could not be updated";
			}
		}
	}
		
	}else{ //create
		$sql = "INSERT INTO `transferfunds`(`transferNo`, `transferDate`, `createdOn`, `createdBy`, `transferFrom`, `fromAccount`, `transferTo`, `toAccount`, `transferAmount`, `posted`) VALUES (?,?,NOW(),?,?,?,?,?,?,?)";
		$values = array($transferNo,$transferDate, "",$transferFrom, $fromAccount,$transferTo,$toAccount, $amount, 0 );
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["message"] = "The transfer funds voucher was successfully created";
		}else{
			$response["status"] = false;
			$response["message"] = "The transfer funds voucher could not be created";
		}
	}
	
}
else if($type=="transfervehicle"){
	$transferNo = trim($_POST["transferNo"]);
	$transferDate = trim($_POST["transferDate"]);
	$previousOwner = trim($_POST["previousOwner"]);
	$vehicleReg = trim($_POST["vehicleReg"]);
	$vehicleReg = str_ireplace(" ", "", $vehicleReg);
	$newOwner = trim($_POST["newOwner"]);
	
	if($previousOwner==$newOwner){
		$response["status"] = false;
		$response["message"] = "You cannot transfer the vehicle to the same person";
	}else{
	$tTransferNo = mysqli_real_escape_string($conn,$transferNo);
	$check = "SELECT * FROM `vehicletransfer` WHERE `transferNo` = '$tTransferNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The vehicle transfer has already been posted";
		}else{
			$sql = "update `vehicletransfer` set `transferDate` = ?, `vehicle`=?, `previousOwner`=?, `newOwner`=? where `transferNo` = ? and `posted` = ?";
		$values = array($transferDate,$vehicleReg, $previousOwner,$newOwner, $transferNo, 0 );
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["message"] = "The vehicle transfer was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "The vehicle transfer could not be updated";
		}
		}
	}
		
	}else{ //create
		$sql = "INSERT INTO `vehicletransfer`(`transferNo`, `transferDate`, `createdOn`, `createdBy`, `vehicle`, `previousOwner`, `newOwner`, `posted`) VALUES (?,?,NOW(),?,?,?,?,?)";
		$values = array($transferNo,$transferDate, "",$vehicleReg, $previousOwner,$newOwner, 0 );
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["message"] = "The vehicle transfer was successfully created";
		}else{
			$response["status"] = false;
			$response["message"] = "The vehicle transfer could not be created";
		}
	}
	}
}
else if($type=="vehicleexit"){
	
	$exitNo = trim($_POST["exitNo"]);
	$exitDate = trim($_POST["exitDate"]);
	$owner = trim($_POST["owner"]);
	$vehicleReg = trim($_POST["vehicleReg"]);
	$vehicleReg = str_ireplace(" ", "", $vehicleReg);
	$bankCode = trim($_POST["bankCode"]);
	$noObjectionFee = trim($_POST["noObjectionFee"]);
	
	
	$tExitNo = mysqli_real_escape_string($conn,$exitNo);
	$check = "SELECT * FROM `vehicleexit` WHERE `exitNumber` =  '$tExitNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The vehicle exit has already been posted";
		}else{
		$sql = "update `vehicleexit` set `exitDate` = ?, `vehicle` = ?, `owner`=?, `receivingBank`=?, `noObjectionFee`=? where `exitNumber` = ? and `posted` = ? ";
		$values = array($exitDate,$vehicleReg, $owner,$bankCode,$noObjectionFee, $exitNo,0 );
		
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["message"] = "The vehicle exit was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "The vehicle exit could not be updated";
		}
		}
	}
		
	}else{ //create
		$sql = "INSERT INTO `vehicleexit`(`exitNumber`, `exitDate`, `createdOn`, `createdBy`, `vehicle`, `owner`, `receivingBank`, `noObjectionFee`, `posted`) VALUES (?,?,NOW(),?,?,?,?,?,?)";
		$values = array($exitNo,$exitDate, "",$vehicleReg, $owner,$bankCode,$noObjectionFee, 0 );
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["message"] = "The vehicle exit was successfully created";
		}else{
			$response["status"] = false;
			$response["message"] = "The vehicle exit could not be created";
		}
	}
	}
else if($type=="driverconductor"){
	
	$employeeNo = trim($_POST["employeeNo"]);
	$employeeName = trim($_POST["employeeName"]);
	$employeeId = trim($_POST["employeeId"]);
	$employeePhone = trim($_POST["employeePhone"]);
	$vehicle = trim($_POST["vehicle"]);	
	$vehicle = str_ireplace(" ", "", $vehicle);
	$employeeEmail = trim($_POST["employeeEmail"]);
	$employeePosition = trim($_POST["employeePosition"]);
	$licenseNo = trim($_POST["licenseNo"]);
	$employer = trim($_POST["employer"]);
	$issuedOn = trim($_POST["issuedOn"]);
	$expiryDate = trim($_POST["expiryDate"]);
	$photo = trim($_POST["photo"]);
	$badgeReceived = trim($_POST["badgeReceived"]);
	$badgeIssued = trim($_POST["badgeIssued"]);
	
	
	$tEmployeeNo = mysqli_real_escape_string($conn,$employeeNo);
	$tEmployeeId = mysqli_real_escape_string($conn,$employeeId);
	$checkId = "SELECT * FROM `driverconductor` WHERE `idNo` =  '$tEmployeeId' and not `employeeNo` =  '$tEmployeeNo'";
	$idRes = mysqli_query($conn, $checkId);
	if(mysqli_num_rows($idRes)>0){
		$response["status"] = false;
		$response["message"] = "There is another employee with the given Id Number";
	}else{	
	$check = "SELECT * FROM `driverconductor` WHERE `employeeNo` =  '$tEmployeeNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		
		$sql = "update `driverconductor` set `name` =?, `idNo`=?, `phoneNo`=?, `email`=?, `position`=?, `licenseNo`=?, `employer`=?, `vehicle`=?, `applied`=?, `badgeReceived`=?, `badgeIssued`=?, `issuedOn`=?, `expiry`=?,  `photo`=? where `employeeNo` = ?";
		$values = array($employeeName, $employeeId,$employeePhone, $employeeEmail,$employeePosition,$licenseNo,$employer,$vehicle ,0, 0,0,$issuedOn,$expiryDate,$photo, $employeeNo );
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["message"] = "The employee was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "The employee could not be updated";
		}
		
	}
		
	}else{ //create
		$sql = "INSERT INTO `driverconductor`(`employeeNo`, `name`, `idNo`, `phoneNo`, `email`, `position`, `licenseNo`, `employer`, `vehicle`, `applied`, `badgeReceived`, `badgeIssued`, `issuedOn`, `expiry`, `createdOn`, `photo`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),?)";
		$values = array($employeeNo,$employeeName, $employeeId,$employeePhone, $employeeEmail,$employeePosition,$licenseNo,$employer,$vehicle ,0, 0,0,$issuedOn,$expiryDate,$photo );
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["message"] = "The employee was successfully created";
		}else{
			$response["status"] = false;
			$response["message"] = "The employee could not be created";
		}
	}
	}
	}
else if($type=="badgeapplication"){
	$applicationNo = trim($_POST["applicationNo"]);
	$employeeNo = trim($_POST["employeeNo"]);
	$employeeId = trim($_POST["employeeId"]);
	$employeePhone = trim($_POST["employeePhone"]);
	$employeeEmail = trim($_POST["employeeEmail"]);
	$employeePosition = trim($_POST["employeePosition"]);
	$employer = trim($_POST["employer"]);
	$vehicle = trim($_POST["vehicle"]);
	$vehicle = str_ireplace(" ","",$vehicle);
	$issuedOn = trim($_POST["issuedOn"]);
	$applicationDate = trim($_POST["applicationDate"]);
	$formApplicationAmount = trim($_POST["formApplicationAmount"]);
	$formApplicationBank = trim($_POST["formApplicationBank"]);
	$formApplicationExternalDoc = trim($_POST["formApplicationExternalDoc"]);
	$badgeCollectionAmount = trim($_POST["badgeCollectionAmount"]);
	$badgeCollectionBank = trim($_POST["badgeCollectionBank"]);
	$badgeCollectionExternalDoc = trim($_POST["badgeCollectionExternalDoc"]);
	$expiryDate = trim($_POST["expiryDate"]);
	$badgeReceived = trim($_POST["badgeReceived"]);
	$badgeIssued = trim($_POST["badgeIssued"]); 
	
	$tApplicationNo = mysqli_real_escape_string($conn, $applicationNo);
	$check = "SELECT * FROM `badgeapplication` WHERE `applicationNo` =  '$tApplicationNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){		
		$sql = "UPDATE `badgeapplication` SET `position` = ?, `employee`=?, `employer`=?, `vehicle`=?, `applicationDate`=?,  `issuedOn`=?, `expiryDate`=?, `formApplicationAmount`=?, `formApplicationBank`=?, `formApplicationExternalDoc`=?, `badgeCollectionAmount`=?, `badgeCollectionBank`=?, `badgeCollectionExternalDoc`=? where `applicationNo` = ?";
		$values = array($employeePosition, $employeeNo,$employer,$vehicle, $applicationDate ,  $issuedOn, $expiryDate,$formApplicationAmount,$formApplicationBank,$formApplicationExternalDoc,$badgeCollectionAmount,  $badgeCollectionBank, $badgeCollectionExternalDoc,$applicationNo);
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["message"] = "The badge application was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "The badge application could not be updated";
		}		
	}		
	}else{ //create
		$sql = "INSERT INTO `badgeapplication`(`applicationNo`, `position`, `employee`, `employer`, `vehicle`, `applicationDate`, `issuedOn`, `expiryDate`, `formApplicationAmount`, `formApplicationBank`, `formApplicationExternalDoc`, `badgeCollectionAmount`, `badgeCollectionBank`, `badgeCollectionExternalDoc`, `createdOn`,  `createdBy`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),?)";
		$values = array($applicationNo,$employeePosition, $employeeNo,$employer,$vehicle, $applicationDate ,$issuedOn, $expiryDate,$formApplicationAmount,$formApplicationBank,$formApplicationExternalDoc,$badgeCollectionAmount,  $badgeCollectionBank, $badgeCollectionExternalDoc, "" );
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["message"] = "The badge application was successfully created";
		}else{
			$response["status"] = false;
			$response["message"] = "The badge application could not be created";
		}
	}
	}
else if($type=="loanrecovery"){
	$recoverNo = trim($_POST["recoverNo"]);
	$memberNo = trim($_POST["memberNo"]);
	$loanNo = trim($_POST["loanNo"]);
	$recoveryDate = trim($_POST["recoveryDate"]);
	$balancingCharge = trim($_POST["balancingCharge"]);
	$contributionsToRecover = trim($_POST["contributionsToRecover"]);	
	$tRecoverNo = mysqli_real_escape_string($conn, $recoverNo);
	$check = "SELECT * FROM `loanrecovery` WHERE `recoveryNo` = '$tRecoverNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){		
		$sql = "update `loanrecovery` set `recoveryDate` = ?, `member` = ?, `loan` =?, `outstandingAmount`=(select SUM(Amount) accountBalance from `loanledgerentries` where LoanNumber  =?), `balancingCharge` = ?, `totalAmount`=(outstandingAmount+balancingCharge), `amountFromContributions` = ? where recoveryNo =? and `posted` = ?";
		$values = array($recoveryDate,$memberNo,$loanNo,$loanNo,$balancingCharge,$contributionsToRecover, $recoverNo, 0 );
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["message"] = "The loan recovery was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "The loan recovery could not be updated";
		}		
	}		
	}else{ //create
		$sql = "INSERT INTO `loanrecovery`(`recoveryNo`, `recoveryDate`, `member`, `loan`, `outstandingAmount`, `balancingCharge`, `totalAmount`, `amountFromContributions`, `createdBy`, `createdOn`, `posted`) VALUES (?,?,?,?,(select SUM(Amount) accountBalance from `loanledgerentries` where LoanNumber  =?),?,(outstandingAmount+balancingCharge),?,?,NOW(),?)";
		$values = array($recoverNo,$recoveryDate,$memberNo,$loanNo,$loanNo,$balancingCharge,$contributionsToRecover, "",0 );
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["message"] = "The loan recovery was successfully created";
		}else{
			$response["status"] = false;
			$response["message"] = "The loan recovery could not be created";
		}
	}
	}
else if($type=="memberexit"){
	
	$exitNo = trim($_POST["exitNo"]);
	$exitDate = trim($_POST["exitDate"]);
	$memberNo = trim($_POST["memberNo"]);
	$withdrawalCharge = trim($_POST["withdrawalCharge"]);
	$bankCode = trim($_POST["bankCode"]);
	$chequeCommission = trim($_POST["chequeCommission"]);
	$refundableContributions = trim($_POST["refundableContributions"]);
	$chequeNo = trim($_POST["chequeNo"]);
	
	$tExitNo = mysqli_real_escape_string($conn,$exitNo);
	$check = "SELECT * FROM `memberexit` WHERE `exitNumber` = '$tExitNo'";
	$res = mysqli_query($conn, $check);
	
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The member exit has already been posted";
		}else{
		$sql = "update `memberexit` set `exitDate` = ?, `memberNo` = ?, `withdrawalCharge` = ?, `bankCode` = ?, `chequeCommission`= ?, `refundableContributions`=?, `chequeNo`= ?  where exitNumber = ? and  `posted` = ?";
		$values = array($exitDate, $memberNo,$withdrawalCharge,$bankCode,$chequeCommission ,$refundableContributions,$chequeNo, $exitNo, 0);
		
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["message"] = "The member exit was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "The member exit could not be updated";
		}
		}
	}
		
	}else{ //create
		$sql = "INSERT INTO `memberexit`(`exitNumber`, `exitDate`, `memberNo`, `withdrawalCharge`, `bankCode`, `chequeCommission`, `refundableContributions`, `chequeNo`, `createdOn`, `createdBy`, `posted`) VALUES (?,?,?,?,?,?,?,?,NOW(),?,?)";
		$values = array($exitNo,$exitDate, $memberNo,$withdrawalCharge,$bankCode,$chequeCommission ,$refundableContributions,$chequeNo,"", 0);
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["message"] = "The member exit was successfully created";
		}else{
			$response["status"] = false;
			$response["message"] = "The member exit could not be created";
		}
	}
	}
else if($type=="sharecapitalimport"){
	//$amount =  342;
	//Correction
	//$date = "2018-12-30";
				$amount =  5000;
				$member = 129;
				$date = "2018-12-30";
				$items = array();
				$header = array();
				$header["documentNo"] = "";
				$header["externalDocumentno"] = "";
				$header["transactionDate"] =$date;
				$header["transactionType"] = "202";
				$header["description"] = "Line Money";
				$header["amount"] = $amount*-1;
				$header["accountType"] ="member";
				$header["accountNumber"] =$member;
				$header["user"] ="1";
				
				array_push($items,$header);
				//bank entries
				$line = array();
				$line["documentNo"] = "";
				$line["externalDocumentno"] = "";
				$line["transactionDate"] = $date;
				$line["transactionType"] = "202";
				$line["description"] = "Line Money";
				$line["amount"] = $amount;
				$line["accountNumber"] ="027";
				$line["accountType"] = "glaccount";
				$line["user"] ="1";
				array_push($items, $line);
				$response = post($items,"", "");
}	
else if($type=="banktranfer"){
	$transferNo = trim($_POST["transferNo"]);
	$transferDate = trim($_POST["transferDate"]);
	$transferFrom = trim($_POST["transferFrom"]);
	$transferTo = trim($_POST["transferTo"]);
	$transferAmount = trim($_POST["transferAmount"]);
	$description = trim($_POST["description"]);
	$externalRefNo = trim($_POST["externalRefNo"]);
	
	
	$tTransferNo = mysqli_real_escape_string($conn,$transferNo);
	$check = "SELECT * FROM `banktransfers` WHERE `transferNo` = '$tTransferNo'";
	$res = mysqli_query($conn, $check);
	if($transferFrom==$transferTo){
		$response["status"] = false;
		$response["message"] = "The bank to transfer from cannot be the same as \nthe bank to transfer to.\nPlease select a different bank";
	}else{
	if(mysqli_num_rows($res)>0){ //exists, update
	while($result = mysqli_fetch_assoc($res)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The bank transfer has already been posted";
		}else{
			$sql = "update `banktransfers` set `fromBank` = ?, `toBank` = ?, `transferDate` = ?, `externalRef` = ?, `description` = ?, `amount` = ?  where `transferNo` = ? and `posted` = ?";
			$values = array($transferFrom, $transferTo,$transferDate, $externalRefNo,$description,$transferAmount, $transferNo,0);
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The bank transfer voucher was successfully updated";
			}else{
				$response["status"] = false;
				$response["message"] = "The bank transfer voucher could not be updated";
			}
		}
	}
		
	}else{ //create
		$sql = "INSERT INTO `banktransfers`(`transferNo`, `fromBank`, `toBank`, `transferDate`, `externalRef`, `description`, `amount`, `createdOn`, `createdBy`, `posted`) VALUES (?,?,?,?,?,?,?,NOW(),?,?)";
		$values = array($transferNo,$transferFrom, $transferTo,$transferDate, $externalRefNo,$description,$transferAmount, "", 0 );
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["message"] = "The bank transfer voucher was successfully created";
		}else{
			$response["status"] = false;
			$response["message"] = "The bank transfer voucher could not be created";
		}
	}
	}
}
else if($type=="payrolldeductions"){
	$deductionCode = trim($_POST["deductionCode"]);
	$deductionName = trim($_POST["deductionName"]);
	$deductionVendor = trim($_POST["deductionVendor"]);
	$taxable = trim($_POST["taxable"]);
	$disabled = trim($_POST["disabled"]);
	$tDeductionCode = mysqli_real_escape_string($conn, $deductionCode);
	//check exists
	$sql = "SELECT * FROM `allowancesdeductions` WHERE `code` = '$tDeductionCode' and `type` = 'deduction'";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res) < 1){//insert
		$sql = "INSERT INTO `allowancesdeductions`(`code`, `name`, `vendorGlAccount`, `taxable`, `disabled`, `type`, `statutory`, `addedOn`, `addedBy`) VALUES (?,?,?,?,?,?,?,NOW(),?)";
		$values = array($deductionCode,$deductionName,$deductionVendor,$taxable,$disabled, "deduction", 0, "");
		if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The deduction was successfully added";
		}else{
				$response["status"] = false;
				$response["message"] = "The deduction could not be added";
		}
	}
}

else if($type=="payrollallowances"){
	$allowanceCode = trim($_POST["allowanceCode"]);
	$allowanceName = trim($_POST["allowanceName"]);
	$allowanceGLAccount = trim($_POST["allowanceGLAccount"]);
	$taxable = trim($_POST["taxable"]);
	$disabled = trim($_POST["disabled"]);
	$tAllowanceCode = mysqli_real_escape_string($conn, $allowanceCode);
	//check exists
	$sql = "SELECT * FROM `allowancesdeductions` WHERE `code` = '$tAllowanceCode' and `type` = 'earning'";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res) < 1){//insert
		$sql = "INSERT INTO `allowancesdeductions`(`code`, `name`, `vendorGlAccount`, `taxable`, `disabled`, `type`, `statutory`, `addedOn`, `addedBy`) VALUES (?,?,?,?,?,?,?,NOW(),?)";
		$values = array($allowanceCode,$allowanceName,$allowanceGLAccount,$taxable,$disabled, "earning", 0, "");
		if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The allowance was successfully added";
		}else{
				$response["status"] = false;
				$response["message"] = "The allowance could not be added";
		}
	}
}

else if($type=="allowancedeductionmatrix"){
    //print_r($_POST);
	$employeeNo = trim($_POST["employeeNo"]);
	$code = trim($_POST["code"]);
	$calculationMethod = trim($_POST["calculationMethod"]);
	$amountRate = trim($_POST["amountRate"]);
	$startDate = trim($_POST["startDate"]);
	$endDate = trim($_POST["endDate"]);
	$disabled = trim($_POST["disabled"]);
	$type = trim($_POST["type"]);
	$myType = "Deduction";
	if($type){
		$myType = "Allowance";
	}
	$tEmployeeNo = mysqli_real_escape_string($conn,$employeeNo);
	$tCode = mysqli_real_escape_string($conn,$code);
	$tType = mysqli_real_escape_string($conn,$type);
	$check = "SELECT * FROM `allowancesdeductionsmatrix` WHERE `employeeNo`= '$tEmployeeNo' and `allowanceDeductionCode` = '$tCode' and `type` = '$tType'";
	$res = mysqli_query($conn, $check);
	if(mysqli_num_rows($res)>0){ //exists, update
		$sql = "update `allowancesdeductionsmatrix` set `employeeNo` = ?, `allowanceDeductionCode` = ?, `type` = ?, `calculationMethod` = ?, `amountRate` = ?, `startDate` = ?, `endDate` = ?, `disabled` = ? where `employeeNo` = ? and  `allowanceDeductionCode` = ? and`type` = ?";
		$values = array($employeeNo,$code,$type,$calculationMethod, $amountRate, $startDate,$endDate,$disabled, $employeeNo,$code,$type);
		if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The $myType was successfully updated";
		}else{
				$response["status"] = false;
				$response["message"] = "The $myType could not be updated";
		}
	}else{ //insert
		$sql = "INSERT INTO `allowancesdeductionsmatrix`(`employeeNo`, `allowanceDeductionCode`, `type`, `calculationMethod`, `amountRate`, `startDate`, `endDate`, `disabled`, `addedOn`, `addedBy`) VALUES (?,?,?,?,?,?,?,?,NOW(),?)";
		$values = array($employeeNo,$code,$type,$calculationMethod, $amountRate, $startDate,$endDate,$disabled, "");
		if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The $myType was successfully added";
		}else{
				$response["status"] = false;
				$response["message"] = "The $myType could not be added";
		}
	}
	
}
else if($type=="investmentcapital"){
	$amount = trim($_POST["amount"]);
	$paymentRef = trim($_POST["paymentRef"]);
	$bank = trim($_POST["bank"]);
	$investmentNo = trim($_POST["investmentNo"]);
	$investmentDate = trim($_POST["investmentDate"]);
	$nextSql = "SELECT COALESCE((MAX(`entryNo`)+1), 1) nextNumber FROM `investmentcapital` ";
	$nextRes = mysqli_query($conn, $nextSql);
	$nextNumber = 0;
	$investmentName = getInvestmentName($investmentNo);
	while($nextResult = mysqli_fetch_assoc($nextRes)){
		$nextNumber = $nextResult["nextNumber"];
	}
	$sql = "INSERT INTO `investmentcapital`(`entryNo`, `investmentNo`, `bank`, `amount`, `paymentRef`, `investmentDate`, `createdOn`,  `createdBy`) VALUES 	(?,?,?,?,?,?,NOW(),?)";
	$values = array($nextNumber,$investmentNo,$bank,$amount,$paymentRef, $investmentDate, "");
	if(pdoExecute($sql,$values)){
		//post
		$items = array();
		$header = array();
		$header["documentNo"] = $nextNumber;
		$header["externalDocumentno"] = $paymentRef;
		$header["transactionDate"] = $investmentDate;
		$header["transactionType"] = "1001";
		$header["description"] = "Investment Capital for $investmentName";
		$header["amount"] = $amount;
		$header["accountType"] ="investment";
		$header["accountNumber"] =$investmentNo;
		$header["user"] ="1";
				
		array_push($items,$header);
		//bank entries
		$line = array();
		$line["documentNo"] = $nextNumber;
		$line["externalDocumentno"] = $paymentRef;
		$line["transactionDate"] = $investmentDate;
		$line["transactionType"] = "1001";
		$line["description"] = "Investment Capital for $investmentName";
		$line["amount"] = $amount*-1;
		$line["accountNumber"] =$bank;
		$line["accountType"] = "bank";
		$line["user"] ="1";
		array_push($items, $line);
		$response = post($items,"investmentcapital", $nextNumber);
	}else{
		$response["status"] = false;
		$response["message"] = "The investment capital could not be created";
	}
}
else if($type=="investmentwithdrawal"){
	$amount = trim($_POST["amount"]);
	$paymentRef = trim($_POST["paymentRef"]);
	$bank = trim($_POST["bank"]);
	$investmentNo = trim($_POST["investmentNo"]);
	$investmentName = getInvestmentName($investmentNo);
	$withdrawalDate = trim($_POST["withdrawalDate"]);
	$nextSql = "SELECT COALESCE((MAX(`entryNo`)+1), 1) nextNumber FROM `investmentwithdrawal` ";
	$nextRes = mysqli_query($conn, $nextSql);
	$nextNumber = 0;
	while($nextResult = mysqli_fetch_assoc($nextRes)){
		$nextNumber = $nextResult["nextNumber"];
	}
	$sql = "INSERT INTO `investmentwithdrawal`(`entryNo`, `investmentNo`, `bank`, `amount`, `paymentRef`, `withdrawalDate`, `createdOn`,  `createdBy`) VALUES 	(?,?,?,?,?,?,NOW(),?)";
	$values = array($nextNumber,$investmentNo,$bank,$amount,$paymentRef, $withdrawalDate, "");
	if(pdoExecute($sql,$values)){
		//post
		$items = array();
		$header = array();
		$header["documentNo"] = $nextNumber;
		$header["externalDocumentno"] = $paymentRef;
		$header["transactionDate"] = $withdrawalDate;
		$header["transactionType"] = "1002";
		$header["description"] = "Investment Withdrawal from $investmentName";
		$header["amount"] = $amount*-1;
		$header["accountType"] ="investment";
		$header["accountNumber"] =$investmentNo;
		$header["user"] ="1";
				
		array_push($items,$header);
		//bank entries
		$line = array();
		$line["documentNo"] = $nextNumber;
		$line["externalDocumentno"] = $paymentRef;
		$line["transactionDate"] = $withdrawalDate;
		$line["transactionType"] = "1002";
		$line["description"] = "Investment Withdrawal from $investmentName";
		$line["amount"] = $amount;
		$line["accountNumber"] =$bank;
		$line["accountType"] = "bank";
		$line["user"] ="1";
		array_push($items, $line);
		$response = post($items,"investmentwithdrawal", $nextNumber);
	}else{
		$response["status"] = false;
		$response["message"] = "The investment withdrawal could not be created";
	}
}
else if($type=="investmentcommission"){
	$amount = trim($_POST["amount"]);
	$paymentRef = trim($_POST["paymentRef"]);
	$bank = trim($_POST["bank"]);
	$investmentNo = trim($_POST["investmentNo"]);
	$investmentDate = trim($_POST["investmentDate"]);
	$nextSql = "SELECT COALESCE((MAX(`entryNo`)+1), 1) nextNumber FROM `investmentcommissions` ";
	$nextRes = mysqli_query($conn, $nextSql);
	$nextNumber = 0;
	while($nextResult = mysqli_fetch_assoc($nextRes)){
		$nextNumber = $nextResult["nextNumber"];
	}
	$sql = "INSERT INTO `investmentcommissions`(`entryNo`, `investmentNo`, `bank`, `amount`, `paymentRef`, `paymentDate`, `createdOn`,  `createdBy`) VALUES 	(?,?,?,?,?,?,NOW(),?)";
	$values = array($nextNumber,$investmentNo,$bank,$amount,$paymentRef, $investmentDate, "");
	if(pdoExecute($sql,$values)){
		//post
		$investmentName = getInvestmentName($investmentNo);
		$items = array();
		$header = array();
		$header["documentNo"] = $nextNumber;
		$header["externalDocumentno"] = $paymentRef;
		$header["transactionDate"] = $investmentDate;
		$header["transactionType"] = "1003";
		$header["description"] = "Commission Income from $investmentName";
		$header["amount"] = $amount*-1;
		$header["accountType"] ="glaccount";
		$header["accountNumber"] ="031";
		$header["user"] ="1";
				
		array_push($items,$header);
		//bank entries
		$line = array();
		$line["documentNo"] = $nextNumber;
		$line["externalDocumentno"] = $paymentRef;
		$line["transactionDate"] = $investmentDate;
		$line["transactionType"] = "1003";
		$line["description"] = "Commission Income from $investmentName";
		$line["amount"] = $amount;
		$line["accountNumber"] =$bank;
		$line["accountType"] = "bank";
		$line["user"] ="1";
		array_push($items, $line);
		$response = post($items,"investmentcommission", $nextNumber);
	}else{
		$response["status"] = false;
		$response["message"] = "The investment commission could not be created";
	}
}
else if($type=="fixedasset"){
	
	$faNo = trim($_POST["faNo"]);
	$faName = trim($_POST["faName"]);
	$description = trim($_POST["description"]);
	$serialNumber = trim($_POST["serialNumber"]);
	$acquireDdate = trim($_POST["acquireDdate"]);
	$location = trim($_POST["location"]);
	$assignedTo = trim($_POST["assignedTo"]);
	
    //$glAccount = trim($_POST["glAccount"]);
    
	$acquisitionGlAccount = trim($_POST["acquisitionGlAccount"]);
	$apprDeprGlAccount = trim($_POST["apprDeprGlAccount"]);
	
	
	$image = trim($_POST["image"]);
	$tFaNo = mysqli_real_escape_string($conn, $faNo);
	$tSerialNumber = mysqli_real_escape_string($conn, $serialNumber);
	// 

	$sql = "SELECT * FROM `fixedassets` where `Serial Number` = '$tSerialNumber'  and NOT `faNo`= '$tFaNo'";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)>0){
		$response["status"] = false;
		$response["message"] = "An asset with the same serial number already exists ";
	}else{
	$check = "SELECT * FROM `fixedassets` where `faNo` = '$tFaNo'";
	$res = mysqli_query($conn, $check);	
	if (mysqli_num_rows($res)<1){

	$sql = "INSERT INTO `fixedassets`(`faNo`, `fixedAssetName`,`Description`, `Serial Number`, `Date Acquired`, `assignedTo`, `Location`, `acquisition_gl_account`,`appr_depr_gl_account`, `Added by`, `Added on`, `active`, `photo`) VALUES (?,?,?,?,?,?,?,?,?,?,NOW(),?,?)";
		$values = array ($faNo,$faName, $description, $serialNumber,$acquireDdate,$assignedTo, $location, $acquisitionGlAccount,$apprDeprGlAccount, $myUserName,1,$image );
		if(pdoExecute($sql, $values)){	
			$response["status"] = true;
			$response["message"] = "The asset was successfully added ";
		}else{
			$response["status"] = false;
			$response["message"] = "The asset could not be added. Please try again. ";
		}

		
	}
	else{ //update 
		$sql = "update `fixedassets` set  `fixedAssetName` = ?,`Description` = ?, `Serial Number` = ?, `Date Acquired` = ?, `assignedTo` = ?, `Location` = ?, `acquisition_gl_account` =?,`appr_depr_gl_account` = ?,  `photo` = ? where `faNo` = ?";
		$values = array ($faName, $description, $serialNumber,$acquireDdate,$assignedTo, $location, $acquisitionGlAccount,$apprDeprGlAccount, $image,$faNo );
		if(pdoExecute($sql, $values)){	
			$response["status"] = true;
			$response["message"] = "The asset was successfully updated ";
		}else{
			$response["status"] = false;
			$response["message"] = "The asset could not be updated. Please try . ";
		}
	}
	}
}
else if($type=="assetacquisition"){
	$acquisitionNo = trim($_POST["acquisitionNo"]);
	$assetNo = trim($_POST["assetNo"]);
	$vendorNo = trim($_POST["vendorNo"]);
	$purchaseDate = trim($_POST["purchaseDate"]);
	$buyingPrice = trim($_POST["buyingPrice"]);
	$tAcquisitionNo = mysqli_real_escape_string($conn, $acquisitionNo);
	$check = "SELECT * FROM `assetacquisition` WHERE `acquisitionNo` = '$tAcquisitionNo'";
	$res = mysqli_query($conn, $check);
	if(mysqli_num_rows($res)>0){//update
		while($result = mysqli_fetch_assoc($res)){
			if($result["posted"]){
				$response["status"] = false;
				$response["message"] = "The asset acquisition has already been posted";
			}else{
				$sql = "update `assetacquisition` set `assetNo` = ?, `vendorNo` = ?, `purchaseDate` = ?, `buyingPrice` = ? where `acquisitionNo` = ? and `posted` = ?";
				$values = array($assetNo,$vendorNo,$purchaseDate,$buyingPrice,  $acquisitionNo, 0);
				if(pdoExecute($sql,$values)){
						$response["status"] = true;
						$response["message"] = "The asset acquisition was successfully updated";
				}else{
						$response["status"] = false;
						$response["message"] = "The asset acquisition could not be updated";
				}
			}
		}
	}else{//insert
		$sql = "INSERT INTO `assetacquisition`(`acquisitionNo`, `assetNo`, `vendorNo`, `purchaseDate`, `buyingPrice`, `createdOn`, `createdBy`, `posted`) VALUES (?,?,?,?,?,NOW(),?,?)";
		$values = array($acquisitionNo, $assetNo,$vendorNo,$purchaseDate,$buyingPrice, "", 0);
		if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The asset acquisition was successfully created";
		}else{
				$response["status"] = false;
				$response["message"] = "The asset acquisition could not be created";
		}
	}
}
else if($type=="assetdisposal"){
	
	$disposalNo = trim($_POST["disposalNo"]);
	$assetNo = trim($_POST["assetNo"]);
	$customerNo = trim($_POST["customerNo"]);
	$disposalDate = trim($_POST["disposalDate"]);
	$sellingPrice = trim($_POST["sellingPrice"]);
	$tDisposalNo = mysqli_real_escape_string($conn, $disposalNo);
	$check = "SELECT * FROM `assetdisposal` WHERE `disposalNo` = '$tDisposalNo'";
	$res = mysqli_query($conn, $check);
	if(mysqli_num_rows($res)>0){//update
		while($result = mysqli_fetch_assoc($res)){
			if($result["posted"]){
				$response["status"] = false;
				$response["message"] = "The asset disposal has already been posted";
			}else{
				$sql = "update `assetdisposal` set `assetNo` = ?, `customerNo` = ?, `disposalDate` = ?, `sellingPrice` = ? where `disposalNo` = ? and  `posted` = ?";
				$values = array($assetNo,$customerNo,$disposalDate,$sellingPrice, $disposalNo, 0);
				if(pdoExecute($sql,$values)){
						$response["status"] = true;
						$response["message"] = "The asset disposal was successfully updated";
				}else{
						$response["status"] = false;
						$response["message"] = "The asset disposal could not be updated";
				}
			}
		}
	}else{//insert
		$sql = "INSERT INTO `assetdisposal`(`disposalNo`, `assetNo`, `customerNo`, `disposalDate`, `sellingPrice`, `createdOn`, `createdBy`, `posted`) VALUES (?,?,?,?,?,NOW(),?,?)";
		$values = array($disposalNo, $assetNo,$customerNo,$disposalDate,$sellingPrice, "", 0);
		if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The asset disposal was successfully created";
		}else{
				$response["status"] = false;
				$response["message"] = "The asset disposal could not be created";
		}
	}
}
else if($type=="appreciationdepreciation"){
	$voucherNo = trim($_POST["voucherNo"]);
	$computationDate = trim($_POST["computationDate"]);
	$computationType = trim($_POST["computationType"]);
	$assetNo = trim($_POST["assetNo"]);
	$description = trim($_POST["description"]);
	$computationMethod = trim($_POST["computationMethod"]);
	$rateAmount = trim($_POST["rateAmount"]);
	$tVoucherNo = mysqli_real_escape_string($conn,$voucherNo);
	$tAssetNo = mysqli_real_escape_string($conn,$assetNo);
	$assetSql = "SELECT A.*, (SELECT SUM(Amount) FROM `fixedassetledgerentries` WHERE fixedAssetNo = A.faNo) bookValue FROM `fixedassets` A WHERE A.faNo = '$tAssetNo'";
	$assetRes = mysqli_query($conn, $assetSql);
	if(mysqli_num_rows($assetRes)<1){
		$response["status"] = false;
		$response["message"] = "The selected asset does not exist";
	}
	while($assetResult = mysqli_fetch_assoc($assetRes)){
		$check = "SELECT * FROM `appreciation_depreciation` WHERE `voucherNo` = '$tVoucherNo'";
		$bookValue = $assetResult["bookValue"];
		$change = 0;
		$newValue = 0;
		if($computationMethod=="Percentage"){
			$change = ($bookValue * $rateAmount)/100;
		}else if($computationMethod=="Fixed amount"){
			  $change = $rateAmount;
		}
		if($computationType=="Depreciation"){
			$change*=-1;
		}
		$newValue = $bookValue+$change;
		$res = mysqli_query($conn, $check);
		if(mysqli_num_rows($res)>0){//update
			while($checkResult = mysqli_fetch_assoc($res)){
				if($checkResult["posted"]){
					$response["status"] = true;
					$response["message"] = "The voucher was has already been posted";
				}else{
					$sql = "update `appreciation_depreciation` set  `computationDate` = ?, `computationType` = ?, `assetNo` = ?, `description`=?, `computationMethod`=?, `rateAmount`=?,  `bookValue`=?, `newBookValue`=? where `voucherNo` = ? and `posted` = ?";
					$values = array($computationDate,$computationType,$assetNo,$description,$computationMethod,$rateAmount, $bookValue, $newValue,$voucherNo,0 );
					if(pdoExecute($sql,$values)){
						$response["status"] = true;
						$response["message"] = "The voucher was successfully updated";
					}else{
						$response["status"] = false;
						$response["message"] = "The voucher could not be updated";
					}
				}
			}
		}else{//insert
			$sql = "INSERT INTO `appreciation_depreciation`(`voucherNo`, `computationDate`, `computationType`, `assetNo`, `description`, `computationMethod`, `rateAmount`,`createdBy`, `posted`, `bookValue`, `newBookValue`,`createdOn`) VALUES (?,?,?,?,?,?,?,?,?,?,?,NOW())";
			$values = array($voucherNo,$computationDate,$computationType,$assetNo,$description,$computationMethod,$rateAmount,"", 0,$bookValue, $newValue );
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The voucher was successfully created";
			}else{
				$response["status"] = false;
				$response["message"] = "The voucher could not be created";
			}
		}
	}
}
else if($type=="salaryvoucher"){
	$voucherNo = trim($_POST["voucherNo"]);
	$month = trim($_POST["month"]);
	$year = trim($_POST["year"]);
	$bankCode = "";//trim($_POST["bankCode"]);
	$disbursementDate = "0000-00-00";//trim($_POST["disbursementDate"]);
	$tVoucherNo = mysqli_real_escape_string($conn, $voucherNo);
	$check = "SELECT * FROM `salaryvouchers` WHERE `voucherNo` = '$tVoucherNo'";
	$checkRes = mysqli_query($conn, $check);
	if(mysqli_num_rows($checkRes) < 1){//insert
		$sql = "INSERT INTO `salaryvouchers`(`voucherNo`, `month`, `year`, `payingBank`, `disbursement_date`, `createdOn`, `createdBy`, `posted`) VALUES (?,?,?,?,?,NOW(),?,?)";
		$values = array($voucherNo,$month, $year,$bankCode,$disbursementDate, "", 0 );
		if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The salary voucher was successfully created";
		}else{
				$response["status"] = false;
				$response["message"] = "The salary voucher could not be created";
		}
	}
}

else if($type=="salaryvoucherline"){	  
     ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
	  $employeeNo = trim($_POST["employeeNo"]);
	  $voucherNo = trim($_POST["voucherNo"]);
      $voucherCheck = "SELECT * FROM `salaryvouchers` WHERE `voucherNo` = '$voucherNo'";
	  $voucherCheckRes = fetchWithPdo($voucherCheck,array($voucherNo));
	  if(count($voucherCheckRes)>0){
		  foreach($voucherCheckRes as $vouchersResult){
		      if($vouchersResult["posted"]){
				$response["status"] = false;
				$response["message"] = "The salary voucher has already been posted";
			  }
			  else{
			      $endOfMonth = getLastDay($vouchersResult["month"], $vouchersResult["year"]);
			      $tFirstDate = $vouchersResult["year"]."-".$vouchersResult["month"]."-1";
				  $checkEmployee = "SELECT * FROM `employee` WHERE `EmployeeNumber` =? ";
				  $employeeRes = fetchWithPdo($checkEmployee, array($employeeNo));
				  if(count($employeeRes)>0){
					  foreach($employeeRes as $employeeResult){
					      $myEnd = new DateTime($endOfMonth);
					      $myEmployment = new DateTime($employeeResult["EmploymentDate"]);
					      $firstDay = new DateTime($tFirstDate);
					      $tFirstDay = $firstDay->format('Y-m-d');
					      $basicPay = $employeeResult["BasicSalary"]+0;
					      $workedDays = 31;
					      if($myEmployment>$firstDay){
					          $monthDays = 30;
					          $workedDays = $myEnd->diff($myEmployment)->format("%a");
					          if($workedDays<$monthDays){
					              if($workedDays>0){
					                $basicPay = ($basicPay/$monthDays)*$workedDays;
					              }
					          }
					      }
						  if($employeeResult["suspendPay"]){ 
							    $response["status"] = true;
								$response["message"] = "suspend pay";
						  }else if($myEnd<$myEmployment){
						        $response["status"] = true;
								$response["message"] = "not employed yet";
						  }else{
                              $payrollSetups = getPayrollSetups();
							  $allowancesdeductions = "SELECT A.*, B.* FROM `allowancesdeductionsmatrix` A left JOIN allowancesdeductions B on A.allowanceDeductionCode = B.code where A.employeeNo = '$employeeNo' and A.disabled = 0 and B.disabled = 0 and (endDate>='$tFirstDay' or endDate='0000-00-00')";
							 // echo $allowancesdeductions;
							  $allDedRes = mysqli_query($conn, $allowancesdeductions);
							  $taxableallowances = 0;
							  $nonTaxableDeductions = 0;
							  while($allDedResult = mysqli_fetch_assoc($allDedRes)){
								  if($allDedResult["type"]=="1"){//"earning"){//allowance 
									  if($allDedResult["taxable"]){
									    //  echo "Am here now";
										 $rateAmount =  $allDedResult["amountRate"];
										 $figure = 0;
										 $calculationMethod =  $allDedResult["calculationMethod"];
										 if($calculationMethod=="Percentage of Basic Salary"){
											$figure =  (($basicPay/0.85) *$rateAmount) /100; 
										 }else{
											 $figure = $rateAmount;
										 }
										 $taxableallowances+=$figure;
									  }
								  }else{
									  if(!$allDedResult["taxable"]){
										 $rateAmount =  $allDedResult["amountRate"];
										 $figure = 0;
										 $calculationMethod =  $allDedResult["calculationMethod"];
										 if($calculationMethod=="Percentage of Basic Salary"){
											$figure =  (($basicPay/0.85) *$rateAmount) /100; 
										 }else{
											 $figure = $rateAmount;
										 }
										 $nonTaxableDeductions+=$figure;
									  }
								  }
							  }
							  $nssf = 0;
                              $tier1=0;
                              $tier2 =0;
							  if($employeeResult["paysNSSF"]){
								 $pensionablePay = $basicPay+$taxableallowances;
                                  $pensionBalance = $pensionablePay;
                                  $tierOneLimit = 7000;
                                  $tier1 = 0.06*(min($tierOneLimit,$pensionablePay));
                                  $pensionBalance-=$tierOneLimit;
                                  if($pensionBalance>0){
                                      $tier2Amount = min($pensionBalance,(36000-$tierOneLimit));
                                       $tier2 = (0.06*$tier2Amount);
                                  }

								$nssf = $tier1+$tier2;



							  }
							  //echo "Basic Pay is $basicPay";
							  $nonTaxableDeductions+=$nssf;
							  $grossPay = $basicPay+$taxableallowances;
							  $taxableSalary = $grossPay-$nonTaxableDeductions;
							  $nhif = 0;
							  $paye = 0;
							  $taxRelief = 0;
							  $insuranceRelief = 0;
							  if($employeeResult["paysNHIF"]){
								$nhif = calculateNHIF($grossPay);
								
							  }
							  if($employeeResult["PaysPaye"]){
							      if($employeeResult["disabled"]){
							          $disabledThreshhold = 150000;
							          $variance = $taxableSalary - $disabledThreshhold;
							          if($variance>0){
							              $taxableSalary = $variance;
							          }
							      }
							      $housingLevy=0;
							       if($employeeResult["deduct_housing_levy"]){
                                        $housingLevy =round(0.015*$grossPay);
							       }
							    $payeInfo = calculatePAYEWithNHIF($taxableSalary,$nhif,$housingLevy);
								$taxRelief = $payeInfo[0];
								$paye = $payeInfo[1];
								$insuranceRelief = $payeInfo[2];
								$ahlRelief = $payeInfo[3];
								
							  }
							  $basicSalaryCode = $payrollSetups["basicSalaryCode"];
							  $payeCode = $payrollSetups["PAYECode"];
							  $nhifCode = $payrollSetups["NHIFCode"];
							  $nssfCode = $payrollSetups["NSSFCode"];
							  
							 $delete = "DELETE FROM `salaryvoucherlines` WHERE `voucherNo`=? AND `employeeNo` =?";
							 $deleteValues = array($voucherNo,$employeeNo);
							 pdoExecute($delete,$deleteValues);
                             $year = $vouchersResult["year"];
                             $month = $vouchersResult["month"];

                             $addEntries ="INSERT INTO `salaryvoucherlines`( `voucherNo`, `employeeNo`, `allowance_deduction_code`, `type`, `amount`, `addedOn`, `month`, `year`, `description`, `accountNumber`, `balance`) VALUES (?,?,?,?,?,NOW(),?,?,?,?,?)";
                             $addEntryValues = array($voucherNo, $employeeNo,$basicSalaryCode, "taxation", $taxableSalary,$month, $year, "Taxable Amount","",0);
                             
                             $addEntries .=",(?,?,?,?,?,NOW(),?,?,?,?,?)";
                             $addEntryValues = array_merge($addEntryValues,array($voucherNo, $employeeNo,$basicSalaryCode, "earning", $basicPay,$month, $year, "Basic Salary","",0));
                             
                             $addEntries .=",(?,?,?,?,?,NOW(),?,?,?,?,?)";
                             $addEntryValues = array_merge($addEntryValues,array($voucherNo, $employeeNo,$payeCode, "deduction", $paye,$month, $year, "PAYE","",0));
							
                             $addEntries .=",(?,?,?,?,?,NOW(),?,?,?,?,?)";
                             $addEntryValues = array_merge($addEntryValues,array($voucherNo, $employeeNo,$nhifCode, "deduction", $nhif,$month, $year, "NHIF","",0));
                        
                             $addEntries .=",(?,?,?,?,?,NOW(),?,?,?,?,?)";
                             $addEntryValues = array_merge($addEntryValues,array($voucherNo, $employeeNo,$nssfCode, "deduction", $nssf,$month, $year, "NSSF","",0));
                             
                             $addEntries .=",(?,?,?,?,?,NOW(),?,?,?,?,?)";
                             $addEntryValues = array_merge($addEntryValues,array($voucherNo, $employeeNo,$nssfCode, "employer_contribution", $nssf,$month, $year, "NSSF Employer Deductions","",0));
                             
                             $addEntries .=",(?,?,?,?,?,NOW(),?,?,?,?,?)";
                             $addEntryValues = array_merge($addEntryValues,array($voucherNo, $employeeNo,$nssfCode, "taxation", $tier1,$month, $year, "NSSF Tier One","",0));
                             
                             $addEntries .=",(?,?,?,?,?,NOW(),?,?,?,?,?)";
                             $addEntryValues = array_merge($addEntryValues,array($voucherNo, $employeeNo,$nssfCode, "taxation", $tier2,$month, $year, "NSSF Tier Two","",0));

                            //nita
                             if($employeeResult["pays_nita"]){
                                $nitaFee = 50;
                                $nitaCode = $payrollSetups["nita"];
                                $addEntries .=",(?,?,?,?,?,NOW(),?,?,?,?,?)";
                                $addEntryValues = array_merge($addEntryValues,array($voucherNo, $employeeNo,$nitaCode, "employer_contribution", $nitaFee,$month, $year, "NITA Employer Deductions","",0));
                             }	
                              //Housing Levy
                             if($employeeResult["deduct_housing_levy"]){
                                $housingLevy =round(0.015*$grossPay);
                                $housingLevyCode = $payrollSetups["housingLevy"];
                                $addEntries .=",(?,?,?,?,?,NOW(),?,?,?,?,?)";
                                $addEntryValues = array_merge($addEntryValues,array($voucherNo, $employeeNo,$housingLevyCode, "deduction", $housingLevy,$month, $year, "Housing Levy","",0));
                                
                                $addEntries .=",(?,?,?,?,?,NOW(),?,?,?,?,?)";
                                $addEntryValues = array_merge($addEntryValues,array($voucherNo, $employeeNo,$housingLevyCode, "employer_contribution", $housingLevy,$month, $year, "Housing Levy Employer Deductions","",0));
                             }
                             
							  $allowancesdeductions = "SELECT A.*, B.* FROM `allowancesdeductionsmatrix` A left JOIN allowancesdeductions B on A.allowanceDeductionCode = B.code  where A.employeeNo = ? and A.disabled = 0 and B.disabled = 0 and (endDate>=? or endDate='0000-00-00')";
                              //echo $allowancesdeductions;
                              //echo "Employee No: $employeeNo First Day:  $tFirstDay";
                              $allDedRes = fetchWithPdo($allowancesdeductions,array($employeeNo,$tFirstDay));
							  foreach($allDedRes as $allDedResults){
								   $rateAmount =  $allDedResults["amountRate"];
								   $allowanceName =  $allDedResults["name"];
									$figure = 0;
									$calculationMethod =  $allDedResults["calculationMethod"];
									if($calculationMethod=="Percentage of Basic Salary"){
										$figure =  (($basicPay/0.85) *$rateAmount) /100; 
									}else{
										$figure = $rateAmount;
									 }
									 $code = $allDedResults["allowanceDeductionCode"];
									 $type = $allDedResults["type"];

                                     $addEntries .=",(?,?,?,?,?,NOW(),?,?,?,?,?)";
                                     $addEntryValues = array_merge($addEntryValues,array($voucherNo, $employeeNo,$code, $type, $figure,$month, $year, $allowanceName,"",0));
							  }
							  $advanceCode = $payrollSetups["advanceCode"];
							  $getAdavances = "select A.*,(select SUM(Amount) from salaryadvanceledgerentries where LoanNumber = A.id) totalBalance from salaryadvance A where employee='$employeeNo'  and posted = 1 and reversed = 0";
							  //echo $getAdavances;
							  $advancesRes = mysqli_query($conn, $getAdavances);
							  while($advanceResult = mysqli_fetch_assoc($advancesRes)){
								  $totalBalance = $advanceResult["totalBalance"];
								  if($totalBalance>0){
                                    $addEntries .=",(?,?,?,?,?,NOW(),?,?,?,?,?)";
                                    $addEntryValues = array_merge($addEntryValues,array($voucherNo, $employeeNo,$advanceCode, "deduction", $totalBalance,$month, $year, "Salary Advance",$advanceResult["id"],0));	
								  }
							  }
							  //loan
							  $loansCode = $payrollSetups["loansCode"];
							  $getAdavances = "select A.*,(select SUM(Amount) from staffloanledgerentries where LoanNumber = A.id) totalBalance from staffloan A where employee='$employeeNo'  and posted = 1 and reversed = 0";
							  $advancesRes = mysqli_query($conn, $getAdavances);
							  while($advanceResult = mysqli_fetch_assoc($advancesRes)){
								  $totalBalance = $advanceResult["totalBalance"];
								  if($totalBalance>0){
									  $amount = $advanceResult["monthlyRepayments"];
									  if($amount>$totalBalance){
										  $amount=$totalBalance;
									  }
                                      $newBalance =$totalBalance - $amount;
                                      $addEntries .=",(?,?,?,?,?,NOW(),?,?,?,?,?)";
                                      $addEntryValues = array_merge($addEntryValues,array($voucherNo, $employeeNo,$loansCode, "deduction", $amount,$month, $year, "Staff Loan",$advanceResult["id"],$newBalance));
								  }
							  }
							if(pdoExecute($addEntries,$addEntryValues)){
                                $response["status"] = true;
                                $response["message"] = "execution completed";
                            }else{
                                $response["status"] = false;
                                $response["message"] = "The voucher line could not be updated";
                            }
						  }
					  }
				  }else{
					$response["status"] = false;
					$response["message"] = "The selected employee does not exist";
				  }
			  }
		  }
	  }else{
		$response["status"] = false;
		$response["message"] = "The salary voucher does not exist";
	  }
}
else if($type=="vehiclebrand"){
	$brandId = trim($_POST["brandId"]);
	$brandName = trim($_POST["brandName"]);
	$monthly = trim($_POST["monthly"]);
	$daily = trim($_POST["daily"]);
	$tBrandId = mysqli_real_escape_string($conn, $brandId);
	$check = "SELECT * FROM `vehiclebrands` WHERE `brandId` ='$tBrandId' ";
	$checkres = mysqli_query($conn,$check);
	if(mysqli_num_rows($checkres)>0){//update
		$sql = "update `vehiclebrands` set `brandName` = ?, `monthlyServiceFee` = ?, `dailyServiceFee`= ? where `brandId` = ?";
		$values = array($brandName,$monthly, $daily,$brandId);
		if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The vehicle brand was successfully updated";
		}else{
				$response["status"] = false;
				$response["message"] = "The vehicle brand could not be updated";
		}
	}else{//insert
		$sql = "INSERT INTO `vehiclebrands`(`brandId`, `brandName`, `monthlyServiceFee`, `dailyServiceFee`, `createdOn`, `createdBy`) VALUES (?,?,?,?,NOW(),?)";
		$values = array(0,$brandName,$monthly, $daily,"");
		if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The vehicle brand was successfully created";
		}else{
				$response["status"] = false;
				$response["message"] = "The vehicle brand could not be created";
		}
	}
	
}
else if($type=="loanreceipts"){
	
	$receiptNo = trim($_POST["receiptNo"]);
	$memberNo = trim($_POST["memberNo"]);
	$date = trim($_POST["date"]);
	$amount = trim($_POST["amount"]);
	$loanNo = trim($_POST["loanNo"]);
	$receivedFrom =  getMemberName($memberNo);
	$insert = "INSERT INTO `receiptheader`(`ReceiptNo`, `Member`, `Bank`, `PaymentMethod`, `ExternalRefNo`, `PaymentDate`, `ReceivedFrom`, `CreatedBy`, `Posted`, `CreatedOn`) VALUES 
	(?,?,?,?,?,?,?,'1',0,NOW());";
	$insert2 = "INSERT INTO `receiptline`(`ReceiptNo`, `TransactionType`, `LoanNo`, `Amount`, `vehicle`, `addedOn`, `addedBy`) VALUES 
	(?,?,?,?,?, NOW(), '1');";
	$values = array($receiptNo,$memberNo, 5, 3,"",$date,$receivedFrom);// $receiptNo,311,$loanNo,$amount,"" );
	$values2 = array( $receiptNo,311,$loanNo,$amount,"" );
	if(pdoExecute($insert,$values)){
		pdoExecute($insert2,$values2);
				$response["status"] = true;
				$response["message"] = "The receipt was successfully created";
		}else{
				$response["status"] = false;
				$response["message"] = "The receipt could not be created";
		}
	
}
else if($type=="vendorinvoicelines"){
	if(isset($_POST["invoiceNo"])){
		
			//get tax rate
			//Charge Items 
			$unitPrice = $_POST["unitPrice"];
			$taxRate = 0;
			if($_POST["itemType"]=="Services"){
				$myId = mysqli_real_escape_string($conn, trim($_POST["itemNo"]));
				$getTaxRate = "SELECT tax_rate FROM `chargeitems` where id = '$myId'";
				$rateRes = mysqli_query($conn,$getTaxRate);				
				while ($rateResult = mysqli_fetch_assoc($rateRes)) {
					$taxRate = $rateResult["tax_rate"];
				}
			}
			else if($_POST["itemType"]=="Items"){
				$myId = mysqli_real_escape_string($conn, trim($_POST["itemNo"]));
				$getTaxRate = "SELECT percentage FROM `taxGroups` WHERE code = (SELECT taxGroup FROM `items` WHERE code = '$myId')";
				$rateRes = mysqli_query($conn,$getTaxRate);				
				while ($rateResult = mysqli_fetch_assoc($rateRes)) {
					$taxRate = $rateResult["percentage"];
				}
				//$unitPrice = fetchWithPdo("SELECT * FROM `items` WHERE code = ?",array($myId))[0]["buying_price"];
			}
			$sql= "INSERT INTO `vendorinvoicelines`(`invoiceNo`, `itemType`, `itemNo`, `description`, `unitPrice`, `quantity`, `totalExclVAT`, `totalVAT`, `totalAmount`) VALUES (?,?,?,?,?,?,?,?,?)";
			$values = array();
			$values[0] = $_POST["invoiceNo"];
			$values[1] = $_POST["itemType"];
			$values[2] = $_POST["itemNo"];
			$values[3] = $_POST["description"];
			$values[4] = $unitPrice;
			$values[5] = $_POST["quantity"];
			$totalAmount = $_POST["quantity"]*$unitPrice;
			$taxableAmount= $totalAmount/(($taxRate/100)+1);
			$totalTax = ($taxableAmount*$taxRate)/100;
			$totalTax = round($totalTax,2);
			$values[6] =$totalAmount-$totalTax;
			$values[7] = $totalTax;
			$values[8] = $totalAmount;
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The line was successfully added";
			} else{
				$response["status"] = false;
				$response["message"] = "The line could not be added";
			}          
			

	}

}
else if($type=="town"){
	$townName = mysqli_real_escape_string($conn, trim($_POST["townName"]));
	$countyCode = mysqli_real_escape_string($conn, trim($_POST["countyCode"]));
	$parkingFeeCounty = mysqli_real_escape_string($conn, trim($_POST["parkingFeeCounty"]));
	$parkingFeeSacco = mysqli_real_escape_string($conn, trim($_POST["parkingFeeSacco"]));
	if(isset($_POST["townCode"])){//update
		$townCode = mysqli_real_escape_string($conn, trim($_POST["townCode"]));
		$sql = "UPDATE `towns` SET `townName`='$townName',`county`='$countyCode',`countyMonthlyFee`='$parkingFeeCounty',`saccoMonthlyFee`='$parkingFeeSacco' WHERE townId = '$townCode'";
		if(mysqli_query($conn, $sql)){
			$response["status"] = true;
			$response["message"] ="The town was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] ="The town could not be updated";
		}
	}else{//insert
		$sql = "INSERT INTO `towns`(`townName`, `county`, `countyMonthlyFee`, `saccoMonthlyFee`, `added_on`, `added_by`) VALUES ('$townName','$countyCode','$parkingFeeCounty','$parkingFeeSacco', NOW(), '1')";
		if(mysqli_query($conn, $sql)){
			$response["status"] = true;
			$response["message"] ="The town was successfully added";
		}else{
			$response["status"] = false;
			$response["message"] ="The town could not be added";
		}
	}
}
else if($type=="parkingfee"){
	$receiptNo = trim($_POST["receiptNo"]);
	$tReceiptNo = mysqli_real_escape_string($conn, $receiptNo);
	$date = trim($_POST["date"]);
	$month = trim($_POST["month"]);
	$year = trim($_POST["year"]);
	$memberNo = trim($_POST["memberNo"]);
	$vehicleReg = trim($_POST["vehicleReg"]);
	$vehicleReg = str_ireplace(" ", "",$vehicleReg );
	$bankCode = trim($_POST["bankCode"]);
	$paymentMethodCode = trim($_POST["paymentMethodCode"]);
	$externalDocNo = trim($_POST["externalDocNo"]);
	$towns = trim($_POST["towns"]);
	$myTowns = json_decode($towns, true);
	$totalAmount = 0;
	$insertArray = array();
	$insertString = "";
	foreach($myTowns as $myTown){
		$townId =  $myTown["townId"];
		$amount = $myTown["saccoParkingFee"];
		$totalAmount+=$amount;
		array_push($insertArray,$receiptNo);
		array_push($insertArray,$townId);
		array_push($insertArray,$amount);
		$insertString.= strlen($insertString)>0?",":"";
		$insertString.="(?,?,?)";
	}
	
	$check = "SELECT * FROM `parkingreceiptheader` WHERE `receiptNo` = '$tReceiptNo'";
	$checkRes = mysqli_query($conn,$check);
	if(mysqli_num_rows($checkRes)>0){//update
		while($checkResult = mysqli_fetch_assoc($checkRes)){
			if($checkResult["posted"]){
				$response["status"] = false;
				$response["message"] = "The receipt has alredy been posted and cannot be edited";
			}else{
				$insert = "update  `parkingreceiptheader` set `paymentDate` = ?, `month` = ?, `year`=?, `memberNo`=?, `vehicle`=?, `bank`=?, `paymentMethod`=?, `externalDocNo`=?, `amount`=? where `receiptNo` = ? and `posted` = ?";
				$values = array($date,$month,$year,$memberNo,$vehicleReg,$bankCode,$paymentMethodCode,$externalDocNo,$totalAmount,$receiptNo,0);
				if(pdoExecute($insert,$values)){
						$deleteLines = "delete from parkingreceiptlines where receiptNo = ?";
						$deleteArray = array($receiptNo);
						if(pdoExecute($deleteLines,$deleteArray)){
							$insertString = "INSERT INTO `parkingreceiptlines`( `receiptNo`, `townId`, `amount`) VALUES".$insertString; 
							if(pdoExecute($insertString,$insertArray)){
								$response["status"] = true;
								$response["message"] = "The receipt was successfully updated";
							}else{
								$response["status"] = true;
								$response["message"] = "The receipt lines could not be updated";
							}
						}else{
							$response["status"] = true;
							$response["message"] = "The receipt lines could not be updated";
						}
				}else{
						$response["status"] = false;
						$response["message"] = "The receipt could not be updated";
				}
			}
		}
	}else{//insert
		$insert = "INSERT INTO `parkingreceiptheader`(`receiptNo`, `paymentDate`, `month`, `year`, `memberNo`, `vehicle`, `bank`, `paymentMethod`, `externalDocNo`, `amount`, `createdOn`, `createdBy`, `posted`) VALUES (?,?,?,?,?,?,?,?,?,?,NOW(),?,?)";
		$values = array($receiptNo,$date,$month,$year,$memberNo,$vehicleReg,$bankCode,$paymentMethodCode,$externalDocNo,$totalAmount,"",0);
		if(pdoExecute($insert,$values)){
				$insertString = "INSERT INTO `parkingreceiptlines`( `receiptNo`, `townId`, `amount`) VALUES".$insertString; 
				if(pdoExecute($insertString,$insertArray)){
					$response["status"] = true;
					$response["message"] = "The receipt was successfully created";
				}else{
					$response["status"] = true;
					$response["message"] = "The receipt lines could not be created";
				}
				
		}else{
				$response["status"] = false;
				$response["message"] = "The receipt could not be created";
		}
	}
	
	
	
}
else if($type=="servicefeearrears"){
	$arrears = trim($_POST["arrears"]);
	$arrearsArray = json_decode($arrears,true);
	$total = 0;
	$date = "2018-12-31 00:00:00";
	$myLines = array();
	foreach($arrearsArray as $vehicle){
		//print_r($vehicle);
		$vReg = $vehicle[0];
		$vArrear = $vehicle[1];
		$total+=$vArrear;
		$myLine = array();
		$myLine["documentNo"] = "";
		$myLine["externalDocumentno"] = "";
		$myLine["transactionDate"] = $date; //
		$myLine["transactionType"] = "503";
		$myLine["description"] = "Service fee opening balance as at 31/12/2018";
		$myLine["amount"] = $vArrear;
		$myLine["accountType"] ="vehicle";
		$myLine["accountNumber"] =$vReg;
		$myLine["user"] ="1";
		array_push($myLines,$myLine);
	}
	echo $total;
	/*
	$header["accountType"] ="";
				$header["accountNumber"] ="009";
	*/
	$myLine = array();
	$myLine["documentNo"] = "";
	$myLine["externalDocumentno"] = "";
	$myLine["transactionDate"] = $date; //
	$myLine["transactionType"] = "503";
	$myLine["description"] = "Service fee opening balance as at 31/12/2018";
	$myLine["amount"] = $total*-1;
	$myLine["accountType"] ="glaccount";
	$myLine["accountNumber"] ="009";
	$myLine["user"] ="1";
	array_push($myLines,$myLine);
	//echo json_encode($response = post($myLines, "", ""));
}
else if($type=="servicefeeimport"){
	$monthCode = trim($_POST["monthCode"]);
	$tMonthCode = mysqli_real_escape_string($conn, $monthCode);
	$yearCode = trim($_POST["yearCode"]);
	$tYearCode = mysqli_real_escape_string($conn, $yearCode);
	$entries = trim($_POST["entries"]);
	$entryArray = json_decode($entries,true);
	
	//check that no other service fee voucher  has been created under the same month and year
	//create header
	//create lines
	$check = "SELECT * FROM `service_fee_vouchers` WHERE month = '$tMonthCode' AND year = '$tYearCode'";
	$checkres = mysqli_query($conn,$check);
	if(mysqli_num_rows($checkres)>0){
		$response["status"] = false;
		$response["message"] = "Another service fee voucher with the same period has already been created. ";
	}else{
		$insert = "INSERT INTO `service_fee_vouchers`(`month`, `year`, `createdOn`, `createdBy`, `posted` ) VALUES ('$tMonthCode', '$tYearCode', NOW(),'', 0 )";
		$res = mysqli_query($conn, $insert);
		if($res){
			$voucherId = mysqli_insert_id($conn);
			$insertLine = "";
			foreach($entryArray as $entry){
		
				$vehicle =  $entry[0];
				$inactiveDays =  $entry[3];
				$feeCharged =  $entry[4];
				$feeCharged = str_ireplace(",", "", $feeCharged);
				//echo $feeCharged;
				$insertLine.= strlen($insertLine)>0?",":"";
				$insertLine.="('$voucherId', '$vehicle', '$inactiveDays', '$feeCharged')";
			}
			$insertLine = "INSERT INTO `service_fee_lines`(`voucherNo`, `vehicle`, `daysInactive`, `feeCharged`) VALUES $insertLine";
			if(mysqli_query($conn, $insertLine)){
				$response["status"] = true;
				$response["message"] = "The voucher was successfully created ";
				$response["overLoad1"] = getServiceFeeVoucher($voucherId);
			}else{
				$response["status"] = false;
				$response["message"] = "The voucher was successfully created by the voucher lines could not be created. Please try again ";
			}
					
		}else{
			$response["status"] = false;
			$response["message"] = "The service fee voucher could not be created. Please try again";
		}
		
	}
}
else if($type=="importsavings"){
	/*$arrears = trim($_POST["arrears"]);
	$arrearsArray = json_decode($arrears, true);
	$savingsTotal = 0;
	$myLines = array();
	$date = "2018-12-31 00:00:00";
	$description = "Savings opening balance as at 31/12/2018";
	foreach($arrearsArray as $savings){
		$memberNo = $savings[0];
		$amount = $savings[1];
		//echo "Member No: $memberNo Amount: $amount \n";
		$savingsTotal+= $amount;
		$myLine = array();
		$myLine["documentNo"] = "";
		$myLine["externalDocumentno"] = "";
		$myLine["transactionDate"] = $date; //
		$myLine["transactionType"] = "401";
		$myLine["description"] = $description;
		$myLine["amount"] = $amount*-1;
		$myLine["accountType"] ="member";
		$myLine["accountNumber"] =$memberNo;
		$myLine["user"] ="1";
		array_push($myLines,$myLine);
	}
	$myLine = array();
	$myLine["documentNo"] = "";
	$myLine["externalDocumentno"] = "";
	$myLine["transactionDate"] = $date; //
	$myLine["transactionType"] = "401";
	$myLine["description"] = $description;
	$myLine["amount"] = $savingsTotal;
	$myLine["accountType"] ="bank";
	$myLine["accountNumber"] ="5";
	$myLine["user"] ="1";
	array_push($myLines,$myLine);
	//echo json_encode($response = post($myLines, "", ""));*/
}
else if($type=="correctLoans"){
	/*$arrears = trim($_POST["arrears"]);
	$arrearsArray = json_decode($arrears, true);
	$savingsTotal = 0;
	$myLines = array();
	$date = "2018-12-31 00:00:00";
	$description = "Loan Interest Corrections";
	foreach($arrearsArray as $savings){
		$loanNo = $savings[0];
		$amount = $savings[1];
		
		$savingsTotal+= $amount;
		$myLine = array();
		$myLine["documentNo"] = "";
		$myLine["externalDocumentno"] = "";
		$myLine["transactionDate"] = $date; //
		$myLine["transactionType"] = "302";
		$myLine["description"] = $description;
		$myLine["amount"] = $amount;
		$myLine["accountType"] ="loan";
		$myLine["accountNumber"] =$loanNo;
		$myLine["user"] ="1";
		array_push($myLines,$myLine);
	}
	$myLine = array();
	$myLine["documentNo"] = "";
	$myLine["externalDocumentno"] = "";
	$myLine["transactionDate"] = $date; //
	$myLine["transactionType"] = "302";
	$myLine["description"] = $description;
	$myLine["amount"] = $savingsTotal*-1;
	$myLine["accountType"] ="glaccount";
	$myLine["accountNumber"] ="003";
	$myLine["user"] ="1";
	array_push($myLines,$myLine);
	//echo $savingsTotal;
	echo json_encode($response = post($myLines, "", ""));*/
}
else if($type=="kcfrefunds"){
	$arrears = trim($_POST["arrears"]);
	$arrearsArray = json_decode($arrears, true);
	$savingsTotal = 0;
	$myLines = array();
	$date = "2019-03-30 00:00:00";
	$description = "KCF 297 C Refund Corrections";
	foreach($arrearsArray as $savings){
		$loanNo = $savings[0];
		$amount = $savings[1];
		
		$savingsTotal+= $amount;
		$myLine = array();
		$myLine["documentNo"] = "";
		$myLine["externalDocumentno"] = "";
		$myLine["transactionDate"] = $date; //
		$myLine["transactionType"] = "202";
		$myLine["description"] = $description;
		$myLine["amount"] = $amount;
		$myLine["accountType"] ="member";
		$myLine["accountNumber"] =$loanNo;
		$myLine["user"] ="1";
		array_push($myLines,$myLine);
	}
	/*$myLine = array();
	$myLine["documentNo"] = "";
	$myLine["externalDocumentno"] = "";
	$myLine["transactionDate"] = $date; //
	$myLine["transactionType"] = "202";
	$myLine["description"] = $description;
	$myLine["amount"] = $savingsTotal;
	$myLine["accountType"] ="bank";
	$myLine["accountNumber"] ="5";
	$myLine["user"] ="1";
	array_push($myLines,$myLine);*/
	//echo $savingsTotal;
	//echo json_encode($response = post($myLines, "", ""));
}
else if($type=="directincome"){
	$voucherNo = trim($_POST["voucherNo"]);
	$incomeDate = trim($_POST["incomeDate"]);
	$description = trim($_POST["description"]);
	$gLAccount = trim($_POST["gLAccount"]);
	$bankCode = trim($_POST["bankCode"]);
	$amount = trim($_POST["amount"]);
	$externalDocNumber = "";
	if(isset($_POST["externalDocNumber"])){
	$externalDocNumber = trim($_POST["externalDocNumber"]);
	}
	$tVoucherNo = mysqli_real_escape_string($conn, $voucherNo);
	$sql = "SELECT * FROM `directincome` WHERE `voucherNo` = '$tVoucherNo'";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)>0){ //update
		while($result = mysqli_fetch_assoc($res)){
			if($result["posted"]){
				$response["status"] = true;
				$response["message"] = "The income voucher has already been posted";
			}else{
				$insert = "update `directincome` set `voucherDate` = ?, `description`= ?, `glAccount`=?, `bank`=?, `amount`=?, `externalDocNo`=? where `voucherNo` =? and  `posted` = ?";
				$values = array($incomeDate,$description,$gLAccount,$bankCode,$amount,$externalDocNumber, $voucherNo,0);
				if(pdoExecute($insert,$values)){
					$response["status"] = true;
					$response["message"] = "The voucher was successfully updated";
				}else{
					$response["status"] = true;
					$response["message"] = "The voucher could not be updated";
				}
			}
		}
	}else{ //insert
		$insert = "INSERT INTO `directincome`(`voucherNo`, `voucherDate`, `description`, `glAccount`, `bank`, `amount`, `externalDocNo`, `posted`, `createdBy`,`createdOn`) VALUES (?,?,?,?,?,?,?,?,?,NOW())";
		$values = array($voucherNo, $incomeDate,$description,$gLAccount,$bankCode,$amount,$externalDocNumber, 0 ,""  );
		if(pdoExecute($insert,$values)){
			$response["status"] = true;
			$response["message"] = "The voucher was successfully created";
		}else{
			$response["status"] = true;
			$response["message"] = "The voucher could not be created";
		}
	}
}
else if($type=="profitnloss"){
	$code = trim($_POST["code"]);
	$tCode = mysqli_real_escape_string($conn, $code);
	$name = trim($_POST["name"]);
	$name = mysqli_real_escape_string($conn, $name);
	$lines = trim($_POST["lines"]);
	$myLines = json_decode($lines,true);
	
	//
	//check that it exists
	$sql = "select * from profitnloss where code = '$tCode'";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)>0){//update
		$insert = "update profitnloss set `name`= '$name' where code = '$tCode'";
		if(mysqli_query($conn, $insert)){
			$last_id = $tCode;
			$lineValues = "";
			mysqli_query($conn, "delete from profitnlosslines where profitNLossCode = '$tCode'");
			foreach($myLines as $entry){
				if($entry["include"]){
				$glAccount =$entry["glAccount"]["accountNumber"];
				$lineValues.=strlen($lineValues)>0?",":"";
				$lineValues.="(".$last_id.", '".$glAccount."', 1)";
				}
			}
			if(strlen($lineValues)>0){
				$insertLines = "insert into profitnlosslines(`profitNLossCode`, `glAccount`,`include`) values $lineValues"; 
			if(mysqli_query($conn, $insertLines)){
			$response["status"] = true;
			$response["message"] = "The statement was successfully saved";
			$response["overLoad1"] = $last_id;
			}else{
			$response["status"] = true;
			$response["message"] = "The statement was successfully saved";
			$response["overLoad1"] = $last_id;
			}
			
			}else{
			$response["status"] = true;
			$response["message"] = "The statement was successfully saved but does not have any lines";
			$response["overLoad1"] = $last_id;
			}
		}
	}else{//insert
		$insert = "insert into profitnloss (`name`,`createdOn`,`createdBy`) values ('$name',NOW(),'')";
		if(mysqli_query($conn, $insert)){
			$last_id = mysqli_insert_id($conn);
			$lineValues = "";
			foreach($myLines as $entry){
				if($entry["include"]){
				$glAccount =$entry["glAccount"]["accountNumber"];
				$lineValues.=strlen($lineValues)>0?",":"";
				$lineValues.="(".$last_id.", '".$glAccount."', 1)";
				}
			}
			if(strlen($lineValues)>0){
				$insertLines = "insert into profitnlosslines(`profitNLossCode`, `glAccount`,`include`) values $lineValues"; 
			if(mysqli_query($conn, $insertLines)){
			$response["status"] = true;
			$response["message"] = "The statement was successfully saved";
			$response["overLoad1"] = $last_id;
			}else{
			$response["status"] = true;
			$response["message"] = "The statement was successfully saved";
			$response["overLoad1"] = $last_id;
			}
			
			}else{
			$response["status"] = true;
			$response["message"] = "The statement was successfully saved but does not have any lines";
			$response["overLoad1"] = $last_id;
			}
			
		}
	}
}
else if($type=="balancesheet"){
	$bsCode = mysqli_real_escape_string($conn, trim($_POST["bsCode"]));
	$bsName = mysqli_real_escape_string($conn,trim($_POST["bsName"]));
	$includeLoans =mysqli_real_escape_string($conn, trim($_POST["includeLoans"]));
	$includeDeposits =mysqli_real_escape_string($conn, trim($_POST["includeDeposits"]));
	$includeInterestOnMemberDeposits =mysqli_real_escape_string($conn, trim($_POST["includeInterestOnMemberDeposits"]));
	$includeShareCapital = mysqli_real_escape_string($conn,trim($_POST["includeShareCapital"]));
	$includeReserves = mysqli_real_escape_string($conn,trim($_POST["includeReserves"]));
	$check = "select * from balancesheet where code = '$bsCode'";
	$checkres = mysqli_query($conn, $check);
	$insertLines = false;
	if(mysqli_num_rows($checkres)>0){//update
		$update = "update balancesheet set `name`='$bsName',`includeLoans`=$includeLoans,`includeDeposits`=$includeDeposits,`includeInterestOnMemberDeposits`=$includeInterestOnMemberDeposits,`includeShareCapital`=$includeShareCapital,`includeReserves` = $includeReserves where code = '$bsCode'";
		$res= mysqli_query($conn, $update);
		if($res){
			$insertLines = true;
			//$bsCode = mysqli_insert_id($conn);
			$response["status"] = true;
			$response["message"] = "The balance sheet was successfully updated";
			$response["overLoad1"] = $bsCode;
		}else{
			$response["status"] = false;
			$response["message"] = "The balance sheet could not be created. Please try again";
		}
	}else{//insert
		$insert = "insert into balancesheet(`name`,`createdOn`,`createdBy`,`includeLoans`,`includeDeposits`,`includeInterestOnMemberDeposits`,`includeShareCapital`,`includeReserves`) values('$bsName', NOW(),'',$includeLoans,$includeDeposits,$includeInterestOnMemberDeposits,$includeShareCapital ,$includeReserves)";
		$res= mysqli_query($conn, $insert);
		if($res){
			$insertLines = true;
			$bsCode = mysqli_insert_id($conn);
			$response["status"] = true;
			$response["message"] = "The balance sheet was successfully saved";
			$response["overLoad1"] = $bsCode;
		}else{
			$response["status"] = false;
			$response["message"] = "The balance sheet could not be created. Please try again";
		}
	}
	if($insertLines){
		$insertedLines = true;
		$banks = json_decode(trim($_POST["banks"]), true);
		$bankValues = "";
		foreach($banks as $bank){
			$bankCode =  $bank["bank"]["code"];
			$bankValues.=strlen($bankValues)>0?",":"";
			$bankValues.="(".$bsCode.", '$bankCode')";
		}
		if(strlen($bankValues)>0){
			$insertBanks = "insert into balancesheetbanks(`balancesheetcode`,`bankcode`) values ".$bankValues;
			mysqli_query($conn, "delete from balancesheetbanks where balancesheetcode = '$bsCode'");
			if(!mysqli_query($conn, $insertBanks)){
				$insertedLines = false;
			}
		}
		$customerPostingGroups = json_decode(trim($_POST["customerPostingGroups"]), true);
		$customerPostingGroupValues = "";
		foreach($customerPostingGroups as $group){
			$groupCode =  $group["group"]["code"];
			$customerPostingGroupValues.=strlen($customerPostingGroupValues)>0?",":"";
			$customerPostingGroupValues.="('$bsCode', '$groupCode')";
		}
		if(strlen($customerPostingGroupValues)>0){
			$insertBanks = "insert into balancesheetcustomerpostinggroups(`balancesheetcode`,`postinggroupcode`) values ".$customerPostingGroupValues;
			mysqli_query($conn, "delete from balancesheetcustomerpostinggroups where balancesheetcode = '$bsCode'");
			//echo $insertBanks;
			if(!mysqli_query($conn, $insertBanks)){
				$insertedLines = false;
			}
		}
		$vendorPostingGroups = json_decode(trim($_POST["vendorPostingGroups"]), true);
		$vendorPostingGroupValues = "";
		foreach($vendorPostingGroups as $group){
			$groupCode =  $group["group"]["code"];
			$vendorPostingGroupValues.=strlen($vendorPostingGroupValues)>0?",":"";
			$vendorPostingGroupValues.="('$bsCode', '$groupCode')";
		}
		if(strlen($vendorPostingGroupValues)>0){
			$insertBanks = "insert into balancesheetvendorpostinggroups(`balancesheetcode`,`postinggroupcode`) values ".$vendorPostingGroupValues;
			mysqli_query($conn, "delete from balancesheetvendorpostinggroups where balancesheetcode = '$bsCode'");
			if(!mysqli_query($conn, $insertBanks)){
				$insertedLines = false;
			}
		}
		$investments = json_decode(trim($_POST["investments"]), true);
		$investmentsValues = "";
		foreach($investments as $investment){
			$investmentCode =  $investment["investment"]["investmentNo"];
			$investmentsValues.=strlen($investmentsValues)>0?",":"";
			$investmentsValues.="('$bsCode', '$investmentCode')";
		}
		if(strlen($investmentsValues)>0){
			$insertBanks = "insert into balancesheetinvestments(`balancesheetcode`,`investmentcode`) values ".$investmentsValues;
			mysqli_query($conn, "delete from balancesheetinvestments where balancesheetcode = '$bsCode'");
			if(!mysqli_query($conn, $insertBanks)){
				$insertedLines = false;
			}
		}
		$propertyEquipment = json_decode(trim($_POST["propertyEquipment"]), true);
		$propertyValues = "";
		foreach($propertyEquipment as $property){
			$propertyCode =  $property["fixedAsset"]["assetNo"];
			$propertyValues.=strlen($propertyValues)>0?",":"";
			$propertyValues.="('$bsCode', '$propertyCode')";
		}
		if(strlen($propertyValues)>0){
			$insertBanks = "insert into balancesheetfixedassets(`balancesheetcode`,`fixedassetcode`) values ".$propertyValues;
			mysqli_query($conn, "delete from balancesheetfixedassets where balancesheetcode = '$bsCode'");
			if(!mysqli_query($conn, $insertBanks)){
				$insertedLines = false;
			}
		}
		if(!$insertedLines){
			$response["status"] = false;
			$response["message"] = "Some lines of the balnce sheet could not be saved. Please try again";
			$response["overLoad1"] = $bsCode;
		}
		
	}
}
else if($type=="loantopup"){
	$topUpNo = trim($_POST["topUpNo"]);
	$date = trim($_POST["date"]);
	$memberNo = trim($_POST["memberNo"]);
	$loan = trim($_POST["loan"]);
	$topUpAmount = trim($_POST["topUpAmount"]);
	$bank = trim($_POST["bank"]);
	$chequeNo = trim($_POST["chequeNo"]);
	$tTopUpNo = mysqli_real_escape_string($conn, $topUpNo);
	$sql = "select * from loantopup where number = '$tTopUpNo'";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)>0){//update
		while($result = mysqli_fetch_assoc($res)){
			if($result["posted"]){
				$response["status"] = false;
				$response["message"] = "The loan top up has already been posted";
			}else{
				$insert = "update `loantopup` set `topUpDate` = ?,`amount`=?,`member`= ?,`loan`=?,`bank`=?,`chequeNo`=? where `number` = ? and `posted` = 0";
				$values = array($date,$topUpAmount,$memberNo,$loan,$bank,$chequeNo,$topUpNo);
				if(pdoExecute($insert,$values)){
					$response["status"] = true;
					$response["message"] = "The loan top up was successfully updated";
				}else{
					$response["status"] = false;
					$response["message"] = "The loan top up could not be updated";
				}
			}
		}
	}else{//insert
		$insert = "insert into `loantopup`(`number`,`topUpDate`,`amount`,`member`,`loan`,`bank`,`chequeNo`,`addedOn`,`addedBy`,`posted`,`reversed`) values (?,?,?,?,?,?,?,NOW(),?,0,0)";
		$values = array($topUpNo,$date,$topUpAmount,$memberNo,$loan,$bank,$chequeNo, "");
		if(pdoExecute($insert,$values)){
			$response["status"] = true;
			$response["message"] = "The loan top up was successfully created";
		}else{
			$response["status"] = false;
			$response["message"] = "The loan top up could not be created";
		}
	}
	
}
else if($type=="itembrand"){
	$id = 0;
	if(isset($_POST['id'])){
		$id = trim($_POST['id']);
	}
	
	$name = mysqli_real_escape_string($conn, trim($_POST['name']));
	if (!is_null($id)) {
		$res = mysqli_query($conn, "SELECT * FROM `itemBrand` WHERE id = '$id'");
		if (mysqli_num_rows($res)>0) {// update
			$result = mysqli_query($conn, "UPDATE itemBrand SET `name`='$name' WHERE  `id` = $id");
			if ($result) {
				$response["status"] = true;
				$response["message"] = "Brand name has been updated successfully";
			}else{
				$response["status"] = false;
				$response["message"] = "Brand name could not be updated";
			}
		}else{//create
			$result = mysqli_query($conn, "INSERT INTO `itemBrand` VALUES(null, '$name')");
			if ($result) {
				$response["status"] = true;
				$response["message"] = "Brand has been added successfully";
			}else{
				$response["status"] = false;
				$response["message"] = "Brand could not be added ";
			}
		}
	}else{//create
		$result = mysqli_query($conn, "INSERT INTO `itemBrand` VALUES(null, '$name')");
		if ($result) {
			$response["status"] = true;
			$response["message"] = "Brand has been added successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "Brand could not be added ";
		}
	}
}
else if($type=="unitofmeasure"){
	$id = 0;
	if(isset($_POST['id'])){
	$id = $_POST['id'];
	}
	$name = mysqli_real_escape_string($conn, $_POST['name']);
	if (!is_null($id)) {
		$res = mysqli_query($conn, "SELECT * FROM `unitsOfMeasure` WHERE id = '$id'");
		if (mysqli_num_rows($res)>0) {// update
			$result = mysqli_query($conn, "UPDATE unitsOfMeasure SET `name`='$name' WHERE  `id` = $id");
			if ($result) {
				$response["status"] = true;
				$response["message"] = "Unit of measure has been updated successfully";
			}else{
				$response["status"] = false;
				$response["message"] = "Unit of measure could not be updated";
			}
		}else{//create
			$result = mysqli_query($conn, "INSERT INTO `unitsOfMeasure` VALUES(null, '$name')");
			if ($result) {
				$response["status"] = true;
				$response["message"] = "Unit of measure has been added successfully";
			}else{
				$response["status"] = false;
				$response["message"] = "Unit of measure could not be added ";
			}
		}
	}else{//create
		$result = mysqli_query($conn, "INSERT INTO `unitsOfMeasure` VALUES(null, '$name')");
		if ($result) {
			$response["status"] = true;
			$response["message"] = "Unit of measure has been added successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "Unit of measure could not be added ";
		}
	}
}
else if($type=="shoplocation"){
	$id = 0;
	if(isset($_POST['id'])){
	    $id = $_POST['id'];
	}
	$name = trim($_POST['name']);
	$vsm = trim($_POST["vsm"]);
	$create = false;
	if (!(is_null($id)||$id=="0")) {
		$res = fetchWithPdo("SELECT * FROM `shopLocations` WHERE id = ?",array($id));
		if (count($res)>0) {// update
			$result = pdoExecute( "UPDATE shopLocations SET `name`=?, `vsm`=?  WHERE  `id` =?",array($name,$vsm,$id));
			if ($result) {
				$response["status"] = true;
				$response["message"] = "The Warehouse has been updated successfully";
			}else{
				$response["status"] = false;
				$response["message"] = "The Warehouse could not be updated";
			}
		}else{//create
		    $create = true;
		}
	}else{//create
	    $create = true;
	}
	if($create){
	   $result = pdoExecute("INSERT INTO `shopLocations` (`name`, `vsm`, `added_on`, `added_by`) VALUES(?,?,NOW(),?)",array($name,$vsm,$myUserName));
	   if ($result) {
	   	$response["status"] = true;
	   	$response["message"] = "The Warehouse has been added successfully";
	   }else{
	   	$response["status"] = false;
	   	$response["message"] = "The Warehouse could not be added ";
	   } 
	}
}
else if($type=="taxgroup"){
	$code = $_POST['code'];
	$name = mysqli_real_escape_string($conn, $_POST['name']);
	$percentage = $_POST['percentage'];
	if (!is_null($code)) {
		$res = mysqli_query($conn, "SELECT * FROM `taxGroups` WHERE code = '$code'");
		if (mysqli_num_rows($res)>0) {// update
			$result = mysqli_query($conn, "UPDATE taxGroups SET `name`='$name', `percentage`='$percentage' WHERE  `code` = '$code'");
			if ($result) {
				$response["status"] = true;
				$response["message"] = "Tax group has been updated successfully";
			}else{
				$response["status"] = false;
				$response["message"] = "Tax group could not be updated";
			}
		}else{//create
			$result = mysqli_query($conn, "INSERT INTO `taxGroups` VALUES('$code', '$name', '$percentage')");
			if ($result) {
				$response["status"] = true;
				$response["message"] = "Tax group has been added successfully";
			}else{
				$response["status"] = false;
				$response["message"] = "Tax Group 1 could not be added ";
			}
		}
	}else{//create
		$result = mysqli_query($conn, "INSERT INTO `taxGroups` VALUES('$code', '$name', '$percentage')");
		if ($result) {
			$response["status"] = true;
			$response["message"] = "Tax group  has been added successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "Tax group could not be added ";
		}
	}
}
else if($type=="item"){
     // include("defaults.php");
	$code = $_POST['code'];
	$updateNumberSeries =false;
	$buyingPrice = $_POST['buyingPrice'];
	$price = $_POST['price'];
	$discount = $_POST['discount'];
	$taxGroup = $_POST['taxGroup'];
	$brand = $_POST['brand'];
	$uom = $_POST['uom'];
	$postingGroup = $_POST['postingGroup'];
	$upc = $_POST['upc'];
	$photo = $_POST['photo'];
	$imageName = $_POST['imageName'];
	$extension = explode(".",$imageName);
	$reOrderLevel =0;
	$country = trim($_POST["country"]);
	$itemClass = trim($_POST["itemClass"]);
	$myItemType = trim($_POST["myItemType"]);
	$myPackaging = trim($_POST["myPackaging"]);
	$dmsNo = trim($_POST["dmsNo"]);
	$originalCode="";
	if(strlen($code)<4){
	    $originalCode= getNextNumber(39);
	    $updateNumberSeries =true;
	    $code =$originalCode;
	}
	if( strlen($buyingPrice)>0 && strlen($price)>0 && strlen($discount)>0 && strlen($taxGroup)>0 && strlen($brand)>0 && strlen($uom)>0 && strlen($postingGroup)>0 && strlen($country)>0 && strlen($itemClass)>0 && strlen($myItemType)>0 && strlen($myPackaging)>0){
		if(isset($_POST["reOrderLevel"])){
		    $reOrderLevel =$_POST["reOrderLevel"]; 
		}
		if(strlen($code)<5){
		   $code = $country.$myItemType.$myPackaging.$uom.$code;
		}
		$image="";
		$sql = "";
		$description = mysqli_real_escape_string($conn, $_POST['description']);
		$name = mysqli_real_escape_string($conn, $_POST['name']);
		$uploadImage = false;
		if (!is_null($code)) {
			$res = mysqli_query($conn, "SELECT * FROM `items` WHERE code = '$code'");
			if (mysqli_num_rows($res)>0) {// update
				$response["status"] = false;
				$response["message"] = "An item with the selected code already exists";
			}else{//create
				$result = mysqli_query($conn, "INSERT INTO `items`(`code`, `name`, `description`, `unitOfMeasure`, `taxGroup`, `brand`, `postingGroup`,`origin_country`, `item_class`, `item_type`, `packaging_unit`,`buying_price`, `price`, `percentageDiscount`, `photo`, `photoUrl`,`upcCode`,`reOrderLevel`,`addedOn`, `addedBy`,`dms_no`) VALUES
				('$code', '$name', '$description', '$uom', '$taxGroup', '$brand','$postingGroup','$country','$itemClass','$myItemType','$myPackaging','$buyingPrice', '$price', '$discount','','', '$upc','$reOrderLevel',NOW(),'$myUserName','$dmsNo')");
				if ($result) {
					$response["status"] = true;
					$response["message"] = "Item has been added successfully";
					if($updateNumberSeries){
                        updateLastNumber(39,$originalCode);
					}
					$uploadImage = true;
					$price1=$price2=$price3=$price4=$price5=$price;
					sendItemToEtims("00",$code,$price,$price1,$price2,$price3,$price4,$price5);
					$response["message"] = "Item has been added successfully";
				}else{
					$response["status"] = false;
					$response["message"] = "Item could not be added ".mysqli_error($conn);
				}
			}
			if($uploadImage){
			    	try{
			    	    if(strlen($photo)>0){
    			    	    $fileName = "itemimages/".$code.".".$extension[1];
    	            	    file_put_contents($fileName,base64_decode($photo));
    	            	    $update = "update items set photoUrl =? where code=?";
    	            	    $values = array($fileName,$code);
    	            	    pdoExecute($update,$values);
			    	    }
    	        	}catch(Exception $t){
					
    	        	}
			}
		}
	}else{
		$response["status"] = false;
		$fields = "";
		$fields.= strlen($code)>0?"":"Product Code ";
		$fields.= strlen($buyingPrice)>0?"":"Buying Price";
		$fields.= strlen($price)>0?"":"Selling Price";
		$fields.= strlen($discount)>0?"":"Discount";
		$fields.= strlen($taxGroup)>0?"":"tax group";
		$fields.= strlen($brand)>0?"":"Brand";
		$fields.= strlen($uom)>0?"":"Unit of Measure";
		$fields.= strlen($postingGroup)>0?"":"Posting Group";
		$fields.= strlen($country)>0?"":"country";
		$fields.= strlen($itemClass)>0?"":"Item Class";
		$fields.= strlen($myItemType)>0?"":"item type";
		$fields.= strlen($myPackaging)>0?"":"Packaging";
		$response["message"] = "Kindly Fill All fields $fields";
	}
}
else if($type=="unitofmeasurerelationships"){
    $unitOfMeasureCode = mysqli_real_escape_string($conn,trim($_POST['unitOfMeasureCode']));
    $quantity = mysqli_real_escape_string($conn,trim($_POST['quantity']));
    $sellingPrice = mysqli_real_escape_string($conn,trim($_POST['sellingPrice']));
    $itemCode = mysqli_real_escape_string($conn,trim($_POST['itemCode']));
    $check = "SELECT * FROM `unitofmeasurerelationships` WHERE `productCode`='$itemCode' and `unitOfMeasureCode` = '$unitOfMeasureCode'";
    $checkres = mysqli_query($conn,$check);
    if(mysqli_num_rows($checkres)>0){//update
         $sql = "update `unitofmeasurerelationships` set  `quantity`=?, `sellingPrice`=? where `productCode`=? and `unitOfMeasureCode`=?";
        $values = array($quantity,$sellingPrice,$itemCode,$unitOfMeasureCode);
        if(pdoExecute($sql,$values)){
            $response["status"] = true;
			$response["message"] = "The relationship was successfully updated";
        }else{
            $response["status"] = false;
			$response["message"] = "The relationship could not be updated";
        }
    }else{//create
        $sql = "INSERT INTO `unitofmeasurerelationships`(`productCode`, `unitOfMeasureCode`, `quantity`, `sellingPrice`, `addedBy`, `addedOn`) VALUES (?,?,?,?,?,NOW())";
        $values = array($itemCode,$unitOfMeasureCode,$quantity,$sellingPrice,$myUserName);
        if(pdoExecute($sql,$values)){
            $response["status"] = true;
			$response["message"] = "The relationship was successfully created";
        }else{
            $response["status"] = false;
			$response["message"] = "The relationship could not be created";
        }
    }
    
}
else if($type=="expresssale"){
	$code = trim($_POST['code']);
	$date = "";//trim($_POST['date']);
	if(isset($_POST['date'])){
	    $date = trim($_POST['date']);
	}else{
	    $today = new DateTime();
        $date = $today->format('Y-m-d');
	}
	$docNo = trim($_POST['docNo']);
	$bank = trim($_POST['bank']);
	$location = "";
	if(isset($_POST['location'])){
	    $location = trim($_POST['location']);
	}else{
	    $userInfo = fetchWithPdo("SELECT * FROM `users` WHERE username = ?",array($myUserName));
	    $location = $userInfo[0]["store_location"];
	    //echo "My location is $location";
	}
	if (!is_null($code)) {#(`code`, `dateCreated`, `bank`, `externalDocNo`, `location`, `posted`, `postedOn`, `postedBy`, `reversed`, `reversedOn`, `reversedBy`)
		$res = mysqli_query($conn, "SELECT * FROM `expressSales` WHERE code = '$code'");
		if (mysqli_num_rows($res)>0) {// update
			$result = mysqli_query($conn, "UPDATE expressSales SET `dateCreated`='$date', `bank`='$bank',`externalDocNo`='$docNo',`location`='$location'
			 WHERE  `code` = '$code'");
			if ($result) {
				$response["status"] = true;
				$response["message"] = "Sale has been updated successfully";
			}else{
				$response["status"] = false;
				$response["message"] = "Sale could not be updated";
			}
		}else{//create
			$result = mysqli_query($conn, "INSERT INTO `expressSales`(`code`, `dateCreated`, `bank`, `externalDocNo`, `location`) VALUES('$code', '$date', '$bank', '$docNo', '$location')");
			if ($result) {
				$response["status"] = true;
				$response["message"] = "Sale has been added successfully";
			}else{
				$response["status"] = false;
				$response["message"] = "Sale could not be added ".mysqli_error($conn);
			}
		}
	}
}
else if($type=="expresssaleline"){
	$item = "";//mysqli_real_escape_string($conn,trim($_POST['item']));
	$unitPrice = 0;//mysqli_real_escape_string($conn,trim($_POST['unitPrice']));
	$quantity = 1;//mysqli_real_escape_string($conn,trim($_POST['quantity']));
	$saleCode = mysqli_real_escape_string($conn,trim($_POST['saleCode']));
	if(isset($_POST["itemCode"])){
	    $item = mysqli_real_escape_string($conn,trim($_POST['itemCode']));
	    $myItem = fetchWithPdo("SELECT code,price FROM `items` WHERE code = ?",array(trim($_POST['itemCode'])));
	    if(isset($myItem[0])){
	        $unitPrice = $myItem[0]["price"];
	    }
	}else if(isset($_POST["upcCode"])){
	    $myItem = fetchWithPdo("SELECT code,price FROM `items` WHERE upcCode = ?",array(trim($_POST['upcCode'])));
	   if(isset($myItem[0])){
	      $item = $myItem[0]["code"];
	    $unitPrice = $myItem[0]["price"]; 
	   } 
	}
	 
	//get item, 
	$check = "SELECT A.*,B.percentage taxPercentage FROM `items` A left join taxGroups B on A.taxGroup = B.code where A.code='$item'";
//	echo $check;
	$checkres = mysqli_query($conn, $check);
	if(mysqli_num_rows($checkres)<1){
		$response["status"] = false;
		$response["message"] = "An item with the selected code does not exist";
	}else{	
		$taxPercentage = 0;
		while($checkResults = mysqli_fetch_assoc($checkres)){
			$taxPercentage = $checkResults["taxPercentage"];
		}
		$sel = "SELECT * FROM `expresssalelines` WHERE `item`='$item' AND `saleCode`='$saleCode' ";
		$res = mysqli_query($conn, $sel);
		if (mysqli_num_rows($res)>0) {
			$row = mysqli_fetch_assoc($res);
			$q = $row['quantity'];
			$total = $quantity+$q;
			$id = $row['id'];
			$update = "UPDATE `expresssalelines` SET `quantity` = '$total', `unitPrice` = '$unitPrice',`totalAmount` =(quantity*unitPrice), `totalVAT`=(($taxPercentage/100)*totalAmount), `totalExclVAT` = (totalAmount-totalVAT)  WHERE `id`='$id'";
			$result = mysqli_query($conn, $update);
			if ($result) {
				$response["status"] = true;
				$response["message"] = "Sale Line has been updated successfully";
				$get = "SELECT A.*, B.name, B.price, B.percentageDiscount FROM `expresssalelines` A LEFT JOIN `items` B ON A.item=B.code WHERE `saleCode`='$saleCode'";
				$res = mysqli_query($conn, $get);
				$lines = array();
				while ($row2 = mysqli_fetch_assoc($res)) {
					$line = array();
					$line['id']=$row2['id'];
					$line['item']=$row2['item'];
					$line['unitPrice']=$row2['unitPrice'];
					$line['quantity']=$row2['quantity'];
					$line['saleCode']=$row2['saleCode'];
					$item = array();
					$item['code'] = $row2['item'];
					$item['name'] = $row2['name'];
					$item['discount'] = $row2['percentageDiscount'];
					$item['price'] = $row2['price'];
					$line['item'] = $item;
					array_push($lines, $line);
				}
				$response['overLoad1']=json_encode($lines);
			}else{
				$response["status"] = false;
				$response["message"] = "Sale Line could not be added ".mysqli_error($conn);
			}
		}else{
			$result = mysqli_query($conn, "INSERT INTO `expresssalelines`(`id`, `item`, `unitPrice`, `quantity`, `saleCode`, `totalAmount`,`totalVAT`,`totalExclVAT` ) VALUES(null, '$item', '$unitPrice', '$quantity', '$saleCode',(quantity*unitPrice), (($taxPercentage/100)*totalAmount),(totalAmount-totalVAT))");
			if ($result) {
				$response["status"] = true;
				$response["message"] = "Sale Line has been added successfully";
				$get = "SELECT A.*, B.name, B.price, B.percentageDiscount FROM `expresssalelines` A LEFT JOIN `items` B ON A.item=B.code WHERE `saleCode`='$saleCode'";
				$res = mysqli_query($conn, $get);
				$lines = array();
				while ($row2 = mysqli_fetch_assoc($res)) {
					$line = array();
					$line['id']=$row2['id'];
					$line['item']=$row2['item'];
					$line['unitPrice']=$row2['unitPrice'];
					$line['quantity']=$row2['quantity'];
					$line['saleCode']=$row2['saleCode'];
					$item = array();
					$item['code'] = $row2['item'];
					$item['name'] = $row2['name'];
					$item['discount'] = $row2['percentageDiscount'];
					$item['price'] = $row2['price'];
					$line['item'] = $item;
					array_push($lines, $line);
				}
				$response['overLoad1']=json_encode($lines);
			}else{
				$response["status"] = false;
				$response["message"] = "Sale Line could not be added ".mysqli_error($conn);
			}
		}
	}

	}
else if($type=="stocktransfer"){#`(`code`, `dateCreated`, `transferFrom`, `transferTo`, `posted`, `postedOn`, `postedBy`, `reversed`, `reversedOn`, `reversedBy`)
	$code = trim($_POST['code']);
	$dateCreated = trim($_POST['dateCreated']);
	$transferFrom = trim($_POST['transferFrom']);
	$transferTo = trim($_POST['transferTo']);
	$sel = "SELECT * FROM `stocktransfers` WHERE `code` = '$code'";
	$res = mysqli_query($conn, $sel);
	if (mysqli_num_rows($res)>0) {#update
		$query = "UPDATE `stocktransfers` SET `dateCreated`='$dateCreated', `transferFrom`='$transferFrom', `transferTo`='$transferTo' WHERE `code`='$code'";
		$result = mysqli_query($conn, $query);
		if ($result) {
			$response["status"] = true;
			$response["message"] = "Stock transfer has been updated successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "Stock transfer could not be updated";
		}
	}else{#create
		$query = "INSERT INTO `stocktransfers` (`code`, `dateCreated`, `transferFrom`, `transferTo`) VALUES ('$code','$dateCreated','$transferFrom','$transferTo')";
	//	echo $query;
		$result = mysqli_query($conn, $query);
		if ($result) {
			$response["status"] = true;
			$response["message"] = "Stock transfer has been created successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "Stock transfer could not be created";
		}
	}
}
else if($type=="stocktransferline"){#`stockTransferLines`(`id`, `item`, `unitPrice`, `quantity`, `transferCode`)
	$code = trim($_POST['transferCode']);
	$item = $_POST['item'];
	$unitPrice = $_POST['unitPrice'];
	$quantity = $_POST['quantity'];
	$transferCode = $_POST['transferCode'];
	$productInfo = fetchWithPdo("SELECT * FROM `items` WHERE code = ?",array($item));
	$unitPrice=isset($productInfo[0]["buying_price"])?$productInfo[0]["buying_price"]:0;
	$sel = "SELECT * FROM `stocktransferlines` WHERE `item`='$item' AND `transferCode`='$transferCode'";
	$res = mysqli_query($conn, $sel);
	if (mysqli_num_rows($res)>0) {
		$row = mysqli_fetch_assoc($res);
		$q = $row['quantity'];
		$total = $quantity+$q;
		$id = $row['id'];
		$query = "UPDATE `stocktransferlines` SET `unitPrice`='$unitPrice',`quantity`='$total' WHERE `id`=$id ";
		$result = mysqli_query($conn, $query);
		if ($result) {
		$response["status"] = true;
		$response["message"] = "Stock transfer line has been updated successfully";
		$get = "SELECT A.*, B.name, B.price, B.percentageDiscount FROM `stocktransferlines` A LEFT JOIN `items` B ON A.item=B.code WHERE `transferCode`='$transferCode'";
			$res = mysqli_query($conn, $get);
			$lines = array();
			while ($row2 = mysqli_fetch_assoc($res)) {
				$line = array();
				$line['id']=$row2['id'];
				$line['item']=$row2['item'];
				$line['unitPrice']=$row2['unitPrice'];
				$line['quantity']=$row2['quantity'];
				$line['transferCode']=$row2['transferCode'];
				$item = array();
				$item['code'] = $row2['item'];
				$item['name'] = $row2['name'];
				$item['discount'] = $row2['percentageDiscount'];
				$item['price'] = $row2['price'];
				$line['item'] = $item;
				array_push($lines, $line);
			}
			$response['overLoad1']=json_encode($lines);
		}else{
		$response["status"] = false;
		$response["message"] = "Stock transfer line could not be updated";
		}
	}else{
		$query = "INSERT INTO `stocktransferlines` VALUES(null, '$item','$unitPrice','$quantity','$transferCode')";
		$result = mysqli_query($conn, $query);
		if ($result) {
			$response["status"] = true;
			$response["message"] = "Stock transfer line has been created successfully";
			$get = "SELECT A.*, B.name, B.price, B.percentageDiscount FROM `stocktransferlines` A LEFT JOIN `items` B ON A.item=B.code WHERE `transferCode`='$transferCode'";
			$res = mysqli_query($conn, $get);
			$lines = array();
			while ($row2 = mysqli_fetch_assoc($res)) {
				$line = array();
				$line['id']=$row2['id'];
				$line['item']=$row2['item'];
				$line['unitPrice']=$row2['unitPrice'];
				$line['quantity']=$row2['quantity'];
				$line['transferCode']=$row2['transferCode'];
				$item = array();
				$item['code'] = $row2['item'];
				$item['name'] = $row2['name'];
				$item['discount'] = $row2['percentageDiscount'];
				$item['price'] = $row2['price'];
				$line['item'] = $item;
				array_push($lines, $line);
			}
			$response['overLoad1']=json_encode($lines);
		}else{
			$response["status"] = false;
			$response["message"] = "Stock transfer line could not be created";
		}
	}			
}
elseif ($type=="contact") {#contacts` (`id`, `name` ,`phoneNumber`,`createdOn`, `createdBy
	$id = trim($_POST['id']);
	$name = trim($_POST['name']);
	$phoneNumber = trim($_POST['phoneNumber']);
	$sel = "SELECT * FROM `contacts` WHERE `id`='$id'";
	$res = mysqli_query($conn, $sel);
	if (mysqli_num_rows($res)>0) {#update
		$update = "UPDATE `contacts` SET `name`='$name' ,`phoneNumber`='$phoneNumber' WHERE `id`='$id'";
		$result = mysqli_query($conn, $update);
		if ($result) {
			$response["status"] = true;
			$response["message"] = "Contact has been successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "Contact has not been updated !";
		}
	}else{#create
		$query = "INSERT INTO `contacts` VALUES('$id', '$name', '$phoneNumber', NOW(), '1')";
		$result = mysqli_query($conn, $query);
		if ($result) {
			$response["status"] = true;
			$response["message"] = "Contact has been successfully created";
		}else{
			$response["status"] = false;
			$response["message"] = "Contact could not be created";
		}
	}
}
elseif ($type=="group") {# `groups` (`id`,`name`,`createdOn`,`createdBy`
	$id = trim($_POST['id']);
	$name = trim($_POST['name']);
	$sel = "SELECT * FROM `groups` WHERE `id`='$id'";
	$res = mysqli_query($conn, $sel);
	if (mysqli_num_rows($res)>0) {#update
	  	$update = "UPDATE `groups` SET `name`='$name' WHERE `id`='$id' ";
	  	$result = mysqli_query($conn, $update);
	  	if ($result) {
			$response["status"] = true;
			$response["message"] = "Group has been successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "Group has not been updated !";
		}
	}else{#create
		$query = "INSERT INTO `groups`(`id`,`name`,`createdOn`,`createdBy`) VALUES('$id', '$name', NOW(),'1') ";
		$result = mysqli_query($conn, $query);
		if ($result) {
			$response["status"] = true;
			$response["message"] = "Group has been successfully created";
		}else{
			$response["status"] = false;
			$response["message"] = "Group could not be created ";
		}
	}  
}
elseif ($type=="groupmember") {#`groupMembers` (`id`,`group`,`contact`
 	$group = $_POST['group'];
 	$contact = $_POST['contact'];
 	$sel = mysqli_query($conn, "SELECT * FROM `groupMembers` WHERE `group` ='$group' AND `contact`='$contact'");
 	if (mysqli_num_rows($sel)>0) {
 		$response["status"] = false;
		$response["message"] = "Contact is already in the group";
 	}else{
	 	$query = "INSERT INTO `groupMembers`(`group`,`contact`) VALUES ('$group', '$contact')";
	 	$result = mysqli_query($conn, $query);
		if ($result) {
			$response["status"] = true;
			$response["message"] = "Contact has been added to the group";
			$getMembers = mysqli_query($conn, "SELECT A.*, B.name, B.phoneNumber FROM groupMembers A LEFT JOIN contacts B ON B.id=A.contact WHERE `group`='$group'");
			$members = array();
			while ($line = mysqli_fetch_assoc($getMembers)) {
				$member = array();
				$contact = array();
				$contact['id']=$line['contact'];
				$contact['name']=$line['name'];
				$contact['phoneNumber']=$line['phoneNumber'];
				$member['contact'] = $contact;
				$member['group']=$group;
				array_push($members, $member);
			}
		$response['overLoad1']=json_encode($members);
		}else{
			$response["status"] = false;
			$response["message"] = "Contact could not be added to the group";
		}
	}
}
elseif ($type=="sms") {#`sms` (`id`,`recipient`, `recipientNo`, `message`,`enteredOn`, `status`, `sentOn`,`createdOn`, `createdBy`
	$recipientType = trim($_POST['recipientType']);
	if ($recipientType=="group") {
		$groupId = mysqli_real_escape_string($conn, trim($_POST['recipient']));
		$myMessage = trim($_POST['message']);
		$message = mysqli_real_escape_string($conn, trim($_POST['message']));
		$status = "sent";
		//check if group is a virtual group
		$check = "select * from groups where id = '$groupId'";
		$checkRes = mysqli_query($conn, $check);
		while($checkResults = mysqli_fetch_assoc($checkRes)){
			if($checkResults["virtualGroup"]){
				$sql = $checkResults["query"];
				$res = mysqli_query($conn,$sql);
				$recipients = "";
				while($result = mysqli_fetch_assoc($res)){
					$phoneNumber =$result["PhoneNumber"] ;
					if(strlen($phoneNumber)==10){
						$phoneNumber = "+254".substr($phoneNumber,1);
					}
					$recipients .= strlen($recipients)>0?",":"";
					$recipients .= $phoneNumber;
					
				//$query = "INSERT INTO `sms` (`recipient`, `recipientNo`, `message`,`enteredOn`, `status`,`createdBy`, sentOn,`createdOn`) VALUES ('','$phoneNumber','$message', NOW(), '$status', '1', NOW(), NOW()) ";
				/*$result = mysqli_query($conn, $query);
				if (!$result) {
					$error = true;
				}*/
				sendTextMessage($recipients, $myMessage);
				}
			}else{
		$sel = "SELECT A.*, B.* FROM groupMembers A LEFT JOIN contacts B ON B.id = A.contact WHERE A.group='$groupId'";
		$res = mysqli_query($conn, $sel);
		if (mysqli_num_rows($res)<1) {
			$response["status"] = false;
			$response["message"] = "Selected group has no members";
		}else{
			$error = false;
			while ($row = mysqli_fetch_assoc($res)) {
				$recipient = $row['contact'];
				$recipientNo = $row['phoneNumber'];
				sendTextMessage($recipientNo, $message);
				$query = "INSERT INTO `sms` (`recipient`, `recipientNo`, `message`,`enteredOn`, `status`,`createdBy`, sentOn,`createdOn`) VALUES ('$recipient','$recipientNo','$message', NOW(), '$status', '1', NOW(), NOW()) ";
				$result = mysqli_query($conn, $query);
				if (!$result) {
					$error = true;
				}
			}
		}
			if (!$error) {
				$response["status"] = true;
				$response["message"] = "sms were added successfully";
			}else{
				$response["status"] = false;
				$response["message"] = "sms could not be entered";
			}
		
		}
		}
	}else{
		$id = 0;
		if(isset($_POST['id'])){
			$id=trim($_POST['id']);
		}
		
		$recipient = trim($_POST['recipient']);
		$recipientNo = $_POST['recipientNo'];
		$message = trim($_POST['message']);
		$status = $_POST['status'];
		$sel = "SELECT * FROM `sms` WHERE `id`='$id'";
		$res = mysqli_query($conn, $sel);
		if (!is_null($id) && mysqli_num_rows($res)>0) {
			$update = "UPDATE `sms` SET `recipient`='$recipient',`recipientNo`='$recipientNo', `message`='$message', `enteredOn`=NOW() WHERE `id`='$id'";
			if ($status == "sent") {
				sendTextMessage($recipientNo, $message);
				$update = "UPDATE `sms` SET `recipient`='$recipient',`recipientNo`='$recipientNo', `message`='$message', `enteredOn`=NOW(), `status`='$status', `sentOn`=NOW() WHERE `id`='$id'";
			}
			$result = mysqli_query($conn,$update);
			if ($result) {
				$response["status"] = true;
				$response["message"] = "The  message has been successfully updated";
			}else{
				$response["status"] = false;
				$response["message"] = "The sms could not be updated";
			}
		}
		else{
			$query = "INSERT INTO `sms` (`recipient`, `recipientNo`, `message`,`enteredOn`, `status`,`createdBy`,`createdOn`) VALUES ('$recipient','$recipientNo','$message', NOW(), '$status', '1', NOW()) ";
			if ($status == "sent") {
				sendTextMessage($recipientNo, $message);
				$query = "INSERT INTO `sms` (`recipient`, `recipientNo`, `message`,`enteredOn`, `status`,`createdBy`, sentOn,`createdOn`) VALUES ('$recipient','$recipientNo','$message', NOW(), '$status', '1', NOW(), NOW()) ";
			}
			$result = mysqli_query($conn, $query);
			if ($result) {
				$response["status"] = true;
				$response["message"] = "sms has been added successfully";
			}else{
				$response["status"] = false;
				$response["message"] = "sms could not be entered";
			}
		}
	}
}
elseif ($type=="createglaccount"){
	if(isset($_POST["accountNumber"])){
	    $accountNumber = mysqli_real_escape_string($conn, trim($_POST["accountNumber"]));
		$accountName = mysqli_real_escape_string($conn, trim($_POST["accountName"]));
		
		$accountType = mysqli_real_escape_string($conn, trim($_POST["accountType"]));
		$accountCategory = mysqli_real_escape_string($conn, trim($_POST["accountCategory"]));
		$accountSubCategory = mysqli_real_escape_string($conn, trim($_POST["accountSubCategory"]));
		$accountGroup = mysqli_real_escape_string($conn, trim($_POST["accountGroup"]));
		
		$myAllow = 1;
		$sql = "INSERT INTO `chartofaccounts`(`accountNumber`, `account_type`, `account_category`, `account_sub_category`, `account_group`,`accountName`, `allowPosting`,`added_on`,`added_by`) VALUES (?,?,?,?,?,?,?,NOW(),?)";
		$values = array($accountNumber,$accountType,$accountCategory,$accountSubCategory,$accountGroup,$accountName,$myAllow,$myUserName);
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] ="The Account was successfully added";
			}else{
				$response["status"] = false;
				$response["message"] ="The account could not be added";
			}
	}
}
elseif ($type=="editglaccount1"){
	if(isset($_POST["accountNumber"])){
		$accountNumber = mysqli_real_escape_string($conn, trim($_POST["accountNumber"]));
		$accountName = mysqli_real_escape_string($conn, trim($_POST["accountName"]));
		$allowPosting = mysqli_real_escape_string($conn, trim($_POST["allowPosting"]));
		$bsAccount = mysqli_real_escape_string($conn, trim($_POST["bsAccount"]));
		$myAllow = $allowPosting?1:0;
		$sql = "update `chartofaccounts` set `accountName` = '$accountName', `allowPosting`='$allowPosting',`balanceSheetAccount`='$bsAccount' where `accountNumber`= '$accountNumber'";
			if(mysqli_query($conn, $sql)){
				$response["status"] = true;
				$response["message"] ="The Account was successfully updated";
			}else{
				$response["status"] = false;
				$response["message"] ="The account could not be updated";
			}
	}
}
elseif ($type=="glaccount"){
	if(isset($_POST["accountNumber"])){
	    $accountNumber = mysqli_real_escape_string($conn, trim($_POST["accountNumber"]));
	    if(strlen($accountNumber)<1){
	        $accountNumber=getGlAccountNumber();
	    }
		$accountName = mysqli_real_escape_string($conn, trim($_POST["accountName"]));
		
		$accountType = mysqli_real_escape_string($conn, trim($_POST["accountType"]));
		$accountCategory = mysqli_real_escape_string($conn, trim($_POST["accountCategory"]));
		$accountSubCategory = mysqli_real_escape_string($conn, trim($_POST["accountSubCategory"]));
		$accountGroup = mysqli_real_escape_string($conn, trim($_POST["accountGroup"]));
		
		$myAllow = 1;
		$sql = "INSERT INTO `chartofaccounts`(`accountNumber`, `account_type`, `account_category`, `account_sub_category`, `account_group`,`accountName`, `allowPosting`,`added_on`,`added_by`) VALUES (?,?,?,?,?,?,?,NOW(),?)";
		$values = array($accountNumber,$accountType,$accountCategory,$accountSubCategory,$accountGroup,$accountName,$myAllow,$myUserName);
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] ="The Account was successfully added";
			}else{
				$response["status"] = false;
				$response["message"] ="The account could not be added";
			}
	}
}
elseif ($type=="editglaccount"){
	if(isset($_POST["accountNumber"])){
		$accountNumber = mysqli_real_escape_string($conn, trim($_POST["accountNumber"]));
		$accountName = mysqli_real_escape_string($conn, trim($_POST["accountName"]));
		$allowPosting = mysqli_real_escape_string($conn, trim($_POST["allowPosting"]));
		$bsAccount = mysqli_real_escape_string($conn, trim($_POST["bsAccount"]));
		$myAllow = $allowPosting?1:0;
		$sql = "update `chartofaccounts` set `accountName` = '$accountName', `allowPosting`='$allowPosting',`balanceSheetAccount`='$bsAccount' where `accountNumber`= '$accountNumber'";
			if(mysqli_query($conn, $sql)){
				$response["status"] = true;
				$response["message"] ="The Account was successfully updated";
			}else{
				$response["status"] = false;
				$response["message"] ="The account could not be updated";
			}
	}
}
elseif ($type=="journal"){
	$journalNo = trim($_POST["journalNo"]);
	$date = trim($_POST["date"]);
	$date=strlen($date)>0?$date:null;
	$tJournalNo = mysqli_real_escape_string($conn,$journalNo);
	$check = "select * from journal where journalNo = '$tJournalNo'";
	$checkRes = mysqli_query($conn, $check);
	if(mysqli_num_rows($checkRes)>0){
		while($result = mysqli_fetch_assoc($checkRes)){
			if($result["posted"]){
				$response["status"] = false;
				$response["message"] = "The journal has already been posted. No changes can be made.";
			}else{
				$sql = "update journal set `transactionDate` = ? where `journalNo` = ? and posted = ?";
				$values = array($date,$journalNo,0);
				if( pdoExecute($sql, $values)){
					$response["status"] = true;
					$response["message"] = "The Journal was successfully updated";
				}else{
					$response["status"] = false;
					$response["message"] = "The journal make could not be updated. Please try again.";
				}
			}
		}
	}else{
		$sql = "insert into journal (`journalNo`,`transactionDate`,`createdOn`,`createdBy`) values (?,?,NOW(),?)";
		$values = array($journalNo,$date,"");
			if( pdoExecute($sql, $values)){
				$response["status"] = true;
				$response["message"] = "The Journal was successfully created";
			}else{
				$response["status"] = false;
				$response["message"] = "The journal make could not be added. Please try again.";
			}
	}
	
}
elseif ($type=="journalline"){
	$journalNo = trim($_POST["journalNo"]);
	$accountType = trim($_POST["accountType"]);
	$accountNo = trim($_POST["accountNo"]);
	$transactionType = trim($_POST["transactionType"]);
	$externalDoc = trim($_POST["externalDoc"]);
	$description = trim($_POST["description"]);
	$amount = trim($_POST["amount"]);
	$tJournalNo = mysqli_real_escape_string($conn, $journalNo);
	$check = "select * from journal where journalNo = '$tJournalNo'";
	$checkRes = mysqli_query($conn,$check);
	while($result = mysqli_fetch_assoc($checkRes)){
		if($result["posted"]){
			$response["status"] = false;
			$response["message"] = "The journal has already been posted. No changes can be made.";
		}else{
			$mandatoryTransactionType = array('member','vehicle','loan');
			$error = false;
			$message = "";
			if($accountType=="vehicle"){
				$accountNo = str_ireplace(" ","",$accountNo);
			}
			if(in_array($accountType,$mandatoryTransactionType)){
				if(strlen($transactionType)<1){
					$error = true;
					$message = "Please select a transaction type";
				}
			}
			if(!(is_numeric($amount)&&$amount<>0)){
				$error = true;
				$message .=strlen($message)>0?"\n":"";
				$message .= "Please enter a valid amount";
			}
			if($error){
				$response["status"] = false;
				$response["message"] = $message;
			}else{
				$sql = "insert into journallines (`jounalNo`,`accountType`,`transactionType`,`accountNo`,`externalDocNo`,`description`,`amount`) values(?,?,?,?,?,?,?)";
				$values = array($journalNo,$accountType,$transactionType,$accountNo,$externalDoc,$description,$amount);
				if( pdoExecute($sql, $values)){
					$response["status"] = true;
					$response["message"] = "The Journal line was successfully created";
				}else{
					$response["status"] = false;
					$response["message"] = "The journal line make could not be added. Please try again.";
				}
			}
		}
	}
}
else if($type=="leavetypes") {
	$description =  trim($_POST['description']);
	$gender = trim($_POST['gender']);
	$annual = $_POST['annual'];
	$includePublicHolidays = $_POST['includePublicHolidays'];
	$includeWeekends = $_POST['includeWeekends'];
	$minDays = $_POST['minDays'];
	$maxDays = $_POST['maxDays'];
	$sql = "INSERT INTO `leaveTypes`(`description`, `gender`, `annual`, `includePublicHolidays`, `includeWeekends`, `minDays`, `maxDays`) VALUES(?,?,?,?,?,?,?)";
	$values = array($description,$gender,$annual,$includePublicHolidays,$includeWeekends,$minDays,$maxDays);
	if (pdoExecute($sql,$values)) {
		$response["status"] = true;
		$response["message"] = "Leave type has been added successfully";
	}else{
		$response["status"] = false;
		$response["message"] = "Leave type could not be added";
	}
}
elseif ($type=='holiday') {
	$name =  mysqli_real_escape_string($conn,$_POST['name']);
	$annual = $_POST['annual'];
	$date = $_POST['date'];
	if (isset($_POST['id'])) {
		$id = $_POST['id'];
		$update = "UPDATE `holidays` SET `name`='$name', `annual`='$annual', `date`='$date' WHERE `id`='$id'";
		$result = mysqli_query($conn, $update);
		if ($result) {
			$response["status"] = true;
			$response["message"] = "Holiday has been updated successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "Holiday could not be updated";
		}
	}else{
		$query = "INSERT INTO `holidays` VALUES (null, '$name','$date', '$annual')";
		$result = mysqli_query($conn, $query);
		if ($result) {
			$response["status"] = true;
			$response["message"] = "Holiday has been added successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "Holiday could not be added".mysqli_error($conn);
		}
	}
}
else if ($type=="leaveapplications") {
	$id =         trim($_POST['id']);
	$employee =   trim($_POST['employee']);
	$leaveType =  trim($_POST['leaveType']);
	$startDate =  trim($_POST['startDate']);
	$noOfDays =   trim($_POST['noOfDays']);
	$returnDate = trim($_POST['returnDate']);
	$leavePhone = trim($_POST['leavePhone']);
	$reliever1 =  trim($_POST['reliever1']);
    $reliever2 =  trim($_POST['reliever1']);
	$sel = "SELECT * FROM `leaveapplications` WHERE `id`=?";
	$res = fetchWithPdo($sel,array($id));
	if (count($res) < 1) {#insert
		$query = "INSERT INTO `leaveapplications` (`id`, `employee`, `leaveType`, `startDate`, `noOfDays`, `returnDate`, `leavePhone`, `reliever1`, `reliever2`,addedBy,addedOn) VALUES (?,?,?,?,?,?,?,?,?,?,NOW())";
		$values = array($id,$employee,$leaveType,$startDate,$noOfDays,$returnDate,$leavePhone,$reliever1,$reliever2,$myUserName);
		if (pdoExecute($query,$values)) {
			$response["status"] = true;
			$response["message"] = "Application has been added successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "Application could not be added ";
		}
	}
}
else if ($type=='salaryadvances') {
    $id = $_POST['id'];
    $employee = $_POST['employee'];
    $amount = $_POST['amount'];
    $bank = $_POST['bank'];
    $extDocNo = $_POST['extDocNo'];
    $date = $_POST['date'];
    $sel = "SELECT * FROM `salaryadvance` WHERE `id`='$id' ";
    $select = mysqli_query($conn, $sel);
    if (mysqli_num_rows($select) < 1) {
		$query = "INSERT INTO `salaryadvance` (`id`, `employee`, `amount`, `bank`,`extDocNo`,`date`,createdBy,createdOn) VALUES(?,?,?,?,?,?,?,NOW())";
		$values = array($id,$employee,$amount,$bank,$extDocNo,$date,$myUserName);
		if (pdoExecute($query,$values)) {
			$response["status"] = true;
			$response["message"] = "Salary Advance has been added successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "Salary Advance could not be added";
		}
    }
}

else if($type=='staffloan'){
    $id = $_POST['id'];
    $employee = $_POST['employee'];
    $amount = $_POST['amount'];
    $monthlyRepayments = $_POST['installments'];
    
    $installments = $amount/$monthlyRepayments;//$_POST['installments'];
    $bank = $_POST['bank'];
    $extDocNo = $_POST['extDocNo'];
    $date = $_POST['date'];
	//$monthlyRepayments = $amount/$installments;
    $sel = "SELECT * FROM `staffloan` WHERE `id`='$id' ";
    $select = mysqli_query($conn, $sel);
    if (mysqli_num_rows($select) < 1) {
		$query = "INSERT INTO `staffloan` (`id`, `employee`, `amount`, `installments`,`bank`,`extDocNo`,`date`,`monthlyRepayments`,createdBy,`createdOn`) VALUES(?,?,?,?,?,?,?,?,?,NOW())";
		$values = array($id,$employee,$amount,$installments,$bank,$extDocNo,$date,$monthlyRepayments,$myUserName);
		//$result = mysqli_query($conn, $query);
    	if (pdoExecute($query,$values)) {
			$response["status"] = true;
			$response["message"] = "Staff loan has been added successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "staff loan could not be added";
		}
    }else{
        $query = "update `staffloan` set `employee`=?, `amount`=?, `installments`=?,`bank`=?,`extDocNo`=?,`date`=?,`monthlyRepayments`=? where `id` = ?";
		$values = array($employee,$amount,$installments,$bank,$extDocNo,$date,$monthlyRepayments,$id);
		//$result = mysqli_query($conn, $query);
    	if (pdoExecute($query,$values)) {
			$response["status"] = true;
			$response["message"] = "Staff loan has been updated successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "staff loan could not be updated";
		}
    }
}
elseif ($type=='payrollsetup'){
	$id = 0;
	$basicSalaryGL = $_POST['basicSalaryGL'];
	$PAYEGL = $_POST['PAYEGL'];
	$NHIFGL = $_POST['NHIFGL'];
	$NSSFGL = $_POST['NSSFGL'];
	$advanceGL = $_POST['advanceGL'];
	$LoansGL = $_POST['loansGL'];
	$minTaxableAmount = $_POST['minTaxableAmount'];
	$taxRelief = $_POST['taxRelief'];
	$employerKRAPin = $_POST['employerKRAPin'];
	$employerNHIFCode = $_POST['employerNHIFCode'];
	$employerNSSFCode = $_POST['employerNSSFCode'];
	
	if (isset($id)) {
		$id = $_POST['id'];
	}
	$sel = mysqli_query($conn, "SELECT * FROM `payrollsetups` WHERE `id`='$id'");
	if (mysqli_num_rows($sel)>0) {
	    $update = "UPDATE `payrollsetups` SET `basicSalaryCode`=?,`PAYECode`=?,`NHIFCode`=?,`NSSFCode`=?,`loansCode`=?,`advanceCode`=?,`minTaxableAmount`=?,`tax_relief`=?,`employer_kra_pin`=?,`employer_nhif_code`=?,`employer_nssf_code`=? WHERE `id` = ?";
	    $values = array($basicSalaryGL,$PAYEGL,$NHIFGL,$NSSFGL,$LoansGL,$advanceGL,$minTaxableAmount,$taxRelief,$employerKRAPin,$employerNHIFCode,$employerNSSFCode,$id);
		if (pdoExecute($update,$values)) {
			$response["status"] = true;
			$response["message"] = "Setup has been updated successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "Setup could not be updated ";
		}	
	}else{
	    $insert = "INSERT INTO `payrollsetups`(`id`, `basicSalaryCode`, `PAYECode`, `NHIFCode`, `NSSFCode`, `loansCode`, `advanceCode`, `minTaxableAmount`, `tax_relief`, `employer_kra_pin`, `employer_nhif_code`, `employer_nssf_code`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
	    $values = array($id,$basicSalaryGL,$PAYEGL,$NHIFGL,$NSSFGL,$LoansGL,$advanceGL,$minTaxableAmount,$taxRelief,$employerKRAPin,$employerNHIFCode,$employerNSSFCode);
		if (pdoExecute($insert,$values)) {
			$response["status"] = true;
			$response["message"] = "Setup has been updated created";
		}else{
			$response["status"] = false;
			$response["message"] = "Setup could not be created ";
		}	
	}

} 
else if($type=='leavebalance'){
	$employee = $_POST['employee'];
	$noOfDays = $_POST['noOfDays'];
	$sel = "SELECT * FROM `leaveBalances` WHERE `employee`='$employee'";
	$res = mysqli_query($conn, $sel);
	if (mysqli_num_rows($res)>0) {
		$row = mysqli_fetch_assoc($res);
		$bal = $row['balance'];
		$newBal = $bal+$noOfDays;
		$result = mysqli_query($conn, "UPDATE `leaveBalances` SET `balance`='$newBal' WHERE `employee`='$employee'");
		if ($result) {
			$response["status"] = true;
			$response["message"] = "Leave Balance has been updated successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "Leave balance could not be updated";
		}
	}else{
		$result = mysqli_query($conn, "INSERT INTO `leaveBalances` VALUES(NULL, '$employee', '$noOfDays')");
		if ($result) {
			$response["status"] = true;
			$response["message"] = "Leave Balance has been updated successfully";
		}else{
			$response["status"] = false;
			$response["message"] = "Leave balance could not be updated";
		}
	}

}
else if($type=='payrollemployees'){
	$employeeNumber = mysqli_real_escape_string($conn, trim($_POST["employeeNumber"]));	
	$bank = "";
	$bankBranch = "";
	$bankAccount = "";
	$basicSalary = 0;
	$paysPAYE = 0;
	$paysNHIF = 0;
	$paysNSSF = 0;
	$suspendPay = 0;	
	if(isset($_POST["bank"])){
		$bank = mysqli_real_escape_string($conn, trim($_POST["bank"]));
	}if(isset($_POST["bankBranch"])){
		$bankBranch = mysqli_real_escape_string($conn, trim($_POST["bankBranch"]));
	}if(isset($_POST["bankAccount"])){
		$bankAccount = mysqli_real_escape_string($conn, trim($_POST["bankAccount"]));
	}if(isset($_POST["basicSalary"])){
		$basicSalary = mysqli_real_escape_string($conn, trim($_POST["basicSalary"]));
	}if(isset($_POST["paysPAYE"])){
		$paysPAYE = mysqli_real_escape_string($conn, trim($_POST["paysPAYE"]));
	}if(isset($_POST["paysNHIF"])){
		$paysNHIF = mysqli_real_escape_string($conn, trim($_POST["paysNHIF"]));
	}if(isset($_POST["paysNSSF"])){
		$paysNSSF = mysqli_real_escape_string($conn, trim($_POST["paysNSSF"]));
	}if(isset($_POST["suspendPay"])){
		$suspendPay = mysqli_real_escape_string($conn, trim($_POST["suspendPay"]));
	}
	
	$error = false;
	$message = "";
	/*if($fName==""){
		$message.= $message==""?"":"\n";
		$error = true;
		$message .= "Please specify the employees first name";
	}if($lName==""){
		$error = true;
		$message.= $message==""?"":"\n";
		$message .= "Please specify the employees last name";
	}if($idNumber==""){
		$error = true;
		$message.= $message==""?"":"\n";
		$message .= "Please specify the employees Id Number";
	}if($phoneNumber==""){
		$error = true;
		$message.= $message==""?"":"\n";
		$message .= "Please specify the employees phone Number";
	}*/
	if($error){
		$response["status"] = false;
		$response["message"] =$message;
	}else{
		
		$sql = "update `employee` set `Bank`= '$bank',`BankBranch`= '$bankBranch',`AccountNumber`= '$bankAccount',`BasicSalary`= '$basicSalary',`PaysPaye`= '$paysPAYE',`paysNHIF`= '$paysNHIF',`paysNSSF`= '$paysNSSF',`suspendPay`= '$suspendPay'		where EmployeeNumber = '$employeeNumber'";
		if(mysqli_query($conn, $sql)){
			$response["status"] = true;
			$response["message"] ="The employee was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] ="The employee could not be updated";
		}
	}
}
else if($type=="adjustleavedays"){
	$employeeNo = trim($_POST["employeeNo"]);
	$description = trim($_POST["description"]);
	$days = trim($_POST["days"]);
	$sql = "insert into leaveledgerentries (`Employee`,`description`,`NumberOfDays`,`AddedOn`,`AddedBy`) values (?,?,?,NOW(),?)";
	$values = array($employeeNo,$description,$days, "");
	if(pdoExecute($sql,$values)){
		$response["status"] = true;
		$response["message"] = "The employee's leave balances were successfully updated";
	}else{
		$response["status"] = false;
		$response["message"] = "The leave balances could not be updated";
	}
}
else if($type=="bank"){
	if(isset($_POST["bankName"])&&isset($_POST["glAccount"])){
		$bankName = mysqli_real_escape_string($conn, trim($_POST["bankName"]));
		$bankBranch = mysqli_real_escape_string($conn, trim($_POST["bankBranch"]));
		$accountNumber = mysqli_real_escape_string($conn, trim($_POST["accountNumber"]));
		$glAccount = mysqli_real_escape_string($conn, trim($_POST["glAccount"]));
		$description = mysqli_real_escape_string($conn, trim($_POST["description"]));

		$sql ="INSERT INTO `banks`(`BankName`, `BankBranch`, `accountNumber`, `gl_account`, `Balance`, `Enabled`, `AddedBy`, `AddedOn`,`description`) VALUES 
		(?,?,?,?,?,?,?,NOW(),?)";
		$values = array($bankName,$bankBranch,$accountNumber,$glAccount,0,1,'1',$description);
		if(pdoExecute($sql, $values)){
			$response["status"] = true;
			$response["message"] = "The bank account was successfully added";
		}else{
			$response["status"] = false;
			$response["message"] = "The bank account could not be added";
		}
	}
}
else if($type=="chargeitem"){
	 if(isset($_POST["code"])&&is_numeric($_POST["code"])){
			$sql= "UPDATE `chargeitems` SET `category`=?,`description`=?,`account_no`=?,`taxable`=?,`tax_rate`=?, `default_amount` = ? ,`require_vsm`=?, `require_fixed_asset`=?,`require_region`=? WHERE id = ?";
			$values = array(
			$_POST["category"]
			,$_POST["description"]
			,$_POST["accountNo"]
			,$_POST["taxable"]
			,$_POST["taxRate"]
			,isset($_POST["amount"])?$_POST["amount"]:0
			,$_POST["requireVSM"]
	    	,$_POST["requireFixedAsset"]
	    	,$_POST["requireRegion"]
			,$_POST["code"]);
			if(pdoExecute($sql, $values)){
				$response["status"] = true;
				$response["message"] = "The charge item was successfully updated";
			}else{
				$response["status"] = false;
				$response["message"] = "The charge item could not be updated";
			}
			 
		}else {
		    
           	$sql= "INSERT INTO `chargeitems`(`category`, `description`, `account_no`, `taxable`, `tax_rate`, `default_amount`,`require_vsm`, `require_fixed_asset`,`require_region`,`added_by`, `added_on`) VALUES (?,?,?,?,?,?,?,?,?,?,NOW())";
			$values = array(
			$_POST["category"]
			,$_POST["description"]
			,$_POST["accountNo"]
			,$_POST["taxable"]
			,$_POST["taxRate"]
	    	,isset($_POST["amount"])?$_POST["amount"]:0
	    	,$_POST["requireVSM"]
	    	,$_POST["requireFixedAsset"]
	    	,$_POST["requireRegion"]
			,$myUserName
			);
			if(pdoExecute($sql, $values)){
				$response["status"] = true;
				$response["message"] = "The charge item was successfully added";
			}else{
				$response["status"] = false;
				$response["message"] = "The charge item could not be added";
			}
			
		   }
			
}
else if($type=="chargeitem1"){
	 if(isset($_POST["code"])&&is_numeric($_POST["code"])){
			$sql= "UPDATE `chargeitems` SET `category`=?,`description`=?,`account_no`=?,`taxable`=?,`tax_rate`=?, `default_amount` = ? WHERE id = ?";
			$values = array();
			$values[0] = $_POST["category"];
			$values[1] = $_POST["description"];
			$values[2] = $_POST["accountNo"];
			$values[3] = $_POST["taxable"];
			$values[4] = $_POST["taxRate"];
			$values[5] = isset($_POST["amount"])?$_POST["amount"]:0;
			//$values[5] = $_POST["amount"];
			$values[6] = $_POST["code"];
			if(pdoExecute($sql, $values)){
				$response["status"] = true;
				$response["message"] = "The charge item was successfully updated";
			}else{
				$response["status"] = false;
				$response["message"] = "The charge item could not be updated";
			}
			 
		}else {
           	$sql= "INSERT INTO `chargeitems`(`category`, `description`, `account_no`, `taxable`, `tax_rate`, `default_amount`,`added_by`, `added_on`) VALUES (?,?,?,?,?,?,?,NOW())";
			$values = array();
			$values[0] = $_POST["category"];
			$values[1] = $_POST["description"];
			$values[2] = $_POST["accountNo"];
			$values[3] = $_POST["taxable"];
			$values[4] = $_POST["taxRate"];
	    	$values[5] = isset($_POST["amount"])?$_POST["amount"]:0;
			$values[6] = $myUserName;
			if(pdoExecute($sql, $values)){
				$response["status"] = true;
				$response["message"] = "The charge item was successfully added";
			}else{
				$response["status"] = false;
				$response["message"] = "The charge item could not be added";
			}
			
		   }
			
}
else if($type=="customer"){
	if(isset($_POST["idNo"])&&isset($_POST["phoneNo"])&&isset($_POST["customerNo"])){
	    $custNo = trim($_POST["customerNo"]);
	    $customerName = trim($_POST["customerName"]); 
	    $idNo =  trim($_POST["idNo"]);
	    $phoneNo =  trim($_POST["phoneNo"]);
		$kraPin=isset($_POST["kraPin"]) ? trim($_POST["kraPin"]) : "";
	    $pricingGroup = isset($_POST["pricingGroup"]) ? trim($_POST["pricingGroup"]) : 1;  
	    $creditLimit = isset($_POST["creditLimit"]) ? trim($_POST["creditLimit"]) : 0; 
	    $creditPeriod = isset($_POST["creditPeriod"]) ? trim($_POST["creditPeriod"]) : 0; 
		$customerEmail = isset($_POST["email"]) ? trim($_POST["email"]) : "";
		$location = isset($_POST["location"])?trim($_POST["location"]):"";
		$locationLatitude = isset($_POST["locationLatitude"])?trim($_POST["locationLatitude"]):0;
		$locationLongitude = isset($_POST["locationLongitude"])?trim($_POST["locationLongitude"]):0;
		$contactPerson = isset($_POST["contactPerson"])?trim($_POST["contactPerson"]):"";
		$contactPosition = isset($_POST["contactPosition"])?trim($_POST["contactPosition"]):"";
		$contactPhone = isset($_POST["contactPhone"])?trim($_POST["contactPhone"]):"";
		$contactEmail = isset($_POST["contactEmail"])?trim($_POST["contactEmail"]):"";
		$photo = isset($_POST["photo"])?trim($_POST["photo"]):"";
		$remarks = isset($_POST["remarks"])?trim($_POST["remarks"]):"";
		$salesAgent = isset($_POST["salesAgent"])?trim($_POST["salesAgent"]):"";
		$region = isset($_POST["region"])?trim($_POST["region"]):0;
		$postingGroup = isset($_POST["postingGroup"])?trim($_POST["postingGroup"]):15;
		$dob = isset($_POST["dateOfBirth"])?trim($_POST["dateOfBirth"]):null;
		$dmsNO = isset($_POST["dmsNO"])?trim($_POST["dmsNO"]):"";
		if(strlen($dob)<1){
			$dob = null;
		}
	    $newNumber = false;
	    if(strlen($custNo)==0){
	        $custNo = getNextNumber(6);//updateLastNumber(6, $custNo);
	        $newNumber = true;
	    }
		$checkExists = "SELECT * FROM customers WHERE region ='$region' and (customerNumber = '$custNo' ";
		if(strlen($idNo)>0){
		    $checkExists.=" OR   idNo = '$idNo' ";
		}
		if(strlen($phoneNo)>0){
		    $checkExists.=" OR phoneNumber = '$phoneNo'";
		}
		$checkExists.=")";
		$checkRes = fetchWithPdo($checkExists,array());
		if(count($checkRes)>0){
			$response["status"] = false;
			$response["message"] = "Duplicate Details\nCustomer Name: ".$checkRes[0]["customerName"]." ID No: ".$checkRes[0]["idNo"]." Phone Number: ".$checkRes[0]["phoneNumber"];
			$response["result"] = false;
		}else if($region<1){
		    $response["status"] = false;
			$response["message"] = "Please select the region";
			$response["result"] = false;
		}
		else{	
			 
			$sql = "INSERT INTO `customers` (`customerNumber`, `customerName`, `idNo`, `kraPin`, `dateofbirth`, `phoneNumber`,`pricing_group`,`creditLimit`, `creditPeriod`,  `email`, `location`, `location_latitude`, `location_longitude`, 
		    `contactName`, `jobPosition`, `contactPhone`, `contactEmail`,  `customerpostinggroup`, `customerImage`, `salesAgent`, `region`, `addedBy`, `addedOn`,`remarks`,`dms_no`) 
			VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),?,?)"; 

			$values = array();
			array_push($values, $custNo);
			array_push($values, $customerName);
			array_push($values, $idNo);
			array_push($values, $kraPin);
			array_push($values, $dob);
			array_push($values, $phoneNo);
			array_push($values, $pricingGroup);
			array_push($values, $creditLimit); 
			array_push($values, $creditPeriod);
			array_push($values, $customerEmail);
			array_push($values, $location);
			array_push($values, $locationLatitude);
			array_push($values, $locationLongitude);
			array_push($values, $contactPerson);
			array_push($values, $contactPosition);
			array_push($values, $contactPhone);
			array_push($values, $contactEmail);
			array_push($values, $postingGroup);
			array_push($values, $photo);
			array_push($values, $salesAgent);
			array_push($values, $region);
			array_push($values, $myUserName);
			array_push($values, $remarks);
			array_push($values, $dmsNO);
			if(pdoExecute($sql,$values)){
			    if($newNumber){
			        updateLastNumber(6, $custNo);
			    }
				include("etims.php");
				$branchId = getEtimsDetails()["branch_id"];
				$addCustomer = saveBranchCustomer($branchId,$custNo,$kraPin,$customerName);
				$response["status"] = true;
				$response["message"] = "The customer was successfully added\n".json_encode($addCustomer);
			}else{
				$response["status"] = false;
				$response["message"] = "The customer could not be added. Please try again";
			}
		}
	} else {
		$response["status"] = false;
		$response["message"] = "Please fill all mandatory fields";
	}

}
else if($type=="customerinvoiceline"){
	if(isset($_POST["invoiceNo"])){
		 	$taxRate = 0;
		 	//uomRelationshipCode
			if($_POST["itemType"]=="Charge Items"){
				$getTaxRate = "SELECT tax_rate FROM `chargeitems` where id = ?";
				$values = array();
				$values[0] = $_POST["itemNo"];
				$stmt2 = fetchByPDO($getTaxRate, $values);
				while ($row = $stmt2->fetch()) {
					$taxRate = $row['tax_rate'];
				}
			}else if($_POST["itemType"]=="Items"){
				$getTaxRate = "SELECT percentage FROM `taxGroups` WHERE code = (SELECT taxGroup FROM `items` WHERE code = ?)";
				$values = array();
				$values[0] = $_POST["itemNo"];
				$stmt2 = fetchByPDO($getTaxRate, $values); 
				while ($row = $stmt2->fetch()) {
					$taxRate = $row['percentage'];
				}
			}
			//document_type details
			//document_type details
			$document_type = isset($_POST["document_type"])?trim($_POST["document_type"]):"sales_invoice";
			$details = isset($_POST["details"])?trim($_POST["details"]):"";
			
			$sql= "INSERT INTO `sales_lines`(`header_no`, `document_type`,`itemType`, `itemNo`, `description`,`unitOfMeasureCode`, `unitPrice`, `quantity`, `totalExclVAT`, `totalVAT`, `totalAmount`,`details`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
			$values = array();
			
			$totalAmount = $_POST["quantity"]*$_POST["unitPrice"];
			$taxableAmount= $totalAmount/(($taxRate/100)+1);
			$totalTax = ($taxableAmount*$taxRate)/100;
			
			array_push($values,$_POST["invoiceNo"]);
			array_push($values,$document_type);
			array_push($values,$_POST["itemType"]);
			array_push($values,$_POST["itemNo"]);
			array_push($values,$_POST["description"]);
			array_push($values,trim($_POST["uomRelationshipCode"]));
			array_push($values,$_POST["unitPrice"]);
			array_push($values,$_POST["quantity"]);
			array_push($values,$totalAmount-$totalTax);
			array_push($values,$totalTax);
			array_push($values,$totalAmount);
			array_push($values,$details);
			if(pdoExecute($sql, $values)){
				$response["status"] = true;
				$response["message"] = "The invoice line was successfully added ";
			}else{
				$response["status"] = false;
				$response["message"] = "The invoice line could not be added ";
			}
			 
        }



}
else if($type=="receiptline"){
	$receiptNo = mysqli_real_escape_string($conn, trim($_POST["receiptNo"]));
$transactionType = mysqli_real_escape_string($conn, trim($_POST["transactionType"]));
$loanNo = mysqli_real_escape_string($conn, trim($_POST["loanNo"]));
$amount = mysqli_real_escape_string($conn, trim($_POST["amount"]));
$vehicle = mysqli_real_escape_string($conn, trim($_POST["vehicle"]));
$vehicle = str_ireplace(" ", "",$vehicle);
if(is_numeric($amount)){
	//check that receipt has not been posted and that it exists
	$checkExist= "select * from receiptheader where ReceiptNo = '$receiptNo' and Posted = 0";
	$checkRes = mysqli_query($conn,$checkExist);
	if(mysqli_num_rows($checkRes)>0){
		$insert = "INSERT INTO `receiptline`(`ReceiptNo`, `TransactionType`, `LoanNo`, `Amount`, `vehicle`, `addedOn`, `addedBy`) VALUES (?,?,?,?,?, NOW(), ?)";
		$values = array($receiptNo,$transactionType,$loanNo,$amount,$vehicle, "1");
		if(pdoExecute($insert,$values)){
			$response["status"] = true;
			$response["message"] ="The receipt line was successfully added";
		}else{
			$response["status"] = false;
			$response["message"] ="The receipt line could not be added";
		}
	}else{
		$response["status"] = false;
	$response["message"] ="The provided receipt does not exist or has already been posted";
	}
}else{
	$response["status"] = false;
	$response["message"] ="Please enter a valid amount";
}
}
else if($type=="receipt"){
	$memberNo = mysqli_real_escape_string($conn, trim($_POST["memberNo"]));
	$bankCode = mysqli_real_escape_string($conn, trim($_POST["bankCode"]));
	$payMethod = mysqli_real_escape_string($conn, trim($_POST["payMethod"]));
	$externalRef = mysqli_real_escape_string($conn, trim($_POST["externalRef"]));
	$paymentDate = mysqli_real_escape_string($conn, trim($_POST["paymentDate"]));
	$receivedFrom = mysqli_real_escape_string($conn, trim($_POST["receivedFrom"]));
	$receiptNumber = mysqli_real_escape_string($conn, trim($_POST["receiptNumber"]));
	$checkExist= "select * from receiptheader where ReceiptNo = '$receiptNumber'";
	$checkRes = mysqli_query($conn,$checkExist);
	if(mysqli_num_rows($checkRes)>0){//update
		$update = "UPDATE `receiptheader` SET `Member`=?,`Bank`=?,`PaymentMethod`=?,`ExternalRefNo`=?,`PaymentDate`=?,`ReceivedFrom`=? WHERE ReceiptNo = ? and Posted = ?";
		$values = array($memberNo,$bankCode,$payMethod,$externalRef,$paymentDate,$receivedFrom,$receiptNumber,0);
		if(pdoExecute($update,$values)){
			$response["status"] = true;
			$response["message"] ="The receipt was successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] ="The receipt could not be updated";
		}
	}else{//insert
		$insert = "INSERT INTO `receiptheader`(`ReceiptNo`, `Member`, `Bank`, `PaymentMethod`, `ExternalRefNo`, `PaymentDate`, `ReceivedFrom`, `CreatedBy`, `Posted`, `CreatedOn`) VALUES (?,?,?,?,?,?,?,?,?,NOW())";
		$values = array($receiptNumber,$memberNo,$bankCode,$payMethod,$externalRef,$paymentDate,$receivedFrom,"1",0);
		if(pdoExecute($insert,$values)){
			$response["status"] = true;
			$response["message"] ="The receipt was successfully saved";
		}else{
			$response["status"] = false;
			$response["message"] ="The receipt could not be added ";
		}
	}
}
else if($type=="departments"){
	$departmentName  = trim($_POST["departmentName"]);
	if($departmentName==""){
		$response["status"] = false;
		$response["message"] ="Please indicate the department name";
	}else{
		$sql = "SELECT * FROM `departments` WHERE `department_name` = ?";
		$res = fetchWithPdo($sql,array($departmentName));
		if(count($res)>0){
			$response["status"] = false;
			$response["message"] ="There is another department with the same name. Please enter a different name. ";
		}else{
			$insertDepartment = "INSERT INTO `departments`(`department_name`,  `created_by`, `created_on`) VALUES (?, ?, NOW())";
			if(pdoExecute($insertDepartment,array($departmentName,$myUserName))){
				$response["status"] = true;
				$response["message"] ="The department was successfully added";
			}else{
				$response["status"] = false;
				$response["message"] ="The department could not be added";
			}
		}
	}
}
else if($type=="employees"){
    $employeeNumber =  trim($_POST["employeeNumber"]);	
    $fName =  trim($_POST["fName"]);	
    $lName =  trim($_POST["lName"]);	
    $mName =  trim($_POST["mName"]);	
    $idNumber =  trim($_POST["idNumber"]);	
    $phoneNumber =  trim($_POST["phoneNumber"]);	
    $payrollNumber =  trim($_POST["payrollNumber"]);	
    $email =  trim($_POST["email"]);	
    $dob =  trim($_POST["dob"]);	
    $disabled =  trim($_POST["disabled"]);	
    $disabilityDescription =  trim($_POST["disabilityDescription"]);	
    $kra =  trim($_POST["kra"]);	
    $nssf =  trim($_POST["nssf"]);	
    $nhif =  trim($_POST["nhif"]);	
    $department =  trim($_POST["department"]);	
    $employmentTerms =  trim($_POST["employmentTerms"]);
    $jobTitle =  trim($_POST["jobTitle"]);	
    $hod =  trim($_POST["hod"]);	
    $photo = $_POST["photo"]!=""?trim($_POST["photo"]):NULL;
    $gender =  trim($_POST["gender"]);	
    $goodConduct =  trim($_POST["goodConduct"]);	
	$error = false;
	$message = "";
	if($fName==""){
		$message.= $message==""?"":"\n";
		$error = true;
		$message .= "Please specify the employees first name";
	}if($lName==""){
		$error = true;
		$message.= $message==""?"":"\n";
		$message .= "Please specify the employees last name";
	}if($idNumber==""){
		$error = true;
		$message.= $message==""?"":"\n";
		$message .= "Please specify the employees Id Number";
	}if($phoneNumber==""){
		$error = true;
		$message.= $message==""?"":"\n";
		$message .= "Please specify the employees phone Number";
	}
	if($error){
		$response["status"] = false;
		$response["message"] =$message;
	}else{
		$sql = "INSERT INTO `employee`(`EmployeeNumber`, `first_name`, `middle_name`, `last_name`, `IdNumber`, `payroll_number`, `date_of_birth`, `Pin`, `PhoneNumber`, `Email`, `disabled`, `disability_description`,`employment_terms`, `department`, `job_title`, `hod`, `NHIFNo`, `NSSFNo`, `Photo`, `AddedOn`, `AddedBy`,gender,good_conduct) VALUES 	(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),?,?,?)";
		$values = array($employeeNumber,$fName,$mName,$lName,$idNumber,$payrollNumber,$dob,$kra,$phoneNumber,$email,$disabled,$disabilityDescription,$employmentTerms,$department,$jobTitle,$hod,$nhif,$nssf,$photo,$myUserName,$gender,$goodConduct);
		if(pdoExecute($sql,$values)){
			if($hod){
			$update = "update employee set hod = 0 where department = $department and hod =1 and not EmployeeNumber = '$employeeNumber'";
			$update2 = "update departments set hod = '$employeeNumber' where code = $department";
			mysqli_query($conn, $update);
			mysqli_query($conn, $update2);
			}
			$response["status"] = true;
			$response["message"] ="The employee was successfully added";
		}else{
			$response["status"] = false;
			$response["message"] ="The employee could not be added";
		}
	}
}
else if($type=="postinggroups"){
   // echo "Am here";
    $code = trim($_POST["code"]);
    $category = trim($_POST["category"]);
    $name = trim($_POST["name"]);
    $glAccount = trim($_POST["glAccount"]);
    $cogAccount = trim($_POST["cogAccount"]);
    $revenueAccount = trim($_POST["revenueAccount"]);
    
    if(strlen($name)>0&&strlen($glAccount)>0){
        if($code==0){
            $sql= "INSERT INTO `postinggroups`(`category`, `name`, `glaccount`,`cogs_account`,`revenue_account`,`added_on`, `added_by`) VALUES (?,?,?,?,?,NOW(),?)";
            $values=array($category,$name,$glAccount,$cogAccount,$revenueAccount,$myUserName);
            if(pdoExecute($sql,$values)){
                $response["status"] = true;
				$response["message"] = "The posting group was successfully added";
			}else{
			    $response["status"] = false;
				$response["message"] = "The posting group could not be added. Please try again";
			}
        }
    }
    
}
else if($type=="postinggroup"){
	if(isset($_POST["name"]) &&isset($_POST["glAccount"]) ){
			if(isset($_POST["code"])&&is_numeric($_POST["code"])){
				//update posting group
				$sql = "UPDATE `postinggroups` SET `category`=?,`name`=?,`glaccount`=?,updated_on=NOW() WHERE id = ?";
				$values = array();
				$values[0] = trim($_POST["category"]);
				$values[1] = trim($_POST["name"]);
				$values[2] = trim($_POST["glAccount"]);
				$values[3] = trim($_POST["code"]);
				if(pdoExecute($sql,$values)){
					$response["status"] = true;
					$response["message"] = "The posting group was successfully updated";
				}else{
					$response["status"] = false;
					$response["message"] = "The posting group could not be updated";
				}
				
			}else{
			$sql= "INSERT INTO `postinggroups`(`category`, `name`, `glaccount`, `added_on`, `added_by`) VALUES (?,?,?,NOW(),?)";
			$values = array();
			$values[0] = trim($_POST["category"]);
			$values[1] = trim($_POST["name"]);
			$values[2] = trim($_POST["glAccount"]);
			$values[3] = "1";
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The posting group was successfully added";
			}else{
				$response["status"] = false;
				$response["message"] = "The posting group could not be added";
			}
			 

}

}
}
else if($type=="member"){
	$memberNumber = $_POST["memberNumber"];
	$fName = $_POST["fName"];
	$mName = $_POST["mName"];
	$lName = $_POST["lName"];
	$idNo = $_POST["idNo"];
	$phoneNo = $_POST["phoneNo"];
	$email = $_POST["email"];
	$pin = $_POST["pin"];
	$photo = $_POST["photo"];
	$sql = "insert into members(MemberNo,FirstName,MiddleName,LastName,IdNo,PhoneNumber,Email,PIN,Photo,AddedOn ) values (?, ?, ?, ?, ?, ?, ?, ?,?, NOW())";
	$values = array($memberNumber, $fName,$mName, $lName,$idNo, $phoneNo, $email, $pin,$photo);
	if(pdoExecute($sql,$values)){
		$response["status"] = true;
		$response["message"] = "Member was successfully added";
	}else{
		$response["status"] = false;
		$response["message"] = "Member could not be added";
	}
}
else if($type=="vehicle"){
	$fleetNumber = mysqli_real_escape_string($conn, trim($_POST["fleetNumber"]));
	$tregNo = mysqli_real_escape_string($conn, trim($_POST["regNo"]));
	$makeCode = mysqli_real_escape_string($conn, trim($_POST["makeCode"]));
	$modelCode = mysqli_real_escape_string($conn, trim($_POST["modelCode"]));
	$vAlias = mysqli_real_escape_string($conn, trim($_POST["vAlias"]));
	$ownerCode = mysqli_real_escape_string($conn, trim($_POST["ownerCode"]));
	$brandCode = mysqli_real_escape_string($conn, trim($_POST["brandCode"]));
	$active = mysqli_real_escape_string($conn, trim($_POST["active"]));
	$photo = $_POST["photo"];
	//check no other vehicle with same regNo
	$sql = "select * from vehicles where RegNo = '$tregNo'";
	$res = mysqli_query($conn, $sql);
	if(mysqli_num_rows($res)>0){
		$response["status"] = false;
		$response["message"] = "Another vehicle with the same registration number exists";
	}else{
	$sql= "INSERT INTO `vehicles`(`RegNo`, `FleetNumber`, `Make`, `Model`, `Name(alias)`, `Photo`, `Owner`, `AddedOn`, `AddedBy`, `brand`, `active`) 
	VALUES (?,?,?,?,?,?,?,NOW(),?,?, ?)";
	$values =array($tregNo,$fleetNumber,$makeCode,$modelCode,$vAlias,$photo,$ownerCode,1,$brandCode, $active);
	if(pdoExecute($sql,$values)){
		$response["status"] = true;
		$response["message"] = "Vehicle was successfully added";
	}else{
		$response["status"] = false;
		$response["message"] = "Vehicle could not be added";
	}
	}
}
else if($type=="purchaseheader"){
	$documentType = trim($_POST["documentType"]);
	$documentNo = trim($_POST["documentNo"]);
	$vendor = trim($_POST["vendor"]);
	$purchaseDate = trim($_POST["purchaseDate"]);
	$shopLocationCode = trim($_POST["shopLocationCode"]);
	$projectCode = trim($_POST["projectCode"]);  
	$lpoNo = trim($_POST["lpoNo"]);  
	$externalDocNo = trim($_POST["externalDocNo"]);   
	$comment = trim($_POST["comment"]); 
	$entryNo = trim($_POST["entryNo"]); 
	$entryType = trim($_POST["entryType"]);   
	
	

	$newNumber = false; 
	$series=0;
	$documentName= "";
	$getSeries = fetchWithPdo("SELECT * FROM `document_types` WHERE code = ?",array($documentType));
	$series = $getSeries[0]["number_series"];
	$documentName = $getSeries[0]["document_type"];
	if(strlen($documentNo)==0){
		$newNumber = true; 
		$documentNo =getNextNumber($series);
	}
	$check = "select * from vendorinvoices where invoiceNo = ?";
	$values = array($documentNo);
	$exists = false;
	$stmt3 = fetchWithPdo($check,$values);
	if(count($stmt3)>0){
		$exists = true;
	}		
	if($exists){
		if($stmt3[0]["posted"]){
			$response["status"] = false;
			$response["message"] = "The $documentName has already been posted. No changes can be done";
		}else{
			$sql= "update vendorinvoices set vendor=?, invoiceDate=?,shopLocationCode=?,`external_doc_no`=?, `lpo_no`=?,`entry_type`=?,`entry_no`=?,`comment`=? where invoiceNo =? and document_type=?";
			$values = array($vendor,$purchaseDate,$shopLocationCode,$externalDocNo,$lpoNo,$entryType,$entryNo,$comment, $documentNo,$documentType);
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["overLoad1"] = $documentNo;
				$response["message"] = "The $documentName was successfully updated";
				if($newNumber){
					updateLastNumber($series, $documentNo);//$documentNo =getNextNumber($series);
				}
			}else{
				$response["status"] = false;
				$response["message"] = "The $documentName could not be updated";
			}
		}
	}else{			
		$sql= "INSERT INTO `vendorinvoices`(`invoiceNo`,`document_type`, `vendor`, `shopLocationCode`,`external_doc_no`, `lpo_no`,`entry_type`,`entry_no`,`comment`, `createdBy`, `posted`, `invoiceDate`,`createdOn`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,NOW())";
		$values = array($documentNo,$documentType,$vendor,$shopLocationCode,$externalDocNo,$lpoNo,$entryType,$entryNo,$comment,$myUserName,0,$purchaseDate);
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["overLoad1"] = $documentNo;
			$response["message"] = "The $documentName was successfully inserted";
			if($newNumber){
				updateLastNumber($series, $documentNo);
			}
		}else{
			$response["status"] = false;
			$response["message"] = "The $documentName could not be inserted";
		}
	}		
			
	
}
else if($type=="servicevoucher"){
	if(isset($_POST["month"])&&isset($_POST["year"])){ 
	$month = mysqli_real_escape_string($conn, trim($_POST["month"]));
	$year = mysqli_real_escape_string($conn, trim($_POST["year"]));
	if(isset($_POST["voucherCode"])){//update
			$voucherCode = mysqli_real_escape_string($conn, trim($_POST["voucherCode"]));
			$updateSql = "update service_fee_vouchers set month= '$month',year = '$year' where id ='$voucherCode' and  posted = 0";
			if(mysqli_query($conn, $updateSql)){
				$response["status"] = true;
				$response["message"] ="The voucher was successfully updated ";
			}else{
				$response["status"] = false;
				$response["message"] ="The voucher could not be updated ";
			}
			}else{
	$check = "select * from service_fee_vouchers where month ='$month' and year = '$year'";
	$checkRes = mysqli_query($conn, $check);
	if(mysqli_num_rows($checkRes)>0){
		$response["status"] = false;
		$response["message"] ="Another service fee voucher for the same period has already been created";
	}else{
		
	$sql = "INSERT INTO `service_fee_vouchers`(`month`, `year`, `createdOn`, `createdBy`, `posted`) VALUES ('$month','$year',NOW(), '1', false)";
	if(mysqli_query($conn, $sql)){
		$voucherId = mysqli_insert_id($conn);
		$response["status"] = true;
		$response["message"] ="The voucher was successfully added % $voucherId";
	
		$sql = "SELECT A.*, B.* FROM `vehicles` A left join vehiclebrands B on A.brand= B.brandId WHERE A.exited  =0 and A.active = 1";
		$res = mysqli_query($conn, $sql);
		$lines = "";
		while($result = mysqli_fetch_assoc($res)){
			//insert lines
			$vehicle = $result["RegNo"];
			$monthlyServiceFee = $result["monthlyServiceFee"];
			$lines.=strlen($lines)>0?",":"";
			 $lines.= "('$voucherId', '$vehicle',0, $monthlyServiceFee)";
			
		}
		$insertLine = "INSERT INTO `service_fee_lines`( `voucherNo`, `vehicle`, `daysInactive`, `feeCharged`)  VALUES $lines";
		mysqli_query($conn, $insertLine);
		
		//get vehicles gthat have exited within the month
		
		//$month $year
			$lastDay = "30";
			$oddMonths = array(1,3,5,7,8,10,12);
			if(in_array($month,$oddMonths)){
				$lastDay = "31";
			}
			else if($month ==2){
				$lastDay = "28";
				if(($year%4)==0){
					$lastDay = "29";
				}
			}
			$lastDate = $year."-".$month."-".$lastDay." 00:00:00";
			$getExited = "select * from vehicleexit where exitDate >= '".$year."-".$month."-1' and exitDate <= '".$year."-".$month."-".$lastDay."'";
			$exitRes = mysqli_query($conn, $getExited);
			while($exitResult = mysqli_fetch_assoc($exitRes)){
				$regNo = $exitResult["vehicle"];
				$exitDate = $exitResult["exitDate"];
				//$daysExempted = 
				$sql = "SELECT A.*, B.* FROM `vehicles` A left join vehiclebrands B on A.brand= B.brandId WHERE A.RegNo  ='$regNo'";
				$res = mysqli_query($conn, $sql);
				$lines = "";
				while($result = mysqli_fetch_assoc($res)){
					//insert lines
					$vehicle = $result["RegNo"];
					$brandMonthly = $brandResult["monthlyServiceFee"];
					$brandDaily = $brandResult["dailyServiceFee"];
					$feeCharged =$brandMonthly - ($daysInActive*$brandDaily);
					$insertLine = "INSERT INTO `service_fee_lines`( `voucherNo`, `vehicle`, `daysInactive`, `feeCharged`)  VALUES ('$voucherId', '$vehicle',DATEDIFF('$lastDate','$exitDate' ), $feeCharged)";
					mysqli_query($conn, $insertLine);
				}
				
			}
		
	}else{
		$response["status"] = false;
		$response["message"] ="The voucher could not be added";
	
	}
}
}
}

}
else if($type=="salesheader"){
    if(isset($_POST["document_type"])){
        $docType = trim($_POST["document_type"]);
		$docDate = isset($_POST["date"])?trim($_POST["date"]):"0000:00:00";
		//max one request per day for end of day

        $checkDocType = fetchWithPdo("SELECT * FROM `document_types` WHERE code = ?",array($docType));
        if(count($checkDocType)>0){
            $docNo = "";
            $newDocument = false;
            $series = "";
            if(!(isset($_POST["docNo"])&&strlen($_POST["docNo"])>0)){
                $newDocument = true;
                $series = $checkDocType[0]["number_series"];
                $docNo = getNextNumber($series);
            }else{
               $docNo =  trim($_POST["docNo"]);
            }
            
            $customer = isset($_POST["customer"])?trim($_POST["customer"]):"";
            $salesRep = isset($_POST["salesRep"])?trim($_POST["salesRep"]):"";
            $sourceLocation = isset($_POST["sourceLocation"])?trim($_POST["sourceLocation"]):"0";
            $destinationLocation = isset($_POST["destinationLocation"])?trim($_POST["destinationLocation"]):"0";
            $region = isset($_POST["region"])?trim($_POST["region"]):"0";
            $staff = isset($_POST["staff"])?trim($_POST["staff"]):"";
            $purpose = isset($_POST["purpose"])?trim($_POST["purpose"]):"";
            $startDate = isset($_POST["startDate"])?trim($_POST["startDate"]):"0000:00:00";
            $endDate = isset($_POST["endDate"])?trim($_POST["endDate"]):"0000:00:00";
            $activity = isset($_POST["activity"])?trim($_POST["activity"]):"";
            $target = isset($_POST["target"])?trim($_POST["target"]):"";
            $comment = isset($_POST["comment"])?trim($_POST["comment"]):"";
            $reference = isset($_POST["reference"])?trim($_POST["reference"]):"";
            $invoice = isset($_POST["invoice"])?trim($_POST["invoice"]):"";
            $customerName = isset($_POST["customerName"])?trim($_POST["customerName"]):"";
            $customerPin = isset($_POST["customerPin"])?trim($_POST["customerPin"]):"";
 
  
            $checkExists = fetchWithPdo("select * from sales_header where doc_no=?",array($docNo)); 
            if(count($checkExists)>0){
                if($checkExists[0]["posted"]){
                    $response["status"] = false;
	                $response["message"] ="The ".$checkDocType[0]["document_type"]." has already been posted. No changes can be made";
                }else{
					
                    $sql = "update `sales_header` set  `customer`=?, `sales_date`=?, `region`=?, `sales_rep`=?, `source_location`=?, `destination_location`=?, `staff`=?,`comment`=?, `reference`=?, `purpose`=?, `fromDate`=?, `toDate`=?, `activity`=?, `target`=?,`credit_note_invoice`=?,`customer_name`=?, `customer_pin`=? where `doc_no`=? and  `document_type`=? and `posted`=?";
                    $values = array($customer,$docDate,$region,$salesRep, $sourceLocation,$destinationLocation, $staff, $comment,$reference,$purpose,$startDate,$endDate,$activity,$target,$invoice,$customerName,$customerPin,$docNo,$docType,0);
                    if(pdoExecute($sql,$values)){
                        if($newDocument){
                	        updateLastNumber($series, $docNo);
                	    }
                        $response["status"] = true;
                        $response["overLoad1"] = $docNo;
	                    $response["message"] ="The ".$checkDocType[0]["document_type"]." was successfully updated";
                    }else{
                        $response["status"] = false;
	                    $response["message"] ="The ".$checkDocType[0]["document_type"]." could not be updated. Please try again";
                    }
                }
                
            }else{
				$error= false;
				$message= "";
				$approvalId = 0;
				$checkApprovals = fetchWithPdo("SELECT * FROM `stock_management_approvals` WHERE status = ? and user = ? and request_type=? and request_date=?",array("Approved",$myUserName,$docType,$docDate));
				if($docType=="EndofDay"){
				    $customer = fetchWithPdo("SELECT * FROM `users` WHERE username =? ",array($myUserName))[0]["receivables_acccount"];
					$check = fetchWithPdo("select * from sales_header where document_type =? and createdBy = ? and sales_date = ?",array($docType,$myUserName,$docDate));
					if(count($check)>0){
						$error= true;
				        $message.=strlen($message)>0?"<br>":"";
						$message.="End of day report already created";
					}
					$pendingStockController = fetchWithPdo("select * from sales_header where document_type=? and status = ? and createdBy=?",array("StockRequest","pending",$myUserName));
				    if(count($pendingStockController)>0){
				        if(count($checkApprovals)<1){
				            $error= true;
				            $message.=strlen($message)>0?"<br>":"";
					        $message.="Warehouse controller - Approval Pending Stock Request";
				        }else{
				            $approvalId = $checkApprovals[0]["id"];
				        }
				    }
				}
				if($docType=="StockRequest"){
				    	/*
				        if a created end of day has not been approved by stock controller, no stock request
                        if a created end of day older than one day has not been approved by super user or accounts, no stock request
                        if accounts has approved but there is a deficit, two days older, no stock request
                        if a vsm has an outstanding balance of empties, they cannot request for stock without approval from finance admin
                        if there is an approved EOD for the same day, no stock request - 
				        */
				        
				            $message="Pending Issues:";
				            $pendingStockController = fetchWithPdo("select * from sales_header where document_type=? and status = ? and createdBy=?",array("EndofDay","pending",$myUserName));
				            if(count($pendingStockController)>0){
				                if(count($checkApprovals)>0){
				                    $approvalId = $checkApprovals[0]["id"];
				                }else{
				                    $error= true;
				                    $message.=strlen($message)>0?"<br>":"";
						            $message.="Warehouse controller - Approval";
				                }
				            }
				            $superUserController = fetchWithPdo("select * from sales_header where document_type=? and status = ? and createdBy=? and confirmed_by_super_user=0 and sales_date<=DATE_SUB(CURRENT_DATE, INTERVAL 2 DAY)",array("EndofDay","Approved",$myUserName));
				            if(count($superUserController)>0){
				                if(count($checkApprovals)>0){
				                    $approvalId = $checkApprovals[0]["id"];
				                }else{
				                $error= true;
				                $message.=strlen($message)>0?"<br>":"";
						        $message.="Super User - Approval ";
				                }
				            }
				            
				            $accountsController = fetchWithPdo("select * from sales_header where document_type=? and status = ? and createdBy=? and confirmed_by_accounts=0 and sales_date<=DATE_SUB(CURRENT_DATE, INTERVAL 2 DAY)",array("EndofDay","Approved",$myUserName));
				            if(count($accountsController)>0){
				                if(count($checkApprovals)>0){
				                    $approvalId = $checkApprovals[0]["id"];
				                }else{
				                $error= true;
				                $message.=strlen($message)>0?"<br>":"";
						        $message.="Accounts - Approval";
				                }
				            }
				            $receivablesAccount = fetchWithPdo("SELECT A.receivables_acccount,B.creditLimit,SUM(C.Amount) customerBalance FROM `users` A LEFT JOIN customers B on A.receivables_acccount = B.customerNumber LEFT JOIN customerledgerentries C on B.customerNumber = C.CustomerNo WHERE username= ? and TransactionDateTime<DATE_SUB(CURRENT_DATE, INTERVAL 2 DAY) GROUP by A.receivables_acccount; ",array($myUserName));
				            if(count($receivablesAccount)>0){
				                 $limit = $receivablesAccount[0]["creditLimit"];
				                 $balance = $receivablesAccount[0]["customerBalance"];
				                 if($balance>$limit){
				                    if(count($checkApprovals)>0){
				                        $approvalId = $checkApprovals[0]["id"];
				                    }else{
				                     $error= true;
				                     $message.=strlen($message)>0?"<br>":"";
						             $message.="Accounts - Receivables. Balance ".number_format($balance,2);
				                    }
				                 }
				            }
				            //get total empties, get total rets, if not the same, block
				            $totalEmpties = getStockAtLocation(getEmptiesCode(),$destinationLocation);
				            $totalRets = getRetsLocation($destinationLocation);
				            if($totalEmpties!=$totalRets){
				                if(count($checkApprovals)>0){
				                    $approvalId = $checkApprovals[0]["id"];
				                }else{
				                $error= true;
				                $message.=strlen($message)>0?"<br>":"";
						        $message.="Stock Controller - Empties. Empties: ".number_format($totalEmpties,2)." Rets: ".number_format($totalRets,2);//"Your empties account is out of balance( $totalEmpties - $totalRets). Please contact the finance manager";
				                }
				            }
				        }
				        $existingDoc = fetchWithPdo("select * from sales_header where document_type=? and createdBy=? and sales_date=?",array("EndofDay",$myUserName,$docDate));
				        if(count($existingDoc)>0){
				            $error= true;
				            $message.=strlen($message)>0?"<br>":"";
						    $message.="End of day already done";
				        }
				
				
				if($error){
 						$response["status"] = false;
	                    $response["message"] =$message;
				}else{ 
                	$sql = "INSERT INTO `sales_header`(`doc_no`, `document_type`, `customer`, `sales_date`, `region`, `sales_rep`, `source_location`, `destination_location`, `staff`,`comment`, `reference`, `purpose`, `fromDate`, `toDate`, `activity`, `target`, `createdOn`, `createdBy`, `posted`,`credit_note_invoice`, `customer_name`, `customer_pin` ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),?,?,?,?,?)";
                	$values = array($docNo,$docType,$customer,$docDate,$region,$salesRep, $sourceLocation,$destinationLocation, $staff,$comment,$reference, $purpose,$startDate,$endDate,$activity,$target,$myUserName,0,$invoice,$customerName,$customerPin);
                	if(pdoExecute($sql,$values)){
                	    if($newDocument){
                	        updateLastNumber($series, $docNo);
                	    }
                	    if($approvalId>0){
                	        $sql = "UPDATE `stock_management_approvals` SET `status`=? WHERE `id`=?";
                	        pdoExecute($sql,array("Utilised",$approvalId));
                	    }
                	       if($docType=="EndofDay"){
                	           $openingValues = fetchWithPdo("SELECT A.code,A.name,A.unitOfMeasure,A.price,SUM(IF( B.TransactionDateTime<?,B.quantity,0))openingStock, SUM(IF(B.TransactionType in ('issue','stock_transfer') and B.TransactionDateTime>=?,B.quantity,0))issued, SUM(B.quantity) closing from items A LEFT JOIN itemledgerentries B on A.code = B.itemNo WHERE B.location= ? GROUP by A.code ",array($docDate,$docDate,$sourceLocation));
                	           foreach($openingValues as $openingValue){
                	               $addLine = "INSERT INTO `sales_lines`(`header_no`, `document_type`, `itemType`, `itemNo`, `description`, `unitOfMeasureCode`, `unitPrice`,  `opening_stock`, `issued_stock`, `closing_stock`, `quantity`, `totalExclVAT`, `totalVAT`, `totalAmount`, `created_by`, `createdOn`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())";
                	               $lineValues = array($docNo,$docType,"Items",$openingValue["code"],$openingValue["name"] ,$openingValue["unitOfMeasure"],$openingValue["price"],$openingValue["openingStock"],$openingValue["issued"],$openingValue["closing"],0,0,0,0, $myUserName);
                	               pdoExecute($addLine,$lineValues);
							
                	           }
                	           $paymentMethods = fetchWithPdo("SELECT id FROM `paymentmethods`",array());
                	           foreach($paymentMethods as $paymentMethod){
                	               $addLine = "INSERT INTO `daily_report_payments`(`report_id`, `payment_method`, `amount`) VALUES (?,?,?)";
                	               pdoExecute($addLine,array($docNo,$paymentMethod["id"],0));
                	           }
                	       }
                	    $response["status"] = true;
                	    $response["overLoad1"] = $docNo;
	            	    $response["message"] ="The ".$checkDocType[0]["document_type"]." was successfully created";
                	}else{
                	    $response["status"] = false;
	            	    $response["message"] ="The ".$checkDocType[0]["document_type"]." could not be created. Please try again";
                	}
				}
            }
            
        
        }else{
            $response["status"] = false;
	        $response["message"] ="Undefined Document Type. Please contact Support";
        }
    }else{
        $response["status"] = false;
	    $response["message"] ="Unknown Document Type. Please contact Support";
    }
    
}
else if($type=="salesline"){
    if(isset($_POST["headerNo"])&&isset($_POST["itemNo"])&&isset($_POST["itemType"])&&isset($_POST["documentType"])){
        $headerNo = trim($_POST["headerNo"]);
        $itemType = trim($_POST["itemType"]);
        $itemNo = trim($_POST["itemNo"]);
        $documentType = trim($_POST["documentType"]);
        
        $description = isset($_POST["description"])?trim($_POST["description"]):"";
        $unitOfMeasure = isset($_POST["unitOfMeasure"])?trim($_POST["unitOfMeasure"]):0;
        $details = isset($_POST["details"])?trim($_POST["details"]):"";
        $unitPrice = isset($_POST["unitPrice"])?trim($_POST["unitPrice"]):0;
        $requestedQuantity = isset($_POST["requestedQuantity"])?trim($_POST["requestedQuantity"]):0;
        $issuedQuantity = isset($_POST["issuedQuantity"])?trim($_POST["issuedQuantity"]):0;
        $quantity = isset($_POST["quantity"])?trim($_POST["quantity"]):0;
        
        $discount = isset($_POST["discount"])?trim($_POST["discount"]):0;
        $kilometres = isset($_POST["kilometres"])?trim($_POST["kilometres"]):0;
        $vehicle = isset($_POST["vehicle"])?trim($_POST["vehicle"]):"";
        $taxPercentage = 0; 
        $docType = fetchWithPdo("SELECT * FROM `document_types` WHERE code= ?",array($documentType));
        //get header
        $header = fetchWithPdo("SELECT A.*,B.pricing_group customerPricingGroup,D.pricing_group vsmPricingGroup FROM `sales_header` A LEFT JOIN customers B on A.customer = B.customerNumber LEFT JOIN shopLocations C on A.source_location = C.id LEFT JOIN users D on A.createdBy = D.username WHERE A.doc_no=? ",array($headerNo));
        if(count($header)!=1){
            $response["status"] = false;
		    $response["message"] ="The document could not be found";
        }else if($header[0]["status"]!="Draft"){
            $response["status"] = false;
		    $response["message"] ="The document is no longer open for editing";
        }else if(count($docType)<1){
            $response["status"] = false;
		    $response["message"] ="Unknown Document Type";
        }else{
            $getDocument = fetchWithPdo("SELECT * FROM `sales_header` WHERE doc_no = ? and document_type = ?",array($headerNo,$documentType));
            if(count($getDocument)<1){
                $response["status"] = false;
		        $response["message"] ="The ".$docType[0]["document_type"]." could not be found";
            }else{
                if($getDocument[0]["posted"]){
                    $response["status"] = false;
		            $response["message"] ="The ".$docType[0]["document_type"]." has alredy been posted";
                }else{
                    $hasError = false;
                    if($itemType=="Services"){
                        $service = fetchWithPdo("SELECT * FROM `chargeitems` WHERE id= ?",array($itemNo));
                        if(count($service)<1){
                            $hasError = true;
                            $response["status"] = false;
		                    $response["message"] ="The service could not be found";
                        }else{
                            $myService = $service[0];
                            $unitPrice=$unitPrice==0?$myService["default_amount"]:$unitPrice;
                            $taxPercentage = $myService["tax_rate"];
                            $description=strlen($description)<1?$myService["description"]:$description;
                        }
                        
                    }else if($itemType=="Items"){
                        $item = fetchWithPdo("SELECT A.code,A.name,A.description, B.percentage taxPercentage,A.unitOfMeasure,A.price,A.buying_price FROM `items` A LEFT JOIN taxGroups B on A.taxGroup = B.code WHERE A.code = ?",array($itemNo));
                        if(count($item)<1){
                            $hasError = true;
                            $response["status"] = false;
		                    $response["message"] ="The product could not be found";
                        }else{
                            //check if line already exist in the header
                            $check = fetchWithPdo("select * from sales_lines where header_no=? and itemNo=? and document_type=?",array($headerNo,$itemNo,$documentType));
                            if(count($check)>0){
                                $hasError = true;
                                $response["status"] = false;
		                        $response["message"] ="You have already added the product to the document. Kindly edit the quantity instead";
                            }else{
                                //get price by group
                                $myItem = $item[0];
                                $unitPrice = $unitPrice==0?$myItem["price"]:$unitPrice;
                                $myItem = $item[0];
                                $unitPrice = $unitPrice==0?$myItem["price"]:$unitPrice;
                                if($documentType=="EndofDay"||$documentType=="StockRequest"||$documentType=="WarehouseReturn"){  
                                    $unitPrice=getProductPrice($itemNo,$header[0]["vsmPricingGroup"]);
                                }else if($documentType=="storerequisition"){
                                    $unitPrice= $myItem["buying_price"];
                                }
                                else{
                                    //echo "Am here".$header[0]["customerPricingGroup"];
                                    if($unitPrice==0){
                                        $unitPrice=getProductPrice($itemNo,$header[0]["customerPricingGroup"]);
                                    }
                                    
                                }
                                
                                $taxPercentage = $myItem["taxPercentage"];
                                $description=strlen($description)<1?$myItem["name"]:$description;
                            }
                        }
                    }else{
                        $hasError = true;
                        $response["status"] = false;
		                $response["message"] ="Unknown Item Type";
                    }
                    if(!$hasError){
                        if($documentType=="StockRequest"){  
                           $availableQuantity= getStockAtLocation($itemNo,1);
                           if($requestedQuantity>$availableQuantity){
                                $hasError = true;
                                $response["status"] = false;
		                        $response["message"] ="You cannot request more than ".number_format($availableQuantity);
                           }
                        }
                    }
                    
                    if(!$hasError){
                        $totalAmount = $unitPrice*$quantity;
                        $totalVAT = ($totalAmount*$taxPercentage)/(100+$taxPercentage);
                        $totalExclVAT = $totalAmount -$totalVAT; 
                        $sql = "INSERT INTO `sales_lines`(`header_no`, `document_type`, `itemType`, `itemNo`, `description`, `unitOfMeasureCode`, `details`, `unitPrice`,`discount`, `requested_quantity`, `issued_quantity`, `quantity`, `totalExclVAT`, `totalVAT`, `totalAmount`,`kilometres`,`vehicle`, `created_by`, `createdOn`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())";
                        $values = array($headerNo,$documentType,$itemType,$itemNo,$description,$unitOfMeasure,$details,$unitPrice,$discount,$requestedQuantity,$issuedQuantity,$quantity,$totalExclVAT,$totalVAT,$totalAmount,$kilometres,$vehicle,$myUserName);
                        if(pdoExecute($sql,$values)){
                            $response["status"] = true;
		                    $response["message"] ="The ".$docType[0]["document_type"]." line was successfully added";
		                    updateInvoiceTotal($headerNo);
                        }else{
                            $response["status"] = false;
		                    $response["message"] ="The ".$docType[0]["document_type"]." line could not be added";
                        }
                    }
                }
            }
        }
    }else{
        $response["status"] = false;
		$response["message"] ="Some mandatory fields could not be found. Please contact Support";
    }
    
    
}

else if($type=="customerinvoice"){ //region sales_rep
    //region salesRep
    /*
    params.put("document_type", "imprest");
        params.put("staff", tStaff);
        params.put("purpose", tPurpose);
        params.put("fromDate", tFromDate);
        params.put("toDate", tToDate);
        params.put("activity", tActivity);
        params.put("target", tTarget);*/
        
	if(isset($_POST["invoiceNo"])){
		  	$check = "select * from sales_header where doc_no = ?";
			$values = array();
			//$values[0] = $_POST["invoiceNo"];
			$invoiceNo = isset($_POST["invoiceNo"])?trim($_POST["invoiceNo"]):"";
			$customer = isset($_POST["customer"])?trim($_POST["customer"]):"";
			$invoiceDate = isset($_POST["invoiceDate"])?trim($_POST["invoiceDate"]):"";
			$region = isset($_POST["region"])?trim($_POST["region"]):"";
			$salesRep = isset($_POST["salesRep"])?trim($_POST["salesRep"]):"";
			$shopLocationCode = isset($_POST["shopLocationCode"])?trim($_POST["shopLocationCode"]):"";
			$staff = isset($_POST["staff"])?trim($_POST["staff"]):"";
			
			$document_type = isset($_POST["document_type"])?trim($_POST["document_type"]):"sales_invoice";
			$staff = isset($_POST["staff"])?trim($_POST["staff"]):"";
			$purpose = isset($_POST["purpose"])?trim($_POST["purpose"]):"";
			$fromDate = isset($_POST["fromDate"])?trim($_POST["fromDate"]):"";
			$toDate = isset($_POST["toDate"])?trim($_POST["toDate"]):"";
			$activity = isset($_POST["activity"])?trim($_POST["activity"]):"";
			$target = isset($_POST["target"])?trim($_POST["target"]):"";
			
			$exists = false;
			$posted = false;
			array_push($values, $invoiceNo);
			$stmt3 =fetchByPDO($check, $values);  
				while ($row = $stmt3->fetch()) {
				    $exists = true;
				    //print_r($row);
				    $posted = $row["posted"];
				}
			if($posted){
			    $response["status"] = false;
				$response["message"] = "The $document_type has already been posted. No changes can be made";
			}else{
			if($exists){
				$sql= "update sales_header set customer=?, sales_date=?,region=?, sales_rep=?,source_location=?, `staff`=?, `purpose`=?, `fromDate`=?, `toDate`=?, `activity`=?, `target`=? where doc_no =? and posted = ? and document_type=?";
				$values = array();
				array_push($values, $customer);
				array_push($values, $invoiceDate);
				array_push($values, $region);
				array_push($values, $salesRep);
				array_push($values, $shopLocationCode);
				array_push($values, $staff);
				array_push($values, $purpose);
				array_push($values, $fromDate);
				array_push($values, $toDate);
				array_push($values, $activity);
				array_push($values, $target);
				array_push($values, $invoiceNo);
				array_push($values, 0);
				array_push($values, $document_type);
			
				
				if(pdoExecute($sql,$values)){
					$response["status"] = true;
					$response["message"] = "The $document_type was successfully updated";
				}else{
					$response["status"] = false;
					$response["message"] = "The $document_type could not be updated";
				}
			}else{			
			$sql= "INSERT INTO `sales_header`(`doc_no`, `document_type`,`customer`, `sales_date`,`region`, `sales_rep`,`source_location`,`staff`, `purpose`, `fromDate`, `toDate`, `activity`, `target`, `createdOn`, `createdBy`, `posted`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),?,?)";
			$values = array();
			array_push($values, $invoiceNo);
			array_push($values, $document_type);
			array_push($values, $customer);
			array_push($values, $invoiceDate);
			array_push($values, $region);
			array_push($values, $salesRep);
			array_push($values, $shopLocationCode);
			array_push($values, $staff);
			array_push($values, $purpose);
			array_push($values, $fromDate);
			array_push($values, $toDate);
			array_push($values, $activity);
			array_push($values, $target);
			array_push($values, $myUserName);
			array_push($values, 0);
			if(pdoExecute($sql,$values)){
					$response["status"] = true;
					$response["message"] = "The $document_type was successfully saved";
				}else{
					$response["status"] = false;
					$response["message"] = "The $document_type could not be saved";
			}
			}
		}
}
}
else if($type=="loan"){
	$loanNumber =mysqli_real_escape_string($conn, trim($_POST["loanNumber"]));
	$loanAmount =mysqli_real_escape_string($conn, trim($_POST["loanAmount"]));
	$loanInstallments =mysqli_real_escape_string($conn, trim($_POST["loanInstallments"]));
	$chequeNumber =mysqli_real_escape_string($conn, trim($_POST["chequeNumber"]));
	$member =mysqli_real_escape_string($conn, trim($_POST["member"]));
	$loanProduct =mysqli_real_escape_string($conn, trim($_POST["loanProduct"]));
	$payingBank =mysqli_real_escape_string($conn, trim($_POST["payingBank"]));
	$disbursementMode =mysqli_real_escape_string($conn, trim($_POST["disbursementMode"]));
	$issuedOn =mysqli_real_escape_string($conn, trim($_POST["issuedOn"]));

	$crbCharge =mysqli_real_escape_string($conn, trim($_POST["crbCharge"]));
	$chequeCommission =mysqli_real_escape_string($conn, trim($_POST["chequeCommission"]));
	$loanForm =mysqli_real_escape_string($conn, trim($_POST["loanForm"]));
	$insurance =mysqli_real_escape_string($conn, trim($_POST["insurance"]));
	$monthlyRepayment =mysqli_real_escape_string($conn, trim($_POST["monthlyRepayment"]));
	$receivingBankCode =mysqli_real_escape_string($conn, trim($_POST["receivingBankCode"]));
	$chargesExternalAccount =mysqli_real_escape_string($conn, trim($_POST["chargesExternalAccount"]));
	$topup =mysqli_real_escape_string($conn, trim($_POST["topup"]));
	$topuploanno =mysqli_real_escape_string($conn, trim($_POST["topuploanno"]));


	//if member and loan product and amount is blank, don't save
	$error = false;
	$message = "";
	if(($member=="")&&($loanProduct=="")&&($loanAmount=="")){
		$error = true;
		$message = "The loan cannot be saved because the loan form is empty";
	}
	if(!$error){
	//check if loan exists
	$check = "select * from loansregister where LoanNo = '$loanNumber' ";
	$checkres = mysqli_query($conn, $check);
	$sql = "";
	if(mysqli_num_rows($checkres)>0){
		//update
		$sql= "UPDATE `loansregister` SET `LoanProductCode`='$loanProduct',`MemberNo`='$member',`PrincipalAmount`='$loanAmount',`LoanInstallments`='$loanInstallments',`LoanDisbursementMode`='$disbursementMode',`PayingBank`='$payingBank',`CheckNumber`='$chequeNumber',`Balance`='$loanAmount',`Issued`=false,`IssuedOn`='$issuedOn',`ApplicationDate`=NOW(),`crbcharge` = '$crbCharge',`chequeCommission`='$chequeCommission',`insurance`='$insurance',`loanform`='$loanForm',`chargesreceivingbank`='$receivingBankCode',`chargesexternaldocno`='$chargesExternalAccount',`monthlyrepayment`='$monthlyRepayment', `topUp` ='$topup' ,`loanTopUpNo` ='$topuploanno'  WHERE LoanNo = '$loanNumber'";
	}else{
		//insert
		 $sql = "INSERT INTO `loansregister`(`LoanNo`, `LoanProductCode`, `MemberNo`, `PrincipalAmount`, `LoanInstallments`, `LoanDisbursementMode`, `PayingBank`, `CheckNumber`, `Balance`, `Issued`,`IssuedOn`,`crbcharge`,`chequeCommission`,`insurance`,`loanform`,`chargesreceivingbank`,`chargesexternaldocno`,`monthlyrepayment`,`topUp`,`loanTopUpNo`) VALUES " .
					"('$loanNumber','$loanProduct','$member','$loanAmount','$loanInstallments','$disbursementMode','$payingBank','$chequeNumber','$loanAmount',false,'$issuedOn','$crbCharge','$chequeCommission','$insurance','$loanForm','$receivingBankCode','$chargesExternalAccount','$monthlyRepayment','$topup','$topuploanno')";
	}
	if(mysqli_query($conn, $sql)){
	$response["status"] = true;
		$response["message"] = "The loan was successfully saved";	
	}else{
		$response["status"] = false;
		$response["message"] ="The loan could not be saved";
	}
	}else{
		$response["status"] = false;
		$response["message"] =$message ;
	}
}
else if($type=="servicefeelines"){
	if(isset($_POST["data"])){
	//
	$getSetups = "SELECT * FROM `vehiclesetup` ";
	$setUpRes = mysqli_query($conn,$getSetups);
	$monthlyFee = 0;
	$dailyFee=0;
	while($result = mysqli_fetch_assoc($setUpRes)){
		$monthlyFee = $result["MonthlyFee"];
		$dailyFee=$result["DailyFee"];
	}
	$allEntries =  json_decode($_POST["data"]);
	$updateAll = "";
	
		$pdo = null;
		$conStr = sprintf("mysql:host=%s;dbname=%s", $server, $dbName);
		try {
           $pdo = new PDO($conStr, $username, $password);
		    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$pdo->beginTransaction();
			$error = false;
			$message = "";
			
			
	foreach($allEntries as $entry){
		$entryId = $entry["0"];
		$daysInActive = $entry["1"];
		$feeCharged =$monthlyFee - ($daysInActive*$dailyFee);
		//$feeCharged = $feeCharged<1?0:$feeCharged;
		$getBrands = "SELECT * from vehiclebrands WHERE brandId = (select brand from vehicles WHERE vehicles.RegNo = (SELECT vehicle FROM `service_fee_lines` WHERE Id = '$entryId'))";
		$brandsRes = mysqli_query($conn, $getBrands);
		/*if(mysqli_num_rows($brandsRes)<1){
			$response["status"] = false;
			$response["message"] ="A vehicle with the registration number  does not exist";
			return $response;
		}*/
		while($brandResult = mysqli_fetch_assoc($brandsRes)){
			$brandMonthly = $brandResult["monthlyServiceFee"];
			$brandDaily = $brandResult["dailyServiceFee"];
			$feeCharged =$brandMonthly - ($daysInActive*$brandDaily);
			//$feeCharged = $feeCharged<1?0:$feeCharged;
			
		}
		$currentRecord = "SELECT * FROM `service_fee_lines` WHERE `Id` = '$entryId'";
		$currentRes = mysqli_query($conn, $currentRecord);
		while($currentRecord = mysqli_fetch_assoc($currentRes)){
			$days = $currentRecord["daysInactive"];
			$fee = $currentRecord["feeCharged"];
			$exempt = $days*$brandDaily;
			$total = $exempt+$fee;
			$feeCharged = $total- ($daysInActive*$brandDaily);
		}
		$updateQuery="update `service_fee_lines` set daysInactive =?, feeCharged = ? where Id = ?";
		$values = array();
		array_push($values,$daysInActive);
		array_push($values,$feeCharged);
		array_push($values,$entryId);
		$stmt5  = $pdo->prepare($updateQuery);
						$stmt5 ->execute($values);            
						if(!$stmt5){
							$error = true;
							$message = "The lines could not be updated";
							 $pdo->rollBack();
								break;
						}
	}
	if(!$error){
		$pdo->commit();
		$response["status"] = true;
		$response["message"] ="The lines were successfully saved";
		
		//get vehicles gthat have exited within the month
		
			/*$month = 10;
			$year = 2019;
			$voucherId = "21";
			$lastDay = "30";
			$oddMonths = array(1,3,5,7,8,10,12);
			if(in_array($month,$oddMonths)){
				$lastDay = "31";
			}
			else if($month ==2){
				$lastDay = "28";
				if(($year%4)==0){
					$lastDay = "29";
				}
			}
			$lastDate = $year."-".$month."-".$lastDay." 00:00:00";
			$getExited = "select * from vehicleexit where exitDate >= '".$year."-".$month."-1' and exitDate <= '".$year."-".$month."-".$lastDay."'";
			$exitRes = mysqli_query($conn, $getExited);
			while($exitResult = mysqli_fetch_assoc($exitRes)){
				$regNo = $exitResult["vehicle"];
				$exitDate = $exitResult["exitDate"];
				//$daysExempted = 
				$sql = "SELECT A.*, B.* FROM `vehicles` A left join vehiclebrands B on A.brand= B.brandId WHERE A.RegNo  ='$regNo'";
				//echo $sql;
				$res = mysqli_query($conn, $sql);
				$lines = "";
				while($result = mysqli_fetch_assoc($res)){
					//insert lines
					$vehicle = $result["RegNo"];
					$monthlyServiceFee = $result["monthlyServiceFee"];
					$insertLine = "INSERT INTO `service_fee_lines`( `voucherNo`, `vehicle`, `daysInactive`, `feeCharged`)  VALUES ('$voucherId', '$vehicle',DATEDIFF('$lastDate','$exitDate' ), $monthlyServiceFee)";
					//echo $insertLine;
					mysqli_query($conn, $insertLine);
				}
				
			}*/
			
		/*if(mysqli_query($conn,$updateAll)){
		$response["status"] = true;
		$response["message"] ="The lines were successfully saved";
	}else{
		$response["status"] = false;
		$response["message"] ="The lines could not be saved ";
	}*/
	}else{
			$response["status"] = false;
		$response["message"] ="The lines could not be saved ";
	}
	
	} catch (PDOException $e) {
           $error = true;
			$response["status"] = false;
			$response["message"] = "There is an exception".$e->getMessage();
        }
	
}

}
else if($type=="importmembers"){
	$request= file_get_contents('php://input');//json_encode($_REQUEST);
$request1 = json_decode($request, true);
$sql = "";
$error = false;
$message = "";
$count = 1;
$pdo = null;
$conStr = sprintf("mysql:host=%s;dbname=%s", $server, $dbName);
        try {
           $pdo = new PDO($conStr, $username, $password);
        $pdo->beginTransaction();
		
foreach($request1 as $member){
	
	$memberNo = trim($member["memberNo"]);
	if($memberNo==""){
		$error = true;
		$message.=strlen($message)>0? "\\n":"";
		$message.= "Member number cannot be blank in row $count";
	}else{
	$mNoLength = strlen($memberNo);
	$mNumberSub = substr($memberNo ,$mNoLength-1, 2);
	if($mNumberSub==".0"){
		$beforeChange = substr($memberNo ,0, $mNoLength-2);
		if(is_numeric($beforeChange)){
			$memberNo=$beforeChange;
		}
	}
	}
	$memberNo = $memberNo;
	$firstName = trim($member["firstName"]);
	$middleName =trim($member["middleName"]);
	$lastName = trim($member["lastName"]);
	$idNumber = trim($member["idNumber"]);
	$phoneNumber =trim($member["phoneNumber"]);
	$emailAddress = trim($member["emailAddress"]);
	$dob = trim($member["dob"]);
	$kraPin =trim($member["kraPin"]);
	$part = "('$memberNo', '$firstName', '$middleName', '$lastName', '$idNumber',  '$kraPin', '$phoneNumber','$emailAddress', NOW(), '$dob ', '$photo', '1', NOW())";
	//$sql = 'SELECT amount FROM accounts WHERE id=:from';
		$sql  = "INSERT INTO `members`(`MemberNo`, `FirstName`, `MiddleName`, `LastName`, `IdNo`,  `PIN`, `PhoneNumber`,`Email`, `JoinDate`, `DateOfBirth`, `Photo`, `AddedBy`, `AddedOn`) VALUES (:MemberNo, :FirstName, :MiddleName, :LastName, :IdNo,  :PIN, :PhoneNumber,:Email, NOW(), :DateOfBirth, :Photo, :AddedBy, NOW())";
            $stmt  = $pdo->prepare($sql);
			$values = array();
			$values[":MemberNo"] = $memberNo;
			$values[":FirstName"] = $firstName;
			$values[":MiddleName"] = $middleName;
			$values[":LastName"] = $lastName;
			$values[":IdNo"] = $idNumber;
			$values[":PIN"] = $kraPin;
			$values[":PhoneNumber"] = $phoneNumber;
			$values[":Email"] = $emailAddress;
			$values[":DateOfBirth"] = $dob;
			$values[":Photo"] = "";
			$values[":AddedBy"] = "1";
			 $stmt ->execute($values);
            //$stmt->execute(array(":from" => $from));
			if(!$stmt){
				$error = true;
				$message = "The members could not be imported. Please try again";
				 $pdo->rollBack();
					break;
				
			}
           // $availableAmount = (int) $stmt->fetchColumn();
           // $stmt->closeCursor();
	
	
	
	
	
	$count ++;
	}

		if(!$error){
	$pdo->commit();
		$response["status"] = true;
		$response["message"] = "The members were successfully imported";
	}else{
		$response["status"] = false;
		$response["message"] = $message;
	}
} catch (PDOException $e) {
           $error = true;
	$response["status"] = false;
	$response["message"] = "There is an exception".$e->getMessage();
        }
}
else if($type=="importvehicles"){
	$request= file_get_contents('php://input');//json_encode($_REQUEST);
$request1 = json_decode($request, true);
$sql = "";
$error = false;
$message = "";
$count = 1;
$pdo = null;
$conStr = sprintf("mysql:host=%s;dbname=%s", $server, $dbName);
        try {
           $pdo = new PDO($conStr, $username, $password);
        $pdo->beginTransaction();
		
foreach($request1 as $vehicle){	
	$memberNo = trim($vehicle["memberNo"]);
	if($memberNo==""){
		$error = true;
		$message.=strlen($message)>0? "\n":"";
		$message.= "Member number cannot be blank in row $count";
	}else{
	$mNoLength = strlen($memberNo);
	$mNumberSub = substr($memberNo ,$mNoLength-1, 2);
	if($mNumberSub==".0"){
		$beforeChange = substr($memberNo ,0, $mNoLength-2);
		if(is_numeric($beforeChange)){
			$memberNo=$beforeChange;
		}
	}
	}
	$memberNo = $memberNo;
	//check that member no exists
	$mNo = mysqli_real_escape_string($conn, $memberNo);
	$checkmember = "SELECT * FROM `members` where MemberNo = '$mNo'";
	$checkRes = mysqli_query($conn, $checkmember);
	if(mysqli_num_rows($checkRes)<1){
		$error = true;
		$message.=strlen($message)>0? "\n":"";
		$message.= "There is no member with the member no $memberNo";
	}
	
	$regNo = trim($vehicle["regNo"]);
	$regNo = str_ireplace(" ","",$regNo);
	//check that the vehicle does not exist in the current selection
	$vReg = mysqli_real_escape_string($conn,$regNo);
	$checkReg = "SELECT * FROM `vehicles` where RegNo = '$vReg' ";
	$checkRegRes = mysqli_query($conn,$checkReg );
	if(mysqli_num_rows($checkRegRes)>0){
		$error = true;
		$message.=strlen($message)>0? "\n":"";
		$message.= "The vehicle $regNo already exist";
	}
	$fleetNumber =trim($vehicle["fleetNumber"]);
	$vehicleMake = trim($vehicle["vehicleMake"]);
	$vehicleMakeCode = 0;
	//if vehicle make does not exist create. if it does, get the make code;
	$escMake = mysqli_real_escape_string($conn, $vehicleMake);
	$checkMakeSql = "SELECT * FROM `vehiclemakes` where Description = '$escMake' ";
	$checkMakeRes = mysqli_query($conn, $checkMakeSql);
	if(mysqli_num_rows($checkMakeRes)<1){
		//doesn't exist, create
		$insertMake = "INSERT INTO `vehiclemakes`(`Code`, `Description`) VALUES ('','$escMake')";
		if(mysqli_query($conn,$insertMake)){
			$vehicleMakeCode = $conn->insert_id;
		}
		
	}else{
		while($makeresult = mysqli_fetch_assoc($checkMakeRes)){
			$vehicleMakeCode =$makeresult["Code"];
		}
	}
	$vehicleModel = trim($vehicle["vehicleModel"]);
	$escModel = mysqli_real_escape_string($conn, $vehicleModel);
	$vehicleModelCode= 0;
	$checkModelSql  = "select * from vehiclemodels where Description = 'escModel'";
	$checkModelRes = mysqli_query($conn, $checkModelSql);
	if(mysqli_num_rows($checkModelRes)<1){
		//doesn exist create
		$insertModel = "INSERT INTO `vehiclemodels`(`Code`, `Description`, `Make`) VALUES ('','$escModel','$vehicleMakeCode')";
		if(mysqli_query($conn,$insertModel)){
			$vehicleModelCode = $conn->insert_id;
		}
	}else{
		//retrieve 
		while($modelResult = mysqli_fetch_assoc($checkModelRes)){
			$vehicleModelCode=$modelResult["Code"];
		}
	}
	
	$alias =trim($vehicle["alias"]);
	
	//$sql = 'SELECT amount FROM accounts WHERE id=:from';
		$sql.$count  = "INSERT INTO `vehicles`(`RegNo`, `FleetNumber`, `Make`, `Model`, `Name(alias)`, `Owner`, `AddedOn`, `AddedBy`) VALUES (:RegNo,:FleetNumber,:Make,:Model,:alias,:Owner,NOW(),:AddedBy)";
            $stmt  = $pdo->prepare($sql.$count );
			$values = array();
			$values[":Owner"] = $memberNo;
			$values[":RegNo"] = $regNo;
			$values[":FleetNumber"] = $fleetNumber;
			$values[":Make"] = $vehicleMakeCode;
			$values[":Model"] = $vehicleModelCode;
			$values[":alias"] = $alias;
			$values[":AddedBy"] = '1';
			
			 $stmt ->execute($values);
			if(!$stmt){
				$error = true;
				$message = "The vehicles could not be imported. Please try again";
				 $pdo->rollBack();
				break;
				
			}
	$count ++;
	}

	if(!$error){
$pdo->commit();
	$response["status"] = true;
	$response["message"] = "The vehicles were successfully imported";
}else{
	$response["status"] = false;
	$response["message"] = $message;
}
} catch (PDOException $e) {
           $error = true;
	$response["status"] = false;
	$response["message"] = "There is an exception".$e->getMessage();
        }
}
else if($type=="importloans"){
	$request= file_get_contents('php://input');//json_encode($_REQUEST);
$request1 = json_decode($request, true);
//echo json_encode($request1);

$error = false;
$message = "";
$count = 1;
$pdo = null;
$conStr = sprintf("mysql:host=%s;dbname=%s", $server, $dbName);
        try {
           $pdo = new PDO($conStr, $username, $password);
        $pdo->beginTransaction();
foreach($request1 as $loan){
$count++;	
$loanNo = trim($loan["loanNo"]);
$memberNo = trim($loan["memberNo"]);
$mNoLength = strlen($memberNo);
	$mNumberSub = substr($memberNo ,$mNoLength-1, 2);
	if($mNumberSub==".0"){
		$beforeChange = substr($memberNo ,0, $mNoLength-2);
		if(is_numeric($beforeChange)){
			$memberNo=$beforeChange;
		}
	}
$date = trim($loan["date"]);
$principal = trim($loan["principal"]);
$amountPaid = trim($loan["amountPaid"]);
$interest = trim($loan["interest"]);
$penalty = trim($loan["penalty"]);
$principalPaid = trim($loan["principalPaid"]);
$interestPaid = trim($loan["interestPaid"]);
$issuedOn = trim($loan["issuedOn"]);
$escLoanNo = mysqli_real_escape_string($conn, $loanNo);
$checkExists = "SELECT * FROM `loansregister` where LoanNo = '$escLoanNo'";
$checkRes = mysqli_query($conn, $checkExists);
//check if member exists
if(mysqli_num_rows($checkRes)<1){
	//if no entry in loans register, create the loan, 
	$insertLoan = "INSERT INTO `loansregister`(`LoanNo`, `LoanProductCode`, `MemberNo`, `PrincipalAmount`, `LoanInstallments`, `LoanDisbursementMode`, `PayingBank`, `CheckNumber`, `Balance`, `Issued`, `IssuedOn`, `LastPaymentDate`, `Status`, `ApplicationDate`) 												VALUES (:LoanNo,:LoanProductCode,:MemberNo,:PrincipalAmount,:LoanInstallments,:LoanDisbursementMode,:PayingBank,:CheckNumber,:Balance,	:Issued,:IssuedOn,:LastPaymentDate,:Status,:ApplicationDate)";
	$stmt  = $pdo->prepare($insertLoan );
			$values = array();
			$values[":LoanNo"] = $loanNo;
			$values[":LoanProductCode"] = '001';
			$values[":MemberNo"] = $memberNo;
			$values[":PrincipalAmount"] = $principal;
			$values[":LoanInstallments"] = "12";
			$values[":LoanDisbursementMode"] = "";
			$values[":PayingBank"] = "0";
			$values[":CheckNumber"] = "";
			$values[":Balance"] = "0";
			$values[":Issued"] = true;
			$values[":IssuedOn"] = $issuedOn ;
			$values[":LastPaymentDate"] = "";
			$values[":Status"] = '1';
			$values[":ApplicationDate"] = $issuedOn;			
			 $stmt ->execute($values);
			 echo json_encode($values);
			if(!$stmt){
				$error = true;
				$message = "The loans could not be imported. Please try again";
				 $pdo->rollBack();
				break;
				
			}
}
//other wise create an entry in loans ledger
//principal
if(!trim($issuedOn)==""){
$sql  = "INSERT INTO `loanledgerentries`(`LoanNumber`, `DocumentNumber`, `ExternalDocumentNumber`, `TransactionType`, `Description`, `TransactionDate`, `Debit`, `Credit`, `Amount`, `PostedBy`) VALUES 
												(:LoanNumber,:DocumentNumber,:ExternalDocumentNumber,:TransactionType,:Description,
												:TransactionDate,:Debit,:Credit,:Amount,:PostedBy)";
            $stmt  = $pdo->prepare($sql );
			$values = array();
			$values[":LoanNumber"] = $loanNo;
			$values[":DocumentNumber"] = "";
			$values[":ExternalDocumentNumber"] = "";
			$values[":TransactionType"] = "301";
			$values[":Description"] = 'Loan Issued';
			$values[":TransactionDate"] = $issuedOn;
			$values[":Debit"] = $principal;
			$values[":Credit"] = 0;
			$values[":Amount"] = $principal;
			$values[":PostedBy"] = '1';
			
			 $stmt ->execute($values);
			if(!$stmt){
				$error = true;
				$message = "The loans could not be imported. Please try again";
				 $pdo->rollBack();
				break;
				
			}
}	
		//interest	
if($interest>0){
$sql  = "INSERT INTO `loanledgerentries`(`LoanNumber`, `DocumentNumber`, `ExternalDocumentNumber`, `TransactionType`, `Description`, `TransactionDate`, `Debit`, `Credit`, `Amount`, `PostedBy`) VALUES 
												(:LoanNumber,:DocumentNumber,:ExternalDocumentNumber,:TransactionType,:Description,
												:TransactionDate,:Debit,:Credit,:Amount,:PostedBy)";
            $stmt  = $pdo->prepare($sql );
			$values = array();
			$values[":LoanNumber"] = $loanNo;
			$values[":DocumentNumber"] = "";
			$values[":ExternalDocumentNumber"] = "";
			$values[":TransactionType"] = "302";
			$values[":Description"] = 'Interest Accrued';
			$values[":TransactionDate"] = $date;
			$values[":Debit"] = $interest;
			$values[":Credit"] = 0;
			$values[":Amount"] = $interest;
			$values[":PostedBy"] = '1';
			
			 $stmt ->execute($values);
			if(!$stmt){
				$error = true;
				$message = "The loans could not be imported. Please try again";
				 $pdo->rollBack();
				break;
				
			}
}	
	//penalty		
if($penalty>0){
$sql  = "INSERT INTO `loanledgerentries`(`LoanNumber`, `DocumentNumber`, `ExternalDocumentNumber`, `TransactionType`, `Description`, `TransactionDate`, `Debit`, `Credit`, `Amount`, `PostedBy`) VALUES 
												(:LoanNumber,:DocumentNumber,:ExternalDocumentNumber,:TransactionType,:Description,
												:TransactionDate,:Debit,:Credit,:Amount,:PostedBy)";
            $stmt  = $pdo->prepare($sql );
			$values = array();
			$values[":LoanNumber"] = $loanNo;
			$values[":DocumentNumber"] = "";
			$values[":ExternalDocumentNumber"] = "";
			$values[":TransactionType"] = "302";
			$values[":Description"] = 'Penalty Accrued';
			$values[":TransactionDate"] = $date;
			$values[":Debit"] = $penalty;
			$values[":Credit"] = 0;
			$values[":Amount"] = $penalty;
			$values[":PostedBy"] = '1';
			
			 $stmt ->execute($values);
			if(!$stmt){
				$error = true;
				$message = "The loans could not be imported. Please try again";
				 $pdo->rollBack();
				break;
				
			}
}	
	//Interest paid			
if($interestPaid>0){
$sql  = "INSERT INTO `loanledgerentries`(`LoanNumber`, `DocumentNumber`, `ExternalDocumentNumber`, `TransactionType`, `Description`, `TransactionDate`, `Debit`, `Credit`, `Amount`, `PostedBy`) VALUES 
												(:LoanNumber,:DocumentNumber,:ExternalDocumentNumber,:TransactionType,:Description,
												:TransactionDate,:Debit,:Credit,:Amount,:PostedBy)";
            $stmt  = $pdo->prepare($sql );
			$values = array();
			$values[":LoanNumber"] = $loanNo;
			$values[":DocumentNumber"] = "";
			$values[":ExternalDocumentNumber"] = "";
			$values[":TransactionType"] = "303";
			$values[":Description"] = 'Interest Paid';
			$values[":TransactionDate"] = $date;
			$values[":Debit"] = 0;
			$values[":Credit"] = $interestPaid;
			$values[":Amount"] = $interestPaid;
			$values[":PostedBy"] = '1';
			
			 $stmt ->execute($values);
			if(!$stmt){
				$error = true;
				$message = "The loans could not be imported. Please try again";
				 $pdo->rollBack();
				break;
				
			}
}	
		//principal paid	
if($principalPaid>0){
$sql  = "INSERT INTO `loanledgerentries`(`LoanNumber`, `DocumentNumber`, `ExternalDocumentNumber`, `TransactionType`, `Description`, `TransactionDate`, `Debit`, `Credit`, `Amount`, `PostedBy`) VALUES 
												(:LoanNumber,:DocumentNumber,:ExternalDocumentNumber,:TransactionType,:Description,
												:TransactionDate,:Debit,:Credit,:Amount,:PostedBy)";
            $stmt  = $pdo->prepare($sql );
			$values = array();
			$values[":LoanNumber"] = $loanNo;
			$values[":DocumentNumber"] = "";
			$values[":ExternalDocumentNumber"] = "";
			$values[":TransactionType"] = "303";
			$values[":Description"] = 'Interest Paid';
			$values[":TransactionDate"] = $date;
			$values[":Debit"] = 0;
			$values[":Credit"] = $principalPaid;
			$values[":Amount"] = $principalPaid;
			$values[":PostedBy"] = '1';
			
			 $stmt ->execute($values);
			if(!$stmt){
				$error = true;
				$message = "The loans could not be imported. Please try again";
				 $pdo->rollBack();
				break;
				
			}
}	
			

}

if(!$error){
$pdo->commit();
	$response["status"] = true;
	$response["message"] = "The loans were successfully imported";
}else{
	$response["status"] = false;
	$response["message"] = $message;
}
} catch (PDOException $e) {
           $error = true;
	$response["status"] = false;
	$response["message"] = "There is an exception".$e->getMessage();
        }
}
elseif ($type=='userrole'){
	$roleName = mysqli_real_escape_string($conn,trim($_POST["roleName"]));
	$roleId = mysqli_real_escape_string($conn,trim($_POST["roleId"]));
	$sel = mysqli_query($conn, "SELECT * FROM `userroles` WHERE `id`='$roleId' ");
	if (mysqli_num_rows($sel)>0) {
		$update = mysqli_query($conn, "UPDATE `userroles` SET `name`='$roleName' WHERE `id`='$roleId'");
		if ($update) {
			$response["status"] = true;
			$response["message"] = "User Role successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "User Role could not be updated";
		}
	}else{
		$create = mysqli_query($conn, "INSERT INTO `userroles` VALUES(0, '$roleName','$myUserName',NOW())");
		if ($create) {
			$response["status"] = true;
			$response["message"] = "User Role successfully added";
		}else{
			$response["status"] = false;
			$response["message"] = "User Role could not be added";
		}
	}
}
elseif ($type=="dashboardmatrix"){
	$matrixId = mysqli_real_escape_string($conn,trim($_POST["matrixId"]));
	$view = mysqli_real_escape_string($conn,trim($_POST["view"]));
	$sql = "update dashboardmatrix set view =$view where id = $matrixId ";
	mysqli_query($conn,$sql);
}
else if ($type=="datarightsmatrix"){
	$matrixId = mysqli_real_escape_string($conn,trim($_POST["matrixId"]));
	$action = strtolower(trim($_POST["action"]));
	$value = mysqli_real_escape_string($conn,trim($_POST["value"]));
	if($action=="insert"){
		$sql = "update datarightsmatrix set `insert` =$value where id = $matrixId ";
		mysqli_query($conn,$sql);
	}else if($action=="view"){
		$sql = "update datarightsmatrix set `view` =$value where id = $matrixId ";
		mysqli_query($conn,$sql);
	}else if($action=="update"){
		$sql = "update datarightsmatrix set `update` =$value where id = $matrixId ";
		mysqli_query($conn,$sql);
	}else if($action=="delete"){
		$sql = "update datarightsmatrix set `delete` =$value where id = $matrixId ";
		mysqli_query($conn,$sql);
	}else if($action=="post"){
		$sql = "update datarightsmatrix set `post` =$value where id = $matrixId ";
		//echo $sql;
		mysqli_query($conn,$sql);
	}else if($action=="reverse"){
		$sql = "update datarightsmatrix set `reverse` =$value where id = $matrixId ";
		mysqli_query($conn,$sql);
	}
}
else if($type=="transactiontype"){
	$transactionCode = trim($_POST["transactionCode"]);
	$transactionDescription = trim($_POST["transactionDescription"]);
	$accountNo = trim($_POST["accountNo"]);
	$enabled = trim($_POST["enabled"]);
	$showOnReceipt = trim($_POST["showOnReceipt"]);
	$showOnAgency = trim($_POST["showOnAgency"]);
	$journalAccountType = trim($_POST["journalAccountType"]);
	$tTransactionCode = mysqli_real_escape_string($conn, $transactionCode);
	$check = "select * from transactiontypes where Code = '$tTransactionCode'";
	$checkRes = mysqli_query($conn,$check);
	if(mysqli_num_rows($checkRes)>0){
		$response["status"] = false;
		$response["message"] = "There is another transaction with the given code";
	}else{
		$sql = "insert into transactiontypes(`Code`,`Description`,`GLAccount`,`enabled`,`AddedOn`,`addedBy`,`receipt`,`journalAccountType`,`agency`) values (?,?,?,?,NOW(),?,?,?,?)";
		$values = array($transactionCode,$transactionDescription,$accountNo,$enabled,$myUserName,$showOnReceipt,$journalAccountType,$showOnAgency);
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["message"] = "The transaction type was successfully added";
		}else{
			$response["status"] = false;
			$response["message"] = "The transaction type could not be added";
		}
	}
	
}
else if ($type=="addAddress"){
    if (isset($_POST["customerId"])) {
        $customerId = mysqli_real_escape_string($conn, trim($_POST["customerId"]));
        $recipientName =  mysqli_real_escape_string($conn, trim($_POST["recipientName"]));
        $phone = mysqli_real_escape_string($conn, trim($_POST["recipientPhone"]));
        $townName = mysqli_real_escape_string($conn, trim($_POST["townName"]));
        $townLatitude = mysqli_real_escape_string($conn, trim($_POST["townLatitude"]));
        $townLongitude = mysqli_real_escape_string($conn, trim($_POST["townLongitude"]));
        
        $sql = "INSERT INTO `addresses` (`id`, `user_id`, `recipientName`, `addressPhone`, `town_name`, `town_lat`, `town_long`, `is_default`, `created_on`) 
        VALUES (NULL,?,?,?,?,?,?,'0', NOW())";
        $values = array($customerId, $recipientName, $phone, $townName, $townLatitude, $townLongitude);
        
        if(pdoExecute($sql,$values)){
            // Successfully added item
    		$response["status"] = true;
	        $response["message"] = "Address was successfully added";
        } else {
            $response["status"] = false;
	        $response["message"] = "Could not add address.";
        }
    } else {
        $response["status"] = false;
	    $response["message"] = "Could not add address. Please try logging out and logging in again.";
    }
	
}
else if($type=="region"){
    $regionId = trim($_POST["regionId"]);
    $regionName = trim($_POST["regionName"]);
    $rsmCode = trim($_POST["rsmCode"]);
    $tRegionId = mysqli_real_escape_string($conn,$regionId);
    $check = "select * from regions where id='$tRegionId'";
    $checkRes = mysqli_query($conn,$check);
   if(mysqli_num_rows($checkRes)>0){
       $sql = "update `regions` set `regionName` = ?, `rsmCode` = ? where id=?";
       $values = array($regionName,$rsmCode,$regionId);
       if(pdoExecute($sql,$values)){
    		$response["status"] = true;
	        $response["message"] = "The region was successfully updated";
	        $response["overLoad1"] = $regionId;
        } else {
            $response["status"] = false;
	        $response["message"] = "The region could not be updated";
        }
       
   }else{
       $sql = "INSERT INTO `regions`(`regionName`, `rsmCode`, `addedOn`, `addedBy`) VALUES (?,?,NOW(),?)";
       $values = array($regionName,$rsmCode,$myUserName);
       $insertedId = pdoInsertLastId($sql,$values);
       if($insertedId>0){
    		$response["status"] = true;
	        $response["message"] = "The region was successfully created";
	        $response["overLoad1"] = $regionId;
        } else {
            $response["status"] = false;
	        $response["message"] = "The region could not be created";
        }
   }
    
    
    
}
else if ($type=="createOrder"){
    if (isset($_POST["user_id"])) {
        $userId = mysqli_real_escape_string($conn, trim($_POST["user_id"]));
        $addressId = mysqli_real_escape_string($conn, trim($_POST["address_id"]));
        $paymentMethod = mysqli_real_escape_string($conn, trim($_POST["payment_method"]));
        $mpesaPhone = mysqli_real_escape_string($conn, trim($_POST["mpesa_number"]));
        $order_items = json_decode($_POST["cart_items"],true);
        
        $orderId = getNextNumber(7);
        
        // $sql = "INSERT INTO `orders` (`id`, `user_id`, `address_id`, `payment_method`, `mpesa_number`) VALUES (NULL,?,?,?,?)";
        // $values = array($userId, $addressId, $paymentMethod, $mpesaPhone);
        // //	CUST0010
        // $orderId = pdoInsertLastId($sql,$values);
        if(strlen($orderId) > 0){
            $customerId = mysqli_real_escape_string($conn, trim($_POST["client_id"]));
            
            $linesSql= "";
            $linesValues = array();
            $tTotalAmount = 0;
            $tTotalTax = 0;
            foreach($order_items as $item){
                $itemId = $item["item_id"];
                $linesSql.= strlen($linesSql)> 0 ? "," : "";
                $linesSql.="(?,?,?,?)";
                array_push($linesValues,$orderId);
                array_push($linesValues,$item["item_id"]);
                array_push($linesValues,$item["quantity"]);
                array_push($linesValues,$item["unitOfMeasureId"]);
                
                $quantity = $item["quantity"];
                
                //$itemId
            	$taxRate = 0;
            	$itemName="";
            	$unitPrice="";
            	$unitOfMeasureId = "";
            	//print_r($_POST);
            	if(isset($item["unitOfMeasureId"])){
            	    $unitOfMeasureId = 	mysqli_real_escape_string($conn, trim($item["unitOfMeasureId"]));
            	}
            	if($unitOfMeasureId ==""||$unitOfMeasureId =="0"){
            		$getTaxRate = "select A.*,(SELECT percentage FROM `taxGroups` WHERE code = (SELECT taxGroup FROM `items` WHERE code = A.code)) taxRate from items A where A.code = ? ";
            		$values = array();
        		    $values[0] = $itemId;
        				$stmt2 = fetchByPDO($getTaxRate, $values); 
        				while ($row = $stmt2->fetch()) {
        					$taxRate = $row['taxRate'];
        					$itemName = $row['name'];
        					$unitPrice = $row['price'];
        		    }
            	}else{
            	  //() 
            	  	$getTaxRate = "select A.*,(SELECT percentage FROM `taxGroups` WHERE code = (SELECT taxGroup FROM `items` WHERE code = A.code)) taxRate, (SELECT sellingPrice FROM `unitofmeasurerelationships` WHERE id = ?) unitPrice from items A where A.code = ? ";
            		$values = array();
        		    $values[1] = $itemId;
        		    $values[0] = $unitOfMeasureId;
        				$stmt2 = fetchByPDO($getTaxRate, $values); 
        				while ($row = $stmt2->fetch()) {
        					$taxRate = $row['taxRate'];
        					$itemName = $row['name'];
        					$unitPrice = $row['unitPrice'];
        		    }
            	    
            	}
    			$sql= "INSERT INTO `sales_lines`(`header_no`, `itemType`, `itemNo`, `description`, `unitPrice`, `quantity`, `totalExclVAT`, `totalVAT`, `totalAmount`, `createdOn`,`unitOfMeasureCode`) VALUES (?,?,?,?,?,?,?,?,?, NOW() + INTERVAL 7 HOUR,?)";
    			$values = array();
    			$values[0] = $orderId;
    			$values[1] = "Items";
    			$values[2] = $itemId; 
    			$values[3] = $itemName;
    			$values[4] = $unitPrice;
    			$values[5] = $quantity;
    			
    			$totalAmount = $quantity*$unitPrice;
    			//$totalTax = ($taxRate*$totalAmount)/100;
    			$taxableAmount= $totalAmount/(($taxRate/100)+1);
	            $totalTax = Round(($taxableAmount*$taxRate)/100,2);
    			$values[6] =$totalAmount-$totalTax;
    			$values[7] = $totalTax;
    			$values[8] = $totalAmount;
    			$values[9] = $unitOfMeasureId;
    			pdoExecute($sql, $values);//$unitOfMeasureId
    			$tTotalAmount+=$totalAmount;
                $tTotalTax +=$totalTax;
              
            }
            // $linesSql = "INSERT INTO `orderlines`(`order_id`, `item_id`, `quantity`) VALUES ".$linesSql;
            
            $totaExcVat = $tTotalAmount-$tTotalTax;
            
            
            $linesSql = "INSERT INTO `customerinvoices`
            (`invoiceNo`, `customer`, `invoiceDate`, `shopLocationCode`, `createdOn`, `createdBy`, `posted`, `totalPostedExclVat`, `totalPostedVat`, `totalAmount`) 
            VALUES (?,?,NOW() + INTERVAL 7 HOUR,?,NOW() + INTERVAL 7 HOUR,?,?,?,?,?)";
            
            $orderValues = array($orderId,$customerId,1,$userId,0,$totaExcVat,$tTotalTax,$tTotalAmount);
            
            if(pdoExecute($linesSql,$orderValues)){
                $response["status"] = true;
                $response["message"] = "Order was created successfully.";
                
                updateLastNumber(7, $orderId);//getNextNumber(7);
                
                sendSTKPush($mpesaPhone, $tTotalAmount,$orderId);
                
                
                //$tTotalAmount = 0;
                 //   $tTotalTax = 0;
                    //$totaExcVat = $tTotalAmount-$tTotalTax;
                  //$insertOrder = "INSERT INTO `customerinvoices`(`invoiceNo`, `customer`, `invoiceDate`, `shopLocationCode`, `createdOn`, `createdBy`, `posted`, `totalPostedExclVat`, `totalPostedVat`, `totalAmount`) VALUES (?,?,NOW(),?,NOW(),?,?,?,?,?)";
                  //$orderValues = array($orderId,$customerId,1,"",0,$totaExcVat,$tTotalTax,$tTotalAmount);
                  //if(pdoExecute($insertOrder,$orderValues)){
                  //    sendSTKPush($mpesaPhone, $tTotalAmount,$orderId);
                      //Items
                     // $linesSql = "INSERT INTO `customerinvoicelines`(`invoiceNo`, `itemType`, `itemNo`, `description`, `unitPrice`, `quantity`, `totalExclVAT`, `totalVAT`, `totalAmount`) VALUES (?,?,?,?,?,?,?,?,?)";
                  //}
            } else {
                $response["status"] = false;
                $response["message"] = "Could not create order. Please try logging out and logging in again.";
            }
            
            
            
            
            
            // foreach($order_items as $item){
            //     // $lineItemsSql.= strlen($linesSql)>0?",":"";
            //     $tempValues = array($parcelId,$item["item_id"],$item["quantity"]);
            //     array_push($linesValues,$tempValues);
                
            //     // $lineItemsSql.=$linesValues;
            // }
            
            // $linesSql = "INSERT INTO `orderlines`(`order_id`, `item_id`, `quantity`) VALUES (?,?,?)";
            // if(pdoExecute($linesSql,$linesValues )){
            //     $response["status"] = true;
            //     $response["message"] = "Order was created successfully.";
            // } else {
            //     $response["status"] = false;
            //     $response["message"] = "Could not create order. Please try logging out and logging in again.";
            // }
        }
    } else {
        $response["status"] = false;
	    $response["message"] = "Could not create order. Please try logging out and logging in again.";
    }
	
}
else if($type == "mpesatransaction"){
    $request= file_get_contents('php://input');//json_encode($_REQUEST);
    $request1 = json_decode($request, true);
    
    $sql ="INSERT INTO `mpesa_transactions`(`TransactionType`, `TransID`, `TransTime`, `TransAmount`, `BusinessShortCode`, `BillRefNumber`, `InvoiceNumber`, `OrgAccountBalance`, `ThirdPartyTransID`, `MSISDN`, `FirstName`, `MiddleName`, `LastName`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    $values = array();
    array_push($values,$request1["transaction_type"]);
    array_push($values,$request1["transaction_code"]);
    array_push($values,$request1["transaction_time"]);
    array_push($values,$request1["amount"]);
    array_push($values,$request1["business_short_code"]);
    array_push($values,$request1["bill_ref_number"]);
    array_push($values,$request1["invoice_number"]);
    array_push($values,$request1["org_account_balance"]);
    array_push($values,$request1["third_party_trans_is"]);
    array_push($values,$request1["msisdn"]);
    array_push($values,$request1["f_name"]);
    array_push($values,$request1["m_name"]);
    array_push($values,$request1["l_name"]);
    if(pdoExecute($sql,$values)){
        $date = new DateTime();
		$receiptDate = $date->format('Y-m-d');
        $receiptNo = getNextNumber(8);
        $fromInvoiceNo = fetchWithPdo("SELECT * FROM `customerinvoices` WHERE invoiceNo = ?", array($request1["bill_ref_number"]));
         $customerNo="";
        if(isset($fromInvoiceNo[0]["customer"])){
           $customerNo = $fromInvoiceNo[0]["customer"];
        }else{
            //try matchine with id no
            //SELECT * FROM `customers` idNo = ? or phoneNumber = ?,customerNumber
             $fromIdNo = fetchWithPdo("SELECT * FROM `customers` idNo = ? or phoneNumber = ?", array($request1["bill_ref_number"],$request1["bill_ref_number"]));
             $customerNo = $fromIdNo[0]["customerNumber"];
        }
        /*$getCustomer = "SELECT * FROM `customers` WHERE idNo = '".$request1["bill_ref_number"]."'";
        $customerRes = mysqli_query($conn,$getCustomer);
        $customerNo = "";
        while( $customerResult =mysqli_fetch_assoc($customerRes)){
            $customerNo = $customerResult["customerNumber"];
        }*/
        $sql = "INSERT INTO `customerreceipts`(`receiptNo`, `customer`, `bank`, `paymentmethod`, `externalRef`, `paymentDate`,`createdBy`, `createdOn`, `posted`) VALUES (?,?,?,?,?,?,?, NOW(), 0)";
    	$values = array($receiptNo,$customerNo,3,2,$request1["transaction_code"],$receiptDate, $myUserName);
    	if(pdoExecute($sql, $values)){
    	        $invoiceNo = "";
    	        $description="Payment for goods delivered";
    	        $amount=$request1["amount"];
    	        updateLastNumber(8, $receiptNo);
    	        $insertLine = "INSERT INTO `customer_receipt_lines`(`receipt_no`, `invoice_no`, `description`, `gross_amount`, `withholding_tax`, `withholding_vat`, `total_amount`, `added_on`, `added_by`) VALUES (?,?,?,?,?,?,?,NOW(),?)";
                $lineValues = array($receiptNo,$invoiceNo,$description,$amount,0,0,$amount,$myUserName);
                if(pdoExecute($insertLine,$lineValues)){
    			    //create line
    			    $items = array();
                    $header = array();
    				$header["documentNo"] = $receiptNo;
    				$header["externalDocumentno"] = $request1["transaction_code"];
    				$header["transactionDate"] = $receiptDate;
    				$header["transactionType"] = "602";
    				$header["description"] = "Payment for goods delivered";
    				$header["amount"] = $amount*-1;
    				$header["accountType"] ="customer";
    				$header["accountNumber"] =$customerNo;
    				$header["user"] =$myUserName;
    				$header["invoiceNo"] = $invoiceNo;
    				array_push($items,$header);
    				//bank entries
    				$line = array();
    				$line["documentNo"] = $receiptNo;
    				$line["externalDocumentno"] = $request1["transaction_code"];
    				$line["transactionDate"] = $receiptDate;
    				$line["transactionType"] = "601";
    				$line["description"] = "Payment from ".getAccountName("customer",$customerNo);//$receipt["beingPaymentFor"];
    				$line["amount"] = $amount;
    				$line["accountNumber"] =3;
    				$line["accountType"] = "bank";
    				$line["user"] =$myUserName;
    				array_push($items, $line);
    				$response = post($items,"customerreceipt", $receiptNo);
                }
    			    
    			    //post
    	}
    }
}
else if ($type=="submodulecolumns"){
    $subModule = trim($_POST["subModule"]);
    $allColumns = json_decode($_POST["allColumns"],true);
   // echo "Am here";
    foreach($allColumns as $column){
        $sql = "INSERT INTO `list_columns`(`list_id`, `column_name`, `data_key`, `enabled`) VALUES (?,?,?,?)";
        $values = array($subModule,$column,"obj.".$column,1);
      //  echo $sql;
        //print_r($values);
        pdoExecute($sql,$values);
    }
}
else if ($type=="stock_management_approval"){
    $documentType  = trim($_POST["document_type"]);
    $requestDate  = trim($_POST["date"]);
    $rejectionReason  = trim($_POST["rejectionReason"]);
    //check no pending request
    $check = fetchWithPdo("select * from stock_management_approvals where user=? and status=?",array($myUserName,"Pending"));
    if(count($check)>0){
        $response["status"] = false;
	    $response["message"] = "You have a pending request. Please contact the Managing Director";
    }else{
        $sql = "INSERT INTO `stock_management_approvals`(`user`, `request_type`, `request_date`, `rejection_reason`,`added_on`, `status`) VALUES (?,?,?,?,NOW(),?)";
        $values = array($myUserName,$documentType,$requestDate,$rejectionReason,"Pending");//Approved
        if(pdoExecute($sql,$values)){
            $response["status"] = true;
	        $response["message"] = "The request was successfully created";
        }else{
            $response["status"] = false;
	        $response["message"] = "The request could not be created";
        }
    }
}

else if ($type=="customerreceiptline"){
    /*
           params.put("receiptNo",receiptNumber.getText().trim());
                    params.put("paymentType",tPaymentType);
                    params.put("invoiceNo",tInvoiceNo);
                    params.put("description",tDescription);
                    params.put("amount",tAmount);
    */
    $receiptNo = trim($_POST["receiptNo"]);
    $paymentType = trim($_POST["paymentType"]);
    $invoiceNo = trim($_POST["invoiceNo"]);
    $description = trim($_POST["description"]);
    $amount = trim($_POST["amount"]);
    $checkSql = "select * from customerreceipts where receiptNo = ?";
    $checkValues = array($receiptNo);
    $checkResult = fetchWithPdo($checkSql,$checkValues);
    $noOfRecords = count($checkResult);
    if($noOfRecords!=1){
        $response["status"] = false;
        $response["message"] = "The selected receipt could not be found"; 
    }else{
        $receiptDetails = $checkResult[0];
        if($receiptDetails["posted"]){
            $response["status"] = false;
            $response["message"] = "The selected receipt has already been posted. No changes can be made to it"; 
        }else{
            $checkPaymentType="SELECT * FROM `payment_types` WHERE id = ?";
            $paymentCheckValues = array($paymentType);
             $paymentDetails = fetchWithPdo($checkPaymentType,$paymentCheckValues);
             if(count($paymentDetails)==1){
                $type =  $paymentDetails[0];
                //`withholding_tax_percentage`, `withholding_vat_percentage`
                $withholdingTaxPercentage =$type["withholding_tax_percentage"]; 
                $withholdingVATPercentage =$type["withholding_vat_percentage"]; 
                $insert = "INSERT INTO `customer_receipt_lines`(`receipt_no`, `invoice_no`, `description`, `gross_amount`, `withholding_tax`, `withholding_vat`, `total_amount`, `added_on`, `added_by`) VALUES (?,?,?,?,?,?,?,NOW(),?)";
                $values = array($receiptNo,$invoiceNo,$description,$amount,0,0,$amount,$myUserName);
                if(pdoExecute($insert,$values)){
                    $response["status"] = true;
                    $response["message"] = "The receipt line was successfully added"; 
                }else{
                    $response["status"] = false;
                    $response["message"] = "The receipt line could not be added. Please try again"; 
                }
             }else{
                $response["status"] = false;
                $response["message"] = "The selected payment type could not be found"; 
             }
            //insert line
            
        }
    }
    
    
}
else if($type=="salesfromeqtr"){
    
    $date = trim($_POST["date"]);
    $customerNo = trim($_POST["customerNo"]);
    $tSalesRep = trim($_POST["salesRep"]);
    $itemNo = trim($_POST["itemNo"]);
    $sellingPrice = trim($_POST["sellingPrice"]);
    $discount = trim($_POST["discount"]);
    $quantity = trim($_POST["quantity"]);
    $finalAmount = $sellingPrice-$quantity;
    $saleId = trim($_POST["saleId"]);
    
    $customerDetails = fetchWithPdo("SELECT * FROM `customers` WHERE eqtrId = ?", array($customerNo));
    $customer = $customerDetails[0]["customerNumber"];
    
    $salesRepDetails = fetchWithPdo("SELECT * FROM vendors WHERE eqtrNo = ?", array($tSalesRep));
    $region = isset($salesRepDetails[0]["regionCode"])?$salesRepDetails[0]["regionCode"]:0;
    $salesRep = isset($salesRepDetails[0]["vendorNumber"])?$salesRepDetails[0]["vendorNumber"]:0;
    
    $itemDetails = fetchWithPdo("SELECT * FROM `items` WHERE eqtr_code =?", array($itemNo));
    $description = isset($itemDetails[0]["name"])?$itemDetails[0]["name"]:"Opening Balance";
    
    //$description = "";
    $sql= "INSERT INTO `customerinvoices`(`invoiceNo`, `document_type`,`customer`, `invoiceDate`,`region`, `sales_rep`,`shopLocationCode`,`staff`, `purpose`, `fromDate`, `toDate`, `activity`, `target`, `createdOn`, `createdBy`, `posted`,`eqtr_code`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),?,?,?)";
	$values = array();
	$invoiceNo = getNextNumber(7);
	
	
	array_push($values, $invoiceNo);
	array_push($values, "sales_invoice");
	array_push($values, $customer);
	array_push($values, $date);
	array_push($values, $region);
	array_push($values, $salesRep);
	array_push($values, 1);
	array_push($values, "");
	array_push($values, "");
	array_push($values, "");
	array_push($values, "");
	array_push($values, "");
	array_push($values, "");
	array_push($values, $myUserName);
	array_push($values, 0);
	array_push($values, $saleId);
	if(pdoExecute($sql,$values)){
	    updateLastNumber(7,$invoiceNo);
	    $sql= "INSERT INTO `customerinvoicelines`(`invoiceNo`, `document_type`,`itemType`, `itemNo`, `description`,`unitOfMeasureCode`, `unitPrice`, `quantity`, `totalExclVAT`, `totalVAT`, `totalAmount`,`details`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
		$values = array();
			
		$totalAmount = $finalAmount;
		$taxableAmount= $finalAmount;
		$totalTax = 0;
			
		array_push($values,$invoiceNo);
		array_push($values,"sales_invoice");
		array_push($values,"Charge Items");
		array_push($values,"38");
		array_push($values,$description);
		array_push($values,"");
		array_push($values,$totalAmount);
		array_push($values,0);
		array_push($values,$totalAmount-$totalTax);
		array_push($values,$totalTax);
		array_push($values,$totalAmount);
		array_push($values,"");
		if(pdoExecute($sql, $values)){
		    //$response = postSalesInvoice($invoiceNo,$myUserName);
		        $items = array();
		        $getLines = "SELECT A.*,B.*,A.description customDesc FROM `customerinvoicelines` A left join chargeitems B on A.itemNo = B.id where invoiceNo = '$invoiceNo' and itemType = 'Charge Items'";
				$linesRes = mysqli_query($conn,$getLines);
				while($lineResult = mysqli_fetch_assoc($linesRes)){
				    
					$line = array();
					$line["documentNo"] = $invoiceNo;
					$line["externalDocumentno"] = "";
					$line["transactionDate"] = $date;
					$line["transactionType"] = "602";
					$line["description"] = $lineResult["customDesc"];  
					$line["amount"] = $lineResult["totalAmount"]*-1;
					$line["accountType"] ="glaccount";
					$line["accountNumber"] =$lineResult["account_no"];
					$line["user"] =$myUserName;
					$line["region"] =$region;
				    $line["salesRep"] =$salesRep;
					array_push($items, $line);
					
					$header = array();
					$header["documentNo"] = $invoiceNo;
					$header["externalDocumentno"] = "";
					$header["transactionDate"] = $date;
					$header["transactionType"] = "602";
					$header["description"] = $lineResult["customDesc"];  
					$header["amount"] = $lineResult["totalAmount"];
					$header["accountType"] ="customer";
					$header["accountNumber"] =$customer;
					$header["user"] =$myUserName;
					$header["region"] =$region;
				    $header["salesRep"] =$salesRep;
					array_push($items, $header);	
				}
				$response = post($items,"customerinvoice", $invoiceNo);
				
		}
	}
}
else if ($type=="paymentsfromeqtr"){
        $payment_date = trim($_POST["payment_date"]);
        $sale_id = trim($_POST["sale_id"]);
        $amount = trim($_POST["amount"]);
        $source_receipt_number = trim($_POST["source_receipt_number"]);
        $description = trim($_POST["description"]);
        $saleDetails = fetchWithPdo("SELECT * FROM `customerinvoices` WHERE eqtr_code = ?", array($sale_id));
       // print_r($saleDetails);
        if(strlen($description)<1){
            $description="Payment from mpesa";
        }
        
        $receiptNo = getNextNumber(8);
        
        $bankCode = 6;
        $paymentMethod = 3;
        $invoiceNo = $saleDetails[0]["invoiceNo"];
        $customerNo =$saleDetails[0]["customer"];
        
        $sql = "INSERT INTO `customerreceipts`(`receiptNo`, `customer`, `bank`, `paymentmethod`, `externalRef`, `paymentDate`,`createdBy`, `createdOn`, `posted`) VALUES (?,?,?,?,?,?,?, NOW(), 0)";
		$values = array($receiptNo,$customerNo,$bankCode,$paymentMethod,$source_receipt_number,$payment_date, $myUserName);
		
		if(pdoExecute($sql, $values)){
		    updateLastNumber(8,$receiptNo);
	    	$insert = "INSERT INTO `customer_receipt_lines`(`receipt_no`, `invoice_no`, `description`, `gross_amount`, `withholding_tax`, `withholding_vat`, `total_amount`, `added_on`, `added_by`) VALUES (?,?,?,?,?,?,?,NOW(),?)";
            $values = array($receiptNo,$invoiceNo,$description,$amount,0,0,$amount,$myUserName);
            if(pdoExecute($insert,$values)){
                //post receipt
                $items = array();
                $header = array();
				$header["documentNo"] = $receiptNo;
				$header["externalDocumentno"] = $source_receipt_number;
				$header["transactionDate"] = $payment_date;
				$header["transactionType"] = "602";
				$header["description"] = $description;
				$header["amount"] = $amount*-1;
				$header["accountType"] ="customer";
				$header["accountNumber"] =$customerNo;
				$header["user"] =$myUserName;
				$header["invoiceNo"] = $invoiceNo;
				array_push($items,$header);
				//bank entries
				$line = array();
				$line["documentNo"] = $receiptNo;
				$line["externalDocumentno"] = $source_receipt_number;
				$line["transactionDate"] = $payment_date;
				$line["transactionType"] = "601";
				$line["description"] = "Payment from ".getAccountName("customer",$customerNo);//$receipt["beingPaymentFor"];
				$line["amount"] = $amount;
				$line["accountNumber"] =$bankCode;
				$line["accountType"] = "bank";
				$line["user"] =$myUserName;
				array_push($items, $line);
				$response = post($items,"customerreceipt", $receiptNo);
            }
		}
               
}
else if ($type=="importcustomer"){
    $customerName = trim($_POST["accountName"]);
    if(true){//strpos($customerName,"Sacco") or strpos($customerName,"sacco")){
        $customerInfo = explode(" ",$customerName);
        $fName = isset($customerInfo[0])?$customerInfo[0]:"";
        $check = "SELECT * FROM `customers` WHERE firstName = '$fName' ";
        $checkRes = mysqli_query($conn, $check);
        if(mysqli_num_rows($checkRes)<1){
            $count = count($customerInfo);
            $mName = "";
            $lName = "";
            if($count==2){
               $lName = $customerInfo[1]; 
            }else{
               $mName = $customerInfo[1]; 
               $lName = $customerInfo[2]; 
            }
            $custNo = getNextNumber(6); 
            $insertCustomer = "INSERT INTO `customers` (`customerNumber`, `firstName`, `middleName`, `lastName`, `customerpostinggroup`, `addedOn`) 
			VALUES (?,?,?,?,?,NOW())";
			$values = array($custNo,$fName,$mName,$lName,"1");
			if(pdoExecute($insertCustomer,$values)){
             updateLastNumber(6, $custNo);
             $response["status"] = true;
            $response["message"] = "The customer was successfully created";
			}else{
			    $response["status"] = false;
                $response["message"] = "The customer could not be created";
			}
        }else{
            while($checkResult = mysqli_fetch_assoc($checkRes)){
                $response["overLoad1"] = $checkResult["customerNumber"];
            }
            $response["status"] = false;
            $response["message"] = "The customer has already been created";
        }
    }else{
        $response["status"] = false;
      $response["message"] = "The name sacco is not contained";
    }
}
else if ($type=="product_price"){
    $pricingGroup=trim($_POST["pricingGroup"]);
    $sellingPrice=trim($_POST["sellingPrice"]);
    $itemCode=trim($_POST["itemCode"]);
    
    $check = fetchWithPdo("select * from pricing_group_entries where product_code=? and group_id=?",array($itemCode,$pricingGroup));
    
    if(count($check)>0){
        $sql="update `pricing_group_entries` set `selling_price` =?,added_on =NOW() where `product_code`=? and  `group_id`=?";
        $values = array($sellingPrice,$itemCode,$pricingGroup);
        if(pdoExecute($sql,$values)){
            $response["status"] = true;
            $response["message"] = "The price was successfully updated"; 
        }else{
            $response["status"] = false;
            $response["message"] = "The price could not be updated. Please try again"; 
        }
    }else{
        $sql="INSERT INTO `pricing_group_entries`(`product_code`, `group_id`,`selling_price`, `added_on`, `added_by`) VALUES (?,?,?,NOW(),?)";
        $values = array($itemCode,$pricingGroup,$sellingPrice,$myUserName);
        if(pdoExecute($sql,$values)){
            $response["status"] = true;
            $response["message"] = "The price was successfully added"; 
        }else{
            $response["status"] = false;
            $response["message"] = "The price could not be added. Please try again"; 
        }
    }
    
}
else if ($type=="stock_conversion"){
    $code = trim($_POST["code"]);
    $conversionDate = trim($_POST["conversionDate"]);
    $sourceWarehouse = trim($_POST["sourceWarehouse"]);
    $destinationWarehouse = trim($_POST["destinationWarehouse"]);
    $sourceProduct = trim($_POST["sourceProduct"]);
    $convertedProduct = trim($_POST["convertedProduct"]);
    $quantity = trim($_POST["quantity"]);
    $value = trim($_POST["value"]);
    if(strlen($code)<1){
        $code = getNextNumber(100);
        //check exists
        $check = fetchWithPdo("SELECT * FROM `stock_conversion` WHERE `code`=?",array($code));
        if(count($check)>0){
            $response["status"] = false;
		    $response["message"] = "Number series error. Please contact support";
        }else{
             //insert
            $sql = "INSERT INTO `stock_conversion`(`code`, `conversion_date`, `source_warehouse`, `destination_warehouse`, `source_product`, `converted_product`, `quantity`, `value`, `posted`, `added_by`, `added_on`) VALUES (?,?,?,?,?,?,?,?,?,?,NOW())";
            $values = array($code,$conversionDate,$sourceWarehouse,$destinationWarehouse,$sourceProduct,$convertedProduct,$quantity,$value,0,$myUserName);
            if(pdoExecute($sql,$values)){
                $response["status"] = true;
		        $response["message"] = "The stock conversion was successfully created";
		        //update no series
      	        updateLastNumber(100, $code);
      	        $response["overLoad1"] = $code;
            }else{
                $response["status"] = false;
		        $response["message"] = "The stock conversion could not be created";
            }
        }
    }else{//update
        //confirm exists
        $check = fetchWithPdo("SELECT * FROM `stock_conversion` WHERE `code`=?",array($code));
        if(count($check)<1){
            $response["status"] = false;
		    $response["message"] = "A record with the given code does not exist";
        }else{
             //not posted
            if($check[0]["posted"]){
                $response["status"] = false;
		        $response["message"] = "The stock conversion has already been posted. No changes can be made";
            }else{
                //update
                $sql = "update  `stock_conversion` set  `conversion_date`=?, `source_warehouse`=?, `destination_warehouse`=?, `source_product`=?, `converted_product`=?, `quantity`=?, `value`=? where `code`=? and `posted`=? ";
                $values = array($conversionDate,$sourceWarehouse,$destinationWarehouse,$sourceProduct,$convertedProduct,$quantity,$value,$code,0);
                if(pdoExecute($sql,$values)){
                    $response["overLoad1"] = $code;
                    $response["status"] = true;
		            $response["message"] = "The stock conversion was successfully updated";
                }else{
                    $response["status"] = false;
		            $response["message"] = "The stock conversion could not be updated";
                }
            }
        }
    }
}
else if ($type=="file"){
    $docNo  = getNextNumber(200);
    updateLastNumber(200,$docNo);
    
    $documentType = trim($_POST["documentType"]);
    $documentId = trim($_POST["documentId"]);
    $fileName = trim($_POST["fileName"]);
    $documentJson = trim($_POST["documentJson"]);
    $fileInfo = explode(".",$fileName);
    $extension = $fileInfo[count($fileInfo)-1];
     if(file_put_contents("edms/".$docNo.".".$extension,base64_decode($_POST["documentJson"]))){
         $sql = "INSERT INTO `edms_files`(`doc_no`, `document_type`, `document_id`, `file_name`, `extension`, `added_on`, `added_by`, `file_info`) VALUES (?,?,?,?,?,NOw(),?,?)";
         $values = array($docNo,$documentType,$documentId,$fileName,$extension,$myUserName,$documentJson);
         if(pdoExecute($sql,$values)){
             $response["status"] = true;
             $response["message"] = "Success"; 
         }else{
            $response["status"] = false;
            $response["message"] = "Upload Failed"; 
         }
	 }else{
	     $response["status"] = false;
         $response["message"] = "Upload Failed"; 
	 }
}
else if ($type=="bank_balance"){
    $voucherNo = trim($_POST["voucherNo"]);
    $bankCode = trim($_POST["bankCode"]);
    $balanceDate = trim($_POST["balanceDate"]);
    $bankBalance = trim($_POST["bankBalance"]);
    if (strlen($voucherNo)<1){//create
        $sql = "INSERT INTO `bank_balances`(`balance_date`, `bank_code`, `bank_balance`, `added_on`, `added_by`) VALUES (?,?,?,NOW(),?)";
        $values = array($balanceDate,$bankCode,$bankBalance,$myUserName);
        if(pdoExecute($sql,$values)){
             $response["status"] = true;
             $response["message"] = "The bank balance was successfully added"; 
         }else{
            $response["status"] = false;
            $response["message"] = "The bank balance could not be added"; 
         }
    }else{//update
        $sql = "update `bank_balances` set `balance_date`=?, `bank_code`=?, `bank_balance`=? where id = ? ";
        $values = array($balanceDate,$bankCode,$bankBalance,$voucherNo);
        if(pdoExecute($sql,$values)){
             $response["status"] = true;
             $response["message"] = "The bank balance was successfully updated"; 
         }else{
            $response["status"] = false;
            $response["message"] = "The bank balance could not be updated"; 
         }
    }
}
else if ($type=="bank_loan"){
    $loanDate = trim($_POST["date"]);
    $loanName = trim($_POST["loanName"]);
    $loanAmount = trim($_POST["loanAmount"]);
    $monthlyInstallments = trim($_POST["monthlyInstallments"]);
    $bank = trim($_POST["bank"]);
    $sql = "INSERT INTO `bank_loans`(`loan_date`, `loan_name`, `loan_amount`, `monthly_installments`, `receiving_bank`, `added_by`, `added_on`) VALUES (?,?,?,?,?,?,NOW())";
    $values = array($loanDate,$loanName,$loanAmount,$monthlyInstallments,$bank,$myUserName);
    if(pdoExecute($sql,$values)){
        $accountNumber = getGlAccountNumber();
        $accountType = 1;
        $accountCategory = 2;
        $accountSubCategory = 5;
        $accountGroup=12;
        $sql = "INSERT INTO `chartofaccounts`(`accountNumber`, `account_type`, `account_category`, `account_sub_category`, `account_group`,`accountName`, `allowPosting`,`added_on`,`added_by`) VALUES (?,?,?,?,?,?,?,NOW(),?)";
		$values = array($accountNumber,$accountType,$accountCategory,$accountSubCategory,$accountGroup,$loanName,1,$myUserName);
			if(pdoExecute($sql,$values)){
			    $response["status"] = true;
                $response["message"] = "The loan was successfully captured"; 
			}else{
			     $response["status"] = false;
                 $response["message"] = "The gl account could not be captured"; 
			}
    }else{
       $response["status"] = false;
       $response["message"] = "The loan could not be captured"; 
    }
    
   
}
else if ($type=="cheque_register"){
    $type = trim($_POST["type"]);
    $id = trim($_POST["id"]);
    $drawerDraweeCode = trim($_POST["drawerDraweeCode"]);
    $chequeNo = trim($_POST["chequeNo"]);
    $issueDate = trim($_POST["issueDate"]);
    $maturityDate = trim($_POST["maturityDate"]);
    $amount = trim($_POST["amount"]);
    $issuingBank = trim($_POST["issuingBank"]);
    
    
    if($id==0){
        $sql = "INSERT INTO `cheque_register`( `type`, `drawerDrawee`, `cheque_no`, `amount`, `issue_date`, `maturity_date`, `issuing_bank`, `added_by`, `added_on`, `banked`) VALUES (?,?,?,?,?,?,?,?,NOW(),?)";
        $values = array($type,$drawerDraweeCode,$chequeNo,$amount,$issueDate,$maturityDate,$issuingBank,$myUserName,0);
        if(pdoExecute($sql,$values)){
             $response["status"] = true;
             $response["message"] = "The cheque was successfully added"; 
         }else{
            $response["status"] = false;
            $response["message"] = "The cheque could not be added"; 
         }
    }else{
        $cheque = fetchWithPdo("select * from cheque_register where id=?",array($id));
        if(count($cheque)<1){
            $response["status"] = false;
            $response["message"] = "The cheque could not be found"; 
        }else{
            $banked = $cheque[0]["banked"];
            if($banked){
                $response["status"] = false;
                $response["message"] = "The cheque has already been banked";
            }else{
                $sql = "update `cheque_register` set  `type`=?, `drawerDrawee`=?, `cheque_no`=?, `amount`=?, `issue_date`=?, `maturity_date`=?, `issuing_bank`=? where id=? and  `banked`=? limit 1";
                $values = array($type,$drawerDraweeCode,$chequeNo,$amount,$issueDate,$maturityDate,$issuingBank,$id,0);
                if(pdoExecute($sql,$values)){
                     $response["status"] = true;
                     $response["message"] = "The cheque was successfully updated"; 
                 }else{
                    $response["status"] = false;
                    $response["message"] = "The cheque could not be updated"; 
                 }
            }
        }
    }
}
else if($type=="expresssalepayment"){
	$saleCode = trim($_POST["saleCode"]);
	$bankCode = trim($_POST["bankCode"]);
	$amount = trim($_POST["amount"]);
	$transactionRef = trim($_POST["transactionRef"]);
	//get receipt, check posted
	$sale = fetchWithPdo("SELECT * FROM `sales_header` WHERE doc_no = ?",array($saleCode));
	if(count($sale)==1){
		if($sale[0]["posted"]){
			$response["status"] = false;
			$response["message"] = "The Sale has already been posted";
		}else{
			$sql = "INSERT INTO `express_sale_payments`(`sales_code`, `bank_code`, `amount`, `transaction_ref`, `added_on`, `added_by`) VALUES (?,?,?,?,NOW(),?)";
			$values = array($saleCode,$bankCode,$amount,$transactionRef,$myUserName);
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The payment was successfully added";
			}else{
				$response["status"] = false;
				$response["message"] = "The payment could not be added";
			}
		}
	}else{
		$response["status"] = false;
		$response["message"] = "The Sale could not be found ";
	}
}

else if ($type=="loan_repayment"){
    $repaymentDate = trim($_POST["repaymentDate"]);
    $accountNo = trim($_POST["accountNo"]);
    $transactionRef = trim($_POST["transactionRef"]);
    $interest = trim($_POST["interest"]);
    $principal = trim($_POST["principal"]);
    $bankCode = trim($_POST["bankCode"]);
    $sql = "INSERT INTO `bank_loan_payments`( `payment_date`, `loan_account`, `paying_bank`, `transaction_ref`, `interest_amount`, `principal_amount`, `added_by`, `added_on`) VALUES (?,?,?,?,?,?,?,NOW())";
    $values = array($repaymentDate,$accountNo,$bankCode,$transactionRef,$interest,$principal,$myUserName);
    if(pdoExecute($sql,$values)){
        $journalNo = getNextNumber(45);
        updateLastNumber(45,$journalNo);
       $jSql = "INSERT INTO `journal`(`journalNo`, `transactionDate`, `createdBy`, `createdOn`, `posted`) VALUES (?,?,?,NOW(),0)";
       $jValues = array($journalNo,$repaymentDate,$myUserName);
      if(pdoExecute($jSql,$jValues)){
          $loanName = getAccountName("glaccount",$accountNo);
          $lines = "INSERT INTO `journallines`( `jounalNo`, `accountType`, `transactionType`, `accountNo`, `externalDocNo`, `description`, `amount`) VALUES (?,?,?,?,?,?,?),(?,?,?,?,?,?,?),(?,?,?,?,?,?,?),(?,?,?,?,?,?,?)";
          $lineValues = array($journalNo,"bank","bank_loan",$bankCode,$transactionRef,"$loanName principal Repayment",$principal*-1);
          $lineValues = array_merge($lineValues,array($journalNo,"glaccount","bank_loan",$accountNo,$transactionRef,"$loanName principal Repayment",$principal));
          
          $lineValues = array_merge($lineValues,array($journalNo,"bank","bank_loan",$bankCode,$transactionRef,"$loanName Interest Repayment",$interest*-1));
          $lineValues = array_merge($lineValues,array($journalNo,"glaccount","bank_loan","KSJ102",$transactionRef,"$loanName Interest Repayment",$interest));
          pdoExecute($lines,$lineValues);
          $response =  postJournal($journalNo,$myUserName);
      }else{
         $response["status"] = false;
         $response["message"] = "The Transaction could not be created";  
      }
    }else{
       $response["status"] = false;
       $response["message"] = "The loan repayment could not be captured"; 
    }
}
else if ($type=="convert_quote"){
    $quoteNo = trim($_POST["quoteNo"]);
    $documentType = trim($_POST["documentType"]);
    $newDocType = trim($_POST["desiredDocumentType"]);//= "SalesInvoice";
    $oldDocType="SalesQuote";
    //check quote exists
    //check has lines
    $headerDetails = fetchWithPdo("SELECT * FROM `sales_header` WHERE doc_no =? AND document_type = ?",array($quoteNo,$oldDocType));
    if(count($headerDetails)<1){
        $response["status"] = false;
		$response["message"] = "The Sales Quote could not be found";
    }else{
        $lines = fetchWithPdo("SELECT * FROM `sales_lines` WHERE header_no =? AND document_type = ?",array($quoteNo,$oldDocType));
        if(count($lines)<1){
            $response["status"] = false;
		    $response["message"] = "The Selected Sales Quote does not have any lines";
        }else{
            $header = $headerDetails[0];
            $customer = $header["customer"];
            $today = new DateTime();
			$docDate = $today->format('Y-m-d');
            $region = $header["region"];
            $salesRep = $header["sales_rep"];
            $sourceLocation = $header["source_location"];
            $destinationLocation = $header["destination_location"];
            $staff = $header["staff"];
            $comment = $header["comment"];
            $reference = $header["reference"];
            $purpose = $header["purpose"];
            $startDate = $header["fromDate"];
            $endDate = $header["toDate"];
            $activity = $header["activity"];
            $target = $header["target"];
            $invoice = $header["credit_note_invoice"];
            $customerName ="";
            $customerPin="";
            
            $docType = fetchWithPdo("SELECT * FROM `document_types` WHERE code = ?",array($newDocType))[0];
            $series = $docType["number_series"];
            $docNo = getNextNumber($series);
            $sql = "INSERT INTO `sales_header`(`doc_no`, `document_type`, `customer`, `sales_date`, `region`, `sales_rep`, `source_location`, `destination_location`, `staff`,`comment`,
            `reference`, `purpose`, `fromDate`, `toDate`, `activity`, `target`, `createdOn`, `createdBy`, `posted`,`credit_note_invoice`, `customer_name`, `customer_pin` ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),?,?,?,?,?)";
            $values = array($docNo,$newDocType,$customer,$docDate,$region,$salesRep, $sourceLocation,$destinationLocation, $staff,$comment,$reference, $purpose,$startDate,$endDate,$activity,$target,$myUserName,0,$invoice,$customerName,$customerPin);
            if(pdoExecute($sql,$values)){
                updateLastNumber($series, $docNo);
                 $sql = "";
             $lineValues = array();
             foreach($lines as $line){
                 $sql.=strlen($sql)>0?",":"";
                 $sql.="(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())";
                 $lineValues = array_merge($lineValues,array($docNo,$newDocType,$line["itemType"],$line["itemNo"],$line["description"],$line["unitOfMeasureCode"],$line["details"],$line["unitPrice"],$line["discount"],$line["requested_quantity"],$line["issued_quantity"],$line["opening_stock"],$line["issued_stock"],$line["warehouse_return"],$line["free_issues"],$line["closing_stock"],$line["missing_bottles"],$line["quantity"],$line["totalExclVAT"],$line["totalVAT"],$line["totalAmount"],$line["kilometres"],$line["vehicle"],$myUserName));
             }
             $sql = "INSERT INTO `sales_lines`( `header_no`, `document_type`, `itemType`, `itemNo`, `description`, `unitOfMeasureCode`, `details`, `unitPrice`, `discount`, `requested_quantity`, 
             `issued_quantity`, `opening_stock`, `issued_stock`, `warehouse_return`, `free_issues`, `closing_stock`, `missing_bottles`, `quantity`, `totalExclVAT`, `totalVAT`, `totalAmount`,
             `kilometres`, `vehicle`, `created_by`, `createdOn`) VALUES $sql";
             if(pdoExecute($sql,$lineValues)){
                 updateInvoiceTotal($docNo);
				$response["status"] = true;
				$response["message"] ="The document was successfully created";
				//mark converted
				$updateVoucher = "update `sales_header` set posted=1,postedOn = NOW(),postedby=?,status=? where doc_no = ?";
				$values = array(1,"Approved",$quoteNo);
				pdoExecute($updateVoucher,$values);
				
			}else{
				$response["status"] = false;
				$response["message"] ="The lines could not be created";
			}
			
                //copy lines
            }else{
                $response["status"] = false;
		        $response["message"] = "The new document could not be created";
            }
        }
    }
    
    
}
else if ($type=="initializeetims"){
	include("etims.php");
	$branchId = trim($_POST["branchId"]);
	$serialNo = trim($_POST["serialNo"]);
	
	$initData = initialize($branchId,$serialNo);
	$response["status"] = false;
	//print_r($initData);
	if(isset($initData["resultMsg"])){
		$resultCd = $initData["resultCd"];
		if($resultCd=="902"){
			$response["status"] = true;
		}
		$response["message"] = $initData["resultMsg"];
	}else{
		$response["message"] = "We encountred an error while processing your request";
	}
	
}
else if ($type=="etimsdetails"){
	$jarFile = trim($_POST["jarFile"]);
	$etimsServer = trim($_POST["etimsServer"]);
	$kraPin = trim($_POST["kraPin"]);
	$branchId = trim($_POST["branchId"]);
	$serialNo = trim($_POST["serialNo"]);
	pdoExecute("UPDATE `shopLocations` set `etims_device_serial` =? WHERE `etims_branch_code`= ? ",array($serialNo,$branchId));
	$check = fetchWithPdo("SELECT * FROM `etims_details` WHERE id = 1; ",array());
	if(count($check)>0){
		$sql = "update `etims_details` set `jar_file`=?, `etims_server`=?, `kra_pin`=?, `branch_id`=?, `serial_no`=? where `id` =?";
		$values = array($jarFile,$etimsServer,$kraPin,$branchId,$serialNo,1);
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["message"] ="The E-Tims details were successfully updated";
		}else{
			$response["status"] = false;
			$response["message"] = "The E-Tims details could not be updated";
		}
	}else{
		$sql = "INSERT INTO `etims_details`(`id`, `jar_file`, `etims_server`, `kra_pin`, `branch_id`, `serial_no`) VALUES (?,?,?,?,?,?)";
		$values = array(1,$jarFile,$etimsServer,$kraPin,$branchId,$serialNo);
		if(pdoExecute($sql,$values)){
			$response["status"] = true;
			$response["message"] ="The E-Tims details were successfully added";
		}else{
			$response["status"] = false;
			$response["message"] = "The E-Tims details could not be added";
		}
	}

}
else if ($type=="update_etims_stock"){
	include("etims.php");
	$itemCode = trim($_POST["itemCode"]);
	$confirmedQuantity = trim($_POST["confirmedQuantity"]);
	$branchId = getEtimsDetails()["branch_id"];
	$updated = updateStock($branchId,$itemCode,$confirmedQuantity);
	if($updated=="Successful"){
		$response["status"] = true;
		$response["message"] = "The stock was successfully updated";
	}else{
		$response["status"] = false;
		$response["message"] = "The stock could not be updated";
	}
}
else if ($type=="send_item_to_etims"){
	
	//include("etims.php");
	$productCode = trim($_POST["productCode"]);
	$product = fetchWithPdo("SELECT * FROM `items` WHERE code = ?",array($productCode))[0];
	$branchId = getEtimsDetails()["branch_id"];
	/*$itemClass = $product["item_class"];
	$myItemType = $product["item_type"];
	$name= $product["name"];
	$country = $product["origin_country"];
	$myPackaging= $product["packaging_unit"];
	$uom = $product["unitOfMeasure"];
	$taxGroup = $product["taxGroup"];*/
	$price = $product["price"];
	$price1=$price2=$price3=$price4=$price5=$price;
	$pricingGroupEntries = fetchWithPdo("SELECT * FROM `pricing_group_entries` WHERE product_code = ?",array($productCode));
	if(count($pricingGroupEntries)>0){$price1 = $pricingGroupEntries[0]["selling_price"];}
	if(count($pricingGroupEntries)>1){$price2 = $pricingGroupEntries[1]["selling_price"];}
	if(count($pricingGroupEntries)>2){$price3 = $pricingGroupEntries[2]["selling_price"];}
	if(count($pricingGroupEntries)>3){$price4 = $pricingGroupEntries[3]["selling_price"];}
	if(count($pricingGroupEntries)>4){$price5 = $pricingGroupEntries[4]["selling_price"];}
	$response = sendItemToEtims($branchId,$productCode,$price,$price1,$price2,$price3,$price4,$price5);
	//$response = createItem($branchId,$productCode,$itemClass,$myItemType,$name,$name,$country,$myPackaging,$uom,$taxGroup,null,null,$price,$price1,$price2,$price3,$price4,$price5,null,null,"N","Y");
}
else if ($type=="add_etims_user"){
	include("etims.php");
	$branchId = trim($_POST["branchId"]);
    $userId = trim($_POST["userId"]);
    $userName = trim($_POST["userUserName"]);
    $userPassword = trim($_POST["userPassword"]);
    $userAddress = trim($_POST["userAddress"]);
    $userContact = trim($_POST["userContact"]);
    $authCd = trim($_POST["authCd"]);
    $remark = trim($_POST["remark"]);
    $useYN = trim($_POST["useYN"]);
    $regrNm = trim($_POST["regrNm"]);
    $regrId = trim($_POST["regrId"]);
    $modrNm = trim($_POST["modrNm"]);
    $modrId = trim($_POST["modrId"]);

	$etims_response = saveBranchUser($branchId,$userId,$userName,$userPassword,$userAddress,$userContact,$authCd,$remark,$useYN,$regrNm,$regrId,$modrNm,$modrId);

	if($etims_response["resultCd"]=="000"){
		$response["status"] = true;
		$response["message"] = "The user was succesfully added";
	}else{
		$response["status"] = false;
		$response["message"] = "The user could not be added\n".json_encode($etims_response["resultMsg"]);
	}
}
else if ($type=="add_etims_insurance"){
	include("etims.php");
	$branchId = trim($_POST["branchId"]);
    $insuranceCode = trim($_POST["insuranceCode"]);
    $insuranceName = trim($_POST["insuranceName"]);
    $isrcRt = trim($_POST["isrcRt"]);
    $useYN = trim($_POST["useYN"]);
    $regrNm = trim($_POST["regrNm"]);
    $regrId = trim($_POST["regrId"]);
    $modrNm = trim($_POST["modrNm"]);
    $modrId = trim($_POST["modrId"]);
	$etims_response = saveBranchInsurance($branchId,$insuranceCode,$insuranceName,$isrcRt,$useYN,$regrNm,$regrId,$modrNm,$modrId);

	if($etims_response["resultCd"]=="000"){
		$response["status"] = true;
		$response["message"] = "The Insurance was succesfully added";
	}else{
		$response["status"] = false;
		$response["message"] = "The Insurance could not be added\n".json_encode($etims_response["resultMsg"]);
	}
}
else if ($type=="add_product_composition"){
	include("etims.php");
	$itemCd = trim($_POST["parent"]);
    $cpstItemCd = trim($_POST["compositionItem"]);
    $cpstQty = trim($_POST["compositionQuantity"]);
    $regrNm ="Admin";
    $regrId = "Admin";
    $branchId = "00";
	$etims_response = addItemComposition($branchId,$itemCd,$cpstItemCd,$cpstQty,$regrNm,$regrId);

	if($etims_response["resultCd"]=="000"){
		$response["status"] = true;
		$response["message"] = "The composition was succesfully added";
	}else{
		$response["status"] = false;
		$response["message"] = "The composition could not be added\n".json_encode($etims_response["resultMsg"]);
	}
}
else if ($type=="stock_take"){
        ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
    $locationCode = trim($_POST["locationCode"]);
    $selectedDate = trim($_POST["selectedDate"]);
    //check no record for the warehouse and date
    $check = fetchWithPdo("SELECT * FROM `stock_take` WHERE `date`=? AND `warehouse`=?",array($selectedDate,$locationCode));
    if(count($check)>0){
        $response["status"] = false;
        $response["message"] = "A stock take for the selected warehouse and date already exists";
    }else{
        $recNo = getNextNumber(201);
        $sql = "INSERT INTO `stock_take`(`doc_no`, `date`, `warehouse`, `closed`, `created_on`, `created_by`) VALUES (?,?,?,?,NOW(),?)";
        $values = array($recNo,$selectedDate,$locationCode,0,$myUserName);
        if(pdoExecute($sql,$values)){
            updateLastNumber(201,$recNo);
           $linesAdded =  createStockTakeLines($recNo,$selectedDate,$locationCode,$myUserName);
           if($linesAdded){
                $response["status"] = true;
                $response["message"] = "The stock take was successfully created";
                $response["overLoad1"] = $recNo;
           }else{
               $response["status"] = false;
               $response["message"] = "The lines could not be created";
           }
            
        }else{
            $response["status"] = false;
            $response["message"] = "The stock take could not be created";
        }
    }
}
else if ($type=="excelimport"){
    ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
    if(isset($_POST["recordType"])){
    $recordType = $_POST["recordType"];
     if($recordType=="item"){
		//Item No.	Item Name	Buying Price	Selling Price	Discount	UPC Code	Country	Brand	Unit of measure	Packaging Unit	Tax Group	Classification	Item Type	Posting Group	Re Order level
        $code = trim($_POST["column1"]);
        $name = trim($_POST['column2']);
        $description = $name;
		$buyingPrice = doubleval(trim($_POST['column3']));
		$price = doubleval(trim($_POST['column4']));
		$discount = doubleval(trim($_POST['column5']));
		$upc = trim($_POST['column6']);
		$country = trim($_POST['column7']);
        $brand = intval(trim($_POST['column8']));
	    $uom = trim($_POST['column9']);
	    $myPackaging = trim($_POST['column10']);
	    $taxGroup = trim($_POST['column11']);
	    $itemClass = intval(trim($_POST['column12']));
	    $myItemType = intval(trim($_POST['column13']));
        $postingGroup = intval(trim($_POST['column14']));
        $reOrderLevel = intval(trim($_POST['column15']));
		$photo = "";
		$imageName = "";
		$extension = explode(".",$imageName);
		$reOrderLevel =0;
		if(strlen($code)>0 && strlen($buyingPrice)>0 && strlen($price)>0 && strlen($discount)>0 && strlen($taxGroup)>0 && strlen($brand)>0 && strlen($uom)>0 && strlen($postingGroup)>0 && strlen($country)>0 && strlen($itemClass)>0 && strlen($myItemType)>0 && strlen($myPackaging)>0){
			if(isset($_POST["reOrderLevel"])){
			    $reOrderLevel =$_POST["reOrderLevel"]; 
			}
			if(strlen($code)<5){
			   $code = $country.$myItemType.$myPackaging.$uom.$code;
			}
			$image="";
			$sql = "";
			
			$uploadImage = false;
			if (!is_null($code)) {
				$res = mysqli_query($conn, "SELECT * FROM `items` WHERE code = '$code'");
				if (mysqli_num_rows($res)>0) {// update
				$sql = "UPDATE items SET `name`='$name', `description`='$description',`unitOfMeasure`='$uom',`taxGroup`='$taxGroup',
					`brand`='$brand',`postingGroup`='$postingGroup',`origin_country`='$country', `item_class`='$itemClass', `item_type`='$myItemType', `packaging_unit`='$myPackaging',`buying_price`='$buyingPrice',`price`='$price', `percentageDiscount`='$discount', `upcCode`='$upc',`reOrderLevel` = ? WHERE  `code` = '$code'";
					$values = array($reOrderLevel);
					$result = pdoExecute($sql,$values);//mysqli_query($conn, "");
					if ($result) {
						$response["status"] = true;
						$response["message"] = "Item has been updated successfully";
						$uploadImage = false;
					}else{
						$response["status"] = false;
						$response["message"] = "Item could not be updated";
					}
				}else{//create
					$result = mysqli_query($conn, "INSERT INTO `items`(`code`, `name`, `description`, `unitOfMeasure`, `taxGroup`, `brand`, `postingGroup`,`origin_country`, `item_class`, `item_type`, `packaging_unit`,`buying_price`, `price`, `percentageDiscount`, `photo`, `photoUrl`,`upcCode`,`reOrderLevel`,`addedOn`, `addedBy`) VALUES
					('$code', '$name', '$description', '$uom', '$taxGroup', '$brand','$postingGroup','$country','$itemClass','$myItemType','$myPackaging','$buyingPrice', '$price', '$discount','','', '$upc','$reOrderLevel',NOW(),'$myUserName')");
					if ($result) {
						$response["status"] = true;
						$response["message"] = "Item has been added successfully";
						$uploadImage = false;
						$price1=$price2=$price3=$price4=$price5=$price;
						sendItemToEtims("00",$code,$price,$price1,$price2,$price3,$price4,$price5);
						$response["message"] = "Item has been added successfully";
					}else{
						$response["status"] = false;
						$response["message"] = "Item could not be added ".mysqli_error($conn);
					}
				}
				if($uploadImage){
				    	try{
				    	    if(strlen($photo)>0){
    				    	    $fileName = "itemimages/".$code.".".$extension[1];
    		            	    file_put_contents($fileName,base64_decode($photo));
    		            	    $update = "update items set photoUrl =? where code=?";
    		            	    $values = array($fileName,$code);
    		            	    pdoExecute($update,$values);
				    	    }
    		        	}catch(Exception $t){
						
    		        	}
				}
			}
		}else{
			$response["status"] = false;
			$response["message"] = "Kindly Fill All fields ";
		}  
    	}
         else if($recordType=="customer"){//"fixedassets"){
            //Class	USER	MONTH	LOCATION	Acquisition GL	Depreciation GL		 VALUE 
            $faNo = trim($_POST["column1"]);
            $serialNumber = trim($_POST["column2"]);
            $faName = trim($_POST["column3"]);
            $class = trim($_POST["column4"]);
            $assignedTo = trim($_POST["column5"]);
            $acquireDdate = trim($_POST["column6"]);
            $location = trim($_POST["column7"]);
            $acquisitionGlAccount = trim($_POST["column8"]);
            $apprDeprGlAccount = trim($_POST["column9"]);
            $description=$faName;
            $acquireDdate = excelDateToDate($acquireDdate);
        $image="";
        $sql = "INSERT INTO `fixedassets`(`faNo`, `fixedAssetName`,`Description`, `Serial Number`, `Date Acquired`, `assignedTo`, `Location`, `acquisition_gl_account`,`appr_depr_gl_account`, `Added by`, `Added on`, `active`, `photo`) VALUES (?,?,?,?,?,?,?,?,?,?,NOW(),?,?)";
		$values = array ($faNo,$faName, $description, $serialNumber,$acquireDdate,$assignedTo, $location, $acquisitionGlAccount,$apprDeprGlAccount, $myUserName,1,$image );
		if(pdoExecute($sql, $values)){	
			$response["status"] = true;
			$response["message"] = "The asset was successfully added ";
		}else{
			$response["status"] = false;
			$response["message"] = "The asset could not be added. Please try again. ";
		}
        }
    else if($recordType=="customer"){
        $custNo = trim($_POST["column1"]);
	    $customerName =trim($_POST["column2"]);
	    $idNo =  trim($_POST["column3"]); 
	    $kraPin=trim($_POST["column4"]); 
	    $phoneNo =  trim($_POST["column5"]); 
		$customerEmail =trim($_POST["column6"]); 
		$dob = excelDateToDate(trim($_POST["column7"])); 
		$postingGroup = trim($_POST["column8"]); 
		$region = trim($_POST["column9"]); 
		$salesAgent = trim($_POST["column10"]); 
		$creditLimit = doubleval(trim($_POST["column11"])); 
	    $creditPeriod = intval(trim($_POST["column12"])); 
		$contactPerson = trim($_POST["column13"]); 
		$contactPhone = trim($_POST["column14"]); 
		$contactPosition = trim($_POST["column15"]); 
		$contactEmail = "";
		$phoneNo = intval($phoneNo);
		$phoneNo="0".$phoneNo;
	    $pricingGroup =1;  
	    $postingGroup = intval($postingGroup);
		$location = "";
		$locationLatitude =0;
		$locationLongitude = 0;
		$photo = "";
		$remarks = "";
		
		if(strlen($dob)<1){
			$dob = null;
		}
			$sql = "INSERT INTO `customers` (`customerNumber`, `customerName`, `idNo`, `kraPin`, `dateofbirth`, `phoneNumber`,`pricing_group`,`creditLimit`, `creditPeriod`,  `email`, `location`, `location_latitude`, `location_longitude`, 
		    `contactName`, `jobPosition`, `contactPhone`, `contactEmail`,  `customerpostinggroup`, `customerImage`, `salesAgent`, `region`, `addedBy`, `addedOn`,`remarks`) 
			VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),?)"; 

			$values = array();
			array_push($values, $custNo);
			array_push($values, $customerName);
			array_push($values, $idNo);
			array_push($values, $kraPin);
			array_push($values, $dob);
			array_push($values, $phoneNo);
			array_push($values, $pricingGroup);
			array_push($values, $creditLimit); 
			array_push($values, $creditPeriod);
			array_push($values, $customerEmail);
			array_push($values, $location);
			array_push($values, $locationLatitude);
			array_push($values, $locationLongitude);
			array_push($values, $contactPerson);
			array_push($values, $contactPosition);
			array_push($values, $contactPhone);
			array_push($values, $contactEmail);
			array_push($values, $postingGroup);
			array_push($values, $photo);
			array_push($values, $salesAgent);
			array_push($values, $region);
			array_push($values, $myUserName);
			array_push($values, $remarks);
			if(pdoExecute($sql,$values)){
				$response["status"] = true;
				$response["message"] = "The customer was successfully added";
			}else{
				$response["status"] = false;
				$response["message"] = "The customer could not be added. Please try again";
			}
		
    }
    else if($recordType=="generalvendor"){
        $vendorNumber = trim($_POST["column1"]);
        $name = trim($_POST["column2"]);
        $idNo = trim($_POST["column3"]);
        $pin = trim($_POST["column4"]);
        $dob = trim($_POST["column5"]);
        $phoneNo = trim($_POST["column6"]);
        $email = trim($_POST["column7"]);
        
        $postingGroup = trim($_POST["column8"]);
        $bankName = trim($_POST["column9"]);
        $bankBranch = trim($_POST["column10"]);
        $branchCode = trim($_POST["column11"]);
        $bankAccountNo = trim($_POST["column12"]);
        $vendorType = trim($_POST["column13"]);
        $region = trim($_POST["column14"]);
        $contactPerson = trim($_POST["column15"]);
        if(is_numeric($postingGroup)){
			$postingGroup = intval($postingGroup);
		}
        $photo="";
        $contactPosition="";
        $contactPhone="";
        $contactEmailAddress="";
        $remarks="";
        $sql = "INSERT INTO `vendors`(`vendorNumber`, `name`,`idNo`, `kraPin`, `dateofbirth`, `phoneNumber`, `email`,  `vendorImage`, `vendorpostinggroup`, `bankName`, `bankBranch`, `branchCode`,`bankAccountNo`,`vendortype`,`regionCode`,`contactName`, `jobPosition`, `contactPhone`, `contactEmail`, `remarks`,`createdOn`,`createdBy`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),?)";
		$values = array($vendorNumber,$name,$idNo,$pin, $dob, $phoneNo,$email,$photo,$postingGroup,$bankName,$bankBranch,$branchCode,$bankAccountNo,$vendorType,$region,$contactPerson,$contactPosition,$contactPhone,$contactEmailAddress,$remarks,$myUserName);
		if(pdoExecute($sql, $values)){
			$response["status"] = true;
			$response["message"] = "The vendor was successfully created";
		}else{
			$response["status"] = false;
			$response["message"] = "The vendor could not be created";
		}
    }
    
    else if($recordType=="journal"){
        //Date	Account Type	Account No	Account Name	Transaction Type	External Doc. No.	Description	Amount	Balancing Account Type	Balancing Account No	Balancing Account Name	Balancing Transaction Type
        $journalDate = trim($_POST["column1"]);
        $journalDate = excelDateToDate($journalDate);
        $accountType = trim($_POST["column2"]);
        $accountNo = $_POST["column3"];
        if(is_numeric($accountNo)){
			$accountNo = intval($accountNo);
		}else{
		    $accountNo = trim($accountNo);
		}
        $accountName = trim($_POST["column4"]);
        $transactionType = $_POST["column5"];
        if(is_numeric($transactionType)){
			$transactionType = intval($transactionType);
		}else{
		    $transactionType = trim($transactionType);
		}
        $externalDocNo = trim($_POST["column6"]);
        $description = trim($_POST["column7"]);
        $amount = trim($_POST["column8"]);
        $balancingAccountType = trim($_POST["column9"]);
        $balancingAccountNo = $_POST["column10"];
        if(is_numeric($balancingAccountNo)){
			$balancingAccountNo = intval($balancingAccountNo);
		}else{
		    $balancingAccountNo = trim($balancingAccountNo);
		}
        $balancingAccountName = trim($_POST["column11"]);
        $balancingTransactionType = trim($_POST["column12"]);
        $regNo="";
        $journalNo = getNextNumber(45);
	    $sql = "insert into journal (`journalNo`,`transactionDate`,`createdOn`,`createdBy`) values (?,?,NOW(),?)";
	    $values = array($journalNo,$journalDate,$myUserName);
	    if(pdoExecute($sql,$values)){
	        updateLastNumber(45,$journalNo);
	        $sql = "insert into journallines (`jounalNo`,`accountType`,`transactionType`,`accountNo`,`externalDocNo`,`description`,`amount`,`vehicle_no`) values(?,?,?,?,?,?,?,?),(?,?,?,?,?,?,?,?)";
	        //$values = array($journalNo,"loan","311",$memberNo,$receiptNo,$description,$amount,$regNo,$journalNo,"glaccount","311","OP001",$receiptNo,$description,$amount*-1,$regNo);
	        $values = array($journalNo,$accountType,$transactionType,$accountNo,$externalDocNo,$description,$amount,$regNo,$journalNo,$balancingAccountType,$balancingTransactionType,$balancingAccountNo,$externalDocNo,$description,$amount*-1,$regNo);
	        if(($amount<>0) && strlen($accountNo)>0){
	            if(pdoExecute($sql, $values)){
	                $response = postJournal($journalNo,$myUserName);
	            }
	        }
	        
	    }
        
        
    }
     else if($recordType=="employee"){
        // Employee No	First Name	Middle Name	Last Name	phone	Email Address	Date of Birth	ID No	Gender	Region	Department	Employment date	Employment Status	POSITION
        $employeeNo = trim($_POST["column1"]);
        $firstName = trim($_POST["column2"]);
        $middleName = trim($_POST["column3"]);
        $lastName = trim($_POST["column4"]);
        $phoneNumber = trim($_POST["column5"]);
        $emailAddress = trim($_POST["column6"]);
        $dateOfBirth = trim($_POST["column7"]);
        $idNo = trim($_POST["column8"]);
        $gender = trim($_POST["column8"]);
        $region = trim($_POST["column10"]);
        $department = trim($_POST["column11"]);
        $employmentDate = trim($_POST["column12"]);
        $employmentStatus = trim($_POST["column13"]);
        $position = trim($_POST["column14"]);
        
        $region = intval($region);
        $department = intval($department);
        $idNo = intval($idNo);
        $phoneNumber = intval($phoneNumber);
        $dateOfBirth = excelDateToDate($dateOfBirth);
        $employmentDate = excelDateToDate($employmentDate);
        $payrollNo="";
        $kraPin = "";
        $disabled=0;
        $disabilityDesc = "";
        $goodConduct = "";
        $hod = 0;
        $nhifNo="";
        $nssfNo = "";
        $photo = "";
        $bank = "";
        $bankBranch = "";
        $bankAccountNo = "";
        $basicSalary = 0;
        $paysPaye = 1;
        $paysNHIF = 1;
        $paysNssf = 1;
        $suspendPay = 0;
        $exited=0;
        $jobGroup = 0;
        
        $sql = "INSERT INTO `employee`(`EmployeeNumber`, `first_name`, `middle_name`, `last_name`, `IdNumber`, `gender`, `payroll_number`, `date_of_birth`, `Pin`, `PhoneNumber`,
        `Email`, `disabled`, `disability_description`, `department`, `job_title`, `good_conduct`, `hod`, `NHIFNo`, `NSSFNo`, `Photo`, `Bank`, `BankBranch`, 
        `AccountNumber`, `BasicSalary`, `PaysPaye`, `paysNHIF`, `paysNSSF`, `suspendPay`, `exited`, `EmploymentDate`, `JobGroup`, `AddedOn`, `AddedBy`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),?)";
        $values = array($employeeNo,$firstName,$middleName,$lastName,$idNo,$gender,$payrollNo,$dateOfBirth,$kraPin,$phoneNumber,$emailAddress,$disabled,$disabilityDesc,$department,$position,
        $goodConduct,$hod,$nhifNo,$nssfNo,$photo,$bank,$bankBranch,$bankAccountNo,$basicSalary,$paysPaye,$paysNHIF,$paysNssf,$suspendPay,$exited,$employmentDate,$jobGroup,$myUserName);
        if(pdoExecute($sql,$values)){
            echo "The employee was successfully added";
        }else{
            echo "The employee could not be added";
        }
        
    }
    else if($recordType=="payrollemployee"){
        //Employee No	Payroll No	NSSF No	KRA PIN	NHIF No	NSSF No	Bank Code	bank Name	Branch	Account No	 BASIC 
        $employeeNo = trim($_POST["column1"]);
        $payrollNo = trim($_POST["column2"]);
        $kraPin = trim($_POST["column3"]);
        $nhifNo = trim($_POST["column4"]);
        $nssfNo = trim($_POST["column5"]);
        $bankCode = trim($_POST["column6"]);
        $bankName = trim($_POST["column7"]);
        $bankBranch = trim($_POST["column8"]);
        $accountNo = trim($_POST["column9"]);
        $basicSalary = trim($_POST["column10"]);
        
        $basicSalary = intval($basicSalary);
        $accountNo = intval($accountNo);
        $sql = "update employee set `payroll_number`=?,`Pin`=?,`NHIFNo`=?, `NSSFNo`=?, `Bank`=?, `BankBranch`=?, `AccountNumber`=?, `BasicSalary`=? where EmployeeNumber=? limit 1";
        $values = array($payrollNo,$kraPin,$nhifNo,$nssfNo,$bankName,$bankBranch,$accountNo,$basicSalary,$employeeNo);
        if(pdoExecute($sql,$values)){
            echo "The employee was successfully updated";
        }else{
            echo "The employee could not be updated";
        }
    }
    else if($recordType=="salesInvoice"){
        $invoiceDate = trim($_POST["column1"]);
        $invoiceDate = excelDateToDate($invoiceDate);
        $ref = trim($_POST["column2"]);
        $customerNo = trim($_POST["column3"]);
        $itemType = trim($_POST["column5"]);
        $itemCode = trim($_POST["column6"]);
        $description = trim($_POST["column7"]);
        $amount = trim($_POST["column8"]);
        $docNo = trim($_POST["column9"]);
        if(is_numeric($ref)){
			$ref = intval($ref);
		}
		if(is_numeric($docNo)){
			$docNo = intval($docNo);
		}
		if(is_numeric($itemCode)){
			$itemCode = intval($itemCode);
		}
		
		$docType="salesInvoice";
		$region="";
		$customerDetails = fetchWithPdo("SELECT salesAgent FROM `customers` WHERE customerNumber =?",array($customerNo));
		$salesRep= "";
		if(count($customerDetails)>0){
		    $salesRep=$customerDetails[0]["salesAgent"];
		}
		$sql = "INSERT INTO `sales_header`(`doc_no`, `document_type`, `customer`, `sales_date`, `region`, `sales_rep`, `source_location`, `destination_location`, `staff`,`comment`, `reference`, `purpose`, `fromDate`, `toDate`, `activity`, `target`, `createdOn`, `createdBy`, `posted`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),?,?)";
        $values = array($docNo,$docType,$customerNo,$invoiceDate,$region,$salesRep, 1,1, "","",$ref, "",$invoiceDate,$invoiceDate,"","",$myUserName,0);
        if(pdoExecute($sql,$values)){
            //add line
            //addSalesLine($headerNo,$itemType,$itemNo,$documentType,$description,$unitOfMeasure,$details,$unitPrice,$requestedQuantity,$issuedQuantity,$quantity,$myUserName)
            $addLine = addSalesLine($docNo,$itemType,$itemCode,$docType,$description,"","",$amount,1,1,1,$myUserName);
            if($addLine["status"]){
                $response = postSalesHeader($docNo,$docType,$myUserName);
            }else{
                $response=$addLine;
            }
            
        }
        
        //Date	Vch/Bill No	Customer No	Account	Type	Item Code	Description	 Amount 
    }
    
    
    //echo json_encode($_POST); 
    }else{
     $recordType = $_GET["recordType"];
     if($recordType=="salesline"){
         $request1= file_get_contents('php://input');//json_encode($_REQUEST);
         $request = json_decode($request1, true);
         $response = array();
         $errorEntries = array();
         if(is_array($request)){   
            $list = $request["data"];
            foreach($list as $entry){
                if(isset($entry[0])&&isset($entry[2])){
                  $headerNo=$_GET["headerNo"];
                  $itemNo =trim($entry[0]);
                  $quantity = $entry[2];
                  if(strlen($itemNo)>0){
                      //print_r($entry);
                      addSalesLine($headerNo,"Items",$itemNo,"StockRequest","","","",0,$quantity,$quantity,$quantity,$myUserName);
                  }   
                }
            }
        }
     }
    }
}

// 

 }//end login if

echo json_encode($response);